/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.spi.plugin;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.remote;
import com.mathworks.toolbox.distcomp.remote.Command;
import com.mathworks.toolbox.distcomp.remote.DispatchException;
import com.mathworks.toolbox.distcomp.remote.Environment;
import com.mathworks.toolbox.distcomp.remote.Future;
import com.mathworks.toolbox.distcomp.remote.InvalidValueException;
import com.mathworks.toolbox.distcomp.remote.LocalProcessFailedException;
import com.mathworks.toolbox.distcomp.remote.Logger;
import com.mathworks.toolbox.distcomp.remote.Parameter;
import com.mathworks.toolbox.distcomp.remote.ParameterImpl;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.ParameterNotAllowedException;
import com.mathworks.toolbox.distcomp.remote.ParameterSet;
import com.mathworks.toolbox.distcomp.remote.RequiredParameterMissingException;
import com.mathworks.toolbox.distcomp.remote.ShellCommand;
import com.mathworks.toolbox.distcomp.remote.spi.ShellCommandSender;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.ProcessShellFuture;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.ShellParameter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public final class RshShellSender
implements ShellCommandSender {
    private static final String PROTOCOL_NAME = "rsh";
    private static final String PROTOCOL_TYPE = "rsh";
    private static final String RESOURCE_BASE_NAME = "com.mathworks.toolbox.distcomp.remote.resources.RES_remote";
    private static final ResourceBundle fResourceBundle = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.remote.resources.RES_remote");
    private static ParameterSet RSH_PARAMETER_SET = new ParameterSet(RshParameter.REMOTE_USER_NAME, RshParameter.RSH_COMMAND, ShellParameter.FREE_FORM_PARAMETERS, ShellParameter.LOCAL_ENVIRONMENT);

    @Override
    public ParameterSet getParameterSet() {
        return RSH_PARAMETER_SET;
    }

    @Override
    public String getProtocolName() {
        return "rsh";
    }

    @Override
    public String getProtocolType() {
        return "rsh";
    }

    @Override
    public Class<? extends Command> getCommandClass() {
        return ShellCommand.class;
    }

    @Override
    public ProcessShellFuture sendAndRun(ShellCommand shellCommand, String string, ParameterMap parameterMap) throws InvalidValueException, LocalProcessFailedException, ParameterNotAllowedException, RequiredParameterMissingException {
        String string2;
        parameterMap.checkParameters(RSH_PARAMETER_SET);
        String string3 = parameterMap.get(RshParameter.RSH_COMMAND);
        if (string3 == null) {
            string3 = RshParameter.RSH_COMMAND.getSuggestedValue();
        } else if (!new File(string3).exists()) {
            throw new MissingRshCommandException(string3);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string3);
        arrayList.add(string);
        String string4 = parameterMap.get(RshParameter.REMOTE_USER_NAME);
        if (string4 != null) {
            arrayList.add("-l");
            arrayList.add(string4);
        }
        if ((string2 = parameterMap.get(ShellParameter.FREE_FORM_PARAMETERS)) != null) {
            arrayList.add(string2);
        }
        List<String> list = shellCommand.getCommand();
        arrayList.addAll(list);
        ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
        Environment environment = parameterMap.get(ShellParameter.LOCAL_ENVIRONMENT);
        if (environment != null) {
            if (environment.clearBeforeSetting()) {
                processBuilder.environment().clear();
            }
            for (String charSequence : environment.keySet()) {
                processBuilder.environment().put(charSequence, environment.get(charSequence));
            }
        }
        try {
            Process process = processBuilder.start();
            StringBuilder stringBuilder = new StringBuilder();
            for (String string5 : arrayList) {
                stringBuilder.append(string5);
                stringBuilder.append(" ");
            }
            ProcessShellFuture processShellFuture = new ProcessShellFuture(process, false, stringBuilder.toString(), string);
            Logger.LOGGER.fine(string + " " + stringBuilder.toString() + " started");
            return processShellFuture;
        }
        catch (IOException iOException) {
            throw new CouldNotStartRshCommandException(arrayList, iOException);
        }
    }

    @Override
    public Future execute(Command command, String string, ParameterMap parameterMap) throws DispatchException {
        return this.sendAndRun((ShellCommand)command, string, parameterMap);
    }

    private static final class CouldNotStartRshCommandException
    extends LocalProcessFailedException {
        private final BaseMsgID fBaseMsgID = new remote.CouldNotStartRshCommand(this.getFormattedCommand());

        CouldNotStartRshCommandException(List<String> list, IOException iOException) {
            super(list, iOException);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class MissingRshCommandException
    extends InvalidValueException {
        private final BaseMsgID fBaseMsgID;

        MissingRshCommandException(String string) {
            this.fBaseMsgID = new remote.MissingRshCommand(fResourceBundle.getObject("RshParameter.RSH_COMMAND.KEY").toString(), string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    public static class RshParameter<V>
    extends ParameterImpl<V> {
        public static final Parameter<String> REMOTE_USER_NAME = new RshParameter<String>(Key.REMOTE_USER_NAME, false, true, String.class, System.getProperty("user.name"));
        public static final Parameter<String> RSH_COMMAND = new RshParameter<String>(Key.RSH_COMMAND, false, false, String.class, "rsh");

        private RshParameter(Parameter.PersistentKey persistentKey, boolean bl, boolean bl2, Class<V> clazz, V v) {
            super(persistentKey, bl, bl2, clazz, v);
        }

        @Override
        protected String getSimpleName() {
            return RshParameter.class.getSimpleName();
        }

        private static enum Key implements Parameter.PersistentKey
        {
            REMOTE_USER_NAME,
            RSH_COMMAND;

        }
    }
}

