/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.util;

import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.Log;
import com.mathworks.toolbox.distcomp.remote.Logger;
import com.mathworks.toolbox.distcomp.remote.Parameter;
import com.mathworks.toolbox.distcomp.remote.ParameterImpl;
import com.mathworks.toolbox.distcomp.remote.util.MatlabRootUnknownException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;

public class PathUtils {
    private static final String MATLAB_ROOT_PROPERTY = "matlabroot";
    private static final String MATLAB_ROOT_ENV_KEY = "MATLABROOT";
    private static final int BUFFER_SIZE = 16384;

    public static String findMatlabRoot(String string) throws MatlabRootUnknownException {
        if (string == null) {
            string = System.getProperty(MATLAB_ROOT_PROPERTY);
        }
        if (string == null) {
            string = System.getenv(MATLAB_ROOT_ENV_KEY);
        }
        if (string == null) {
            throw new MatlabRootUnknownException();
        }
        return string;
    }

    public static boolean waitForFile(File file, int n) throws InterruptedException {
        long l = System.currentTimeMillis() + (long)n;
        while (!file.exists() && System.currentTimeMillis() < l) {
            long l2 = Math.max(0L, l - System.currentTimeMillis());
            Thread.sleep(Math.min(200L, l2));
        }
        return file.exists();
    }

    public static void copy(File file, File file2, boolean bl) throws IOException {
        if (!file.exists()) {
            throw new IOException("Source path does not exist: " + file);
        }
        if (!file.canRead()) {
            throw new IOException("Source path not readable: " + file);
        }
        if (file.isDirectory()) {
            PathUtils.copyDir(file, file2, bl);
        } else if (file.isFile()) {
            PathUtils.copyFile(file, file2, bl);
        } else {
            throw new IOException("Do not recognize type of file: " + file);
        }
    }

    private static void copyDir(File file, File file2, boolean bl) throws IOException {
        if (file2.exists()) {
            if (!file2.isDirectory()) {
                throw new IOException("Cannot create directory. File exists: " + file2);
            }
            if (!file2.canWrite()) {
                throw new IOException("Destination directory is not writeable: " + file2);
            }
            file2 = new File(file2, file.getName());
        }
        if (!file2.exists() && !file2.mkdir()) {
            throw new IOException("Cannot create directory: " + file2);
        }
        for (File file3 : file.listFiles()) {
            PathUtils.copy(file3, file2, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File file, File file2, boolean bl) throws IOException {
        if (file2.isDirectory()) {
            file2 = new File(file2, file.getName());
        }
        if (file2.exists()) {
            if (bl) {
                if (!file2.canWrite()) {
                    throw new IOException("Destination file is not writeable: " + file2);
                }
            } else {
                throw new IOException("Destination exists: " + file2);
            }
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[16384];
            while ((n = fileInputStream.read(byArray)) != -1 && !Thread.currentThread().isInterrupted()) {
                fileOutputStream.write(byArray, 0, n);
            }
            if (Thread.currentThread().isInterrupted()) {
                Logger.LOGGER.warning("Copying file " + file + " has been interrupted.");
            }
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    Logger.LOGGER.warning("Failed to close output stream: " + file2);
                }
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    Logger.LOGGER.warning("Failed to close input stream: " + file);
                }
            }
        }
    }

    public static enum Separator {
        SLASH("/"),
        BACKSLASH("\\");

        public final String fSeparator;

        private Separator(String string2) {
            this.fSeparator = string2;
        }

        public String toString() {
            return this.fSeparator;
        }

        public String convertSeparators(String string) {
            return string.replace(this.getReverse().toString(), this.toString());
        }

        private Separator getReverse() {
            return this == SLASH ? BACKSLASH : SLASH;
        }
    }

    public static enum PlatformType {
        WINDOWS,
        UNIX;


        public boolean isWindows() {
            return this == WINDOWS;
        }

        public Separator getDefaultSeparator() {
            return this.isWindows() ? Separator.BACKSLASH : Separator.SLASH;
        }
    }

    public static final class Platform {
        private PlatformType fPlatformType;
        private Separator fSeparator;

        public Platform(PlatformType platformType, Separator separator) {
            this.setPlatformType(platformType);
            this.setSeparator(separator);
        }

        public PlatformType getPlatformType() {
            return this.fPlatformType;
        }

        public void setPlatformType(PlatformType platformType) {
            this.fPlatformType = platformType;
        }

        public Separator getSeparator() {
            return this.fSeparator;
        }

        public void setSeparator(Separator separator) {
            this.fSeparator = separator;
        }

        public static Platform getLocal() {
            String string = System.getProperty("os.name");
            return string.startsWith("Windows") ? new Platform(PlatformType.WINDOWS, Separator.SLASH) : new Platform(PlatformType.UNIX, Separator.SLASH);
        }
    }

    public static class MatlabRootParameter<V>
    extends ParameterImpl<V> {
        public static final Parameter<String> MATLAB_ROOT;

        private MatlabRootParameter(Parameter.PersistentKey persistentKey, boolean bl, boolean bl2, Class<V> clazz, V v) {
            super(persistentKey, bl, bl2, clazz, v);
        }

        private MatlabRootParameter(Parameter.PersistentKey persistentKey, boolean bl, boolean bl2, Class<V> clazz) {
            super(persistentKey, bl, bl2, clazz);
        }

        @Override
        protected String getSimpleName() {
            return MatlabRootParameter.class.getSimpleName();
        }

        static {
            String string = null;
            try {
                string = PathUtils.findMatlabRoot(null);
            }
            catch (MatlabRootUnknownException matlabRootUnknownException) {
                Log.LOGGER.log(Level.SEVERE, "Specify matlabroot in your environment using one of the options in PathUtils.findMatlabRoot().", matlabRootUnknownException.getMessage());
            }
            MATLAB_ROOT = null != string ? new MatlabRootParameter<String>(Key.MATLAB_ROOT, false, false, String.class, string) : new MatlabRootParameter<String>((Parameter.PersistentKey)Key.MATLAB_ROOT, true, true, String.class);
        }

        private static enum Key implements Parameter.PersistentKey
        {
            MATLAB_ROOT;

        }
    }
}

