/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.service;

import com.mathworks.toolbox.distcomp.control.PortConfig;
import com.mathworks.toolbox.distcomp.service.ConfigInfo;
import com.mathworks.toolbox.distcomp.service.PackageInfo;
import com.mathworks.toolbox.distcomp.service.RMISocketFactoryProvider;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.util.HashMap;
import java.util.Map;

public final class ExportConfigInfo
implements ConfigInfo {
    private static final int[] sPortRange;
    private static final ProviderPortMap sMap;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setPortRange(int n, int n2) {
        if (!ExportConfigInfo.checkIfPortSet()) {
            if (n2 <= n) throw new IllegalArgumentException("maxPort must be greater than minPort");
            ExportConfigInfo.sPortRange[0] = n;
            ExportConfigInfo.sPortRange[1] = n2;
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "ExportPort range set to " + n + "-" + n2);
            return;
        } else {
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "Ignoring setPortRange as an RMI object has already been exported");
        }
    }

    public static int[] getPortRange() {
        return (int[])sPortRange.clone();
    }

    public static void useEphemeralPort() {
        if (!ExportConfigInfo.checkIfPortSet()) {
            ExportConfigInfo.sPortRange[0] = 0;
            ExportConfigInfo.sPortRange[1] = 0;
        } else {
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "Ignoring useEphemeralPort as an RMI object has already been exported");
        }
    }

    public static void unregister(RMISocketFactoryProvider rMISocketFactoryProvider) {
        ExportConfigInfo.sMap.removePort(rMISocketFactoryProvider);
    }

    public static void register(RMISocketFactoryProvider rMISocketFactoryProvider, int n) {
        ExportConfigInfo.sMap.addPort(rMISocketFactoryProvider, n);
    }

    public static int getPort(RMISocketFactoryProvider rMISocketFactoryProvider) {
        return ExportConfigInfo.sMap.getPort(rMISocketFactoryProvider);
    }

    public static int getPort(RMISocketFactoryProvider rMISocketFactoryProvider, int n) {
        return ExportConfigInfo.sMap.getPort(rMISocketFactoryProvider, n);
    }

    public static boolean checkIfPortSet() {
        return ExportConfigInfo.sMap.hasAnyPorts();
    }

    static {
        int n;
        sPortRange = new int[2];
        sMap = new ProviderPortMap();
        int n2 = 27350;
        int n3 = Integer.getInteger("com.mathworks.toolbox.distcomp.base_port", n2);
        try {
            n = PortConfig.getMinClientSessionExportPort(String.valueOf(n3));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            n = PortConfig.getMinClientSessionExportPort(String.valueOf(n2));
        }
        ExportConfigInfo.sPortRange[0] = n;
        ExportConfigInfo.sPortRange[1] = n + 100;
    }

    private static final class PortCounter {
        private final int fPort;
        private int fCount;

        private PortCounter(int n, int n2) {
            this.fPort = n;
            this.fCount = n2;
        }

        private void incrementCount() {
            ++this.fCount;
        }

        private void decrementCount() {
            --this.fCount;
        }

        private int getPort() {
            return this.fPort;
        }

        private int getCount() {
            return this.fCount;
        }
    }

    private static final class ProviderPortMap {
        private Map<RMISocketFactoryProvider, PortCounter> fMap = new HashMap<RMISocketFactoryProvider, PortCounter>();

        private ProviderPortMap() {
        }

        private synchronized void addPort(RMISocketFactoryProvider rMISocketFactoryProvider, int n) {
            if (this.hasPort(rMISocketFactoryProvider)) {
                this.fMap.get(rMISocketFactoryProvider).incrementCount();
            } else {
                PackageInfo.LOGGER.log(DistcompLevel.TWO, "Registering new export port " + n);
                this.fMap.put(rMISocketFactoryProvider, new PortCounter(n, 1));
            }
        }

        private synchronized void removePort(RMISocketFactoryProvider rMISocketFactoryProvider) {
            if (this.hasPort(rMISocketFactoryProvider)) {
                PortCounter portCounter = this.fMap.get(rMISocketFactoryProvider);
                portCounter.decrementCount();
                if (portCounter.getCount() == 0) {
                    PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Unregistering export port " + portCounter.getPort());
                    this.fMap.remove(rMISocketFactoryProvider);
                }
            }
        }

        private synchronized int getPort(RMISocketFactoryProvider rMISocketFactoryProvider) {
            if (this.hasPort(rMISocketFactoryProvider) && this.fMap.get(rMISocketFactoryProvider).getCount() > 0) {
                return this.fMap.get(rMISocketFactoryProvider).getPort();
            }
            throw new IllegalStateException("No port for this provider");
        }

        private synchronized int getPort(RMISocketFactoryProvider rMISocketFactoryProvider, int n) {
            if (this.hasPort(rMISocketFactoryProvider) && this.fMap.get(rMISocketFactoryProvider).getCount() > 0) {
                return this.fMap.get(rMISocketFactoryProvider).getPort();
            }
            return n;
        }

        private synchronized boolean hasAnyPorts() {
            return !this.fMap.isEmpty();
        }

        private synchronized boolean hasPort(RMISocketFactoryProvider rMISocketFactoryProvider) {
            return this.fMap.containsKey(rMISocketFactoryProvider);
        }
    }
}

