/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.storage;

import com.mathworks.toolbox.distcomp.auth.credentials.UserCredentials;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.storage.Cache;
import com.mathworks.toolbox.distcomp.storage.DatabaseStorage;
import com.mathworks.toolbox.distcomp.storage.LRUCache;
import com.mathworks.toolbox.distcomp.storage.StorageException;
import com.mathworks.toolbox.distcomp.workunit.JobIDAndMLType;
import com.mathworks.toolbox.distcomp.workunit.JobImpl;
import com.mathworks.toolbox.distcomp.workunit.TaskImpl;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitImpl;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitStateException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jini.id.Uuid;

public class DatabaseStorageWithWorkUnitCache
implements DatabaseStorage {
    private DatabaseStorage fStorage;
    private Cache<Uuid, WorkUnitImpl> fWorkUnitCache;

    public DatabaseStorageWithWorkUnitCache(DatabaseStorage databaseStorage, int n) {
        this.fWorkUnitCache = new LRUCache<Uuid, WorkUnitImpl>(n);
        this.fStorage = databaseStorage;
    }

    @Override
    public void updateData(Uuid uuid, InputStream inputStream, int n) throws StorageException {
        this.fStorage.updateData(uuid, inputStream, n);
    }

    @Override
    public int readData(Uuid uuid, OutputStream outputStream, int n) throws StorageException {
        return this.fStorage.readData(uuid, outputStream, n);
    }

    @Override
    public byte[] readData(Uuid uuid) throws StorageException {
        return this.fStorage.readData(uuid);
    }

    @Override
    public void removeData(Uuid uuid) throws StorageException {
        this.fStorage.removeData(uuid);
    }

    @Override
    public Uuid copyData(Uuid uuid) throws StorageException {
        return this.fStorage.copyData(uuid);
    }

    @Override
    public void appendToData(Uuid uuid, InputStream inputStream, int n) throws StorageException {
        this.fStorage.appendToData(uuid, inputStream, n);
    }

    @Override
    public void putTaskData(Uuid uuid, Uuid uuid2, Uuid uuid3, InputStream inputStream, int n) throws StorageException {
        this.fStorage.putTaskData(uuid, uuid2, uuid3, inputStream, n);
    }

    @Override
    public void putJobData(Uuid uuid, Uuid uuid2, InputStream inputStream, int n) throws StorageException {
        this.fStorage.putJobData(uuid, uuid2, inputStream, n);
    }

    @Override
    public void removeDataForJobAndTasks(Uuid uuid) throws StorageException {
        this.fStorage.removeDataForJobAndTasks(uuid);
    }

    @Override
    public Uuid putJob(JobImpl jobImpl) throws StorageException {
        if (jobImpl == null) {
            return null;
        }
        Uuid uuid = jobImpl.getID();
        this.fStorage.putJob(jobImpl);
        return uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeJob(Uuid uuid) throws StorageException {
        if (uuid == null) {
            return;
        }
        this.fWorkUnitCache.lockAllKeys();
        try {
            Uuid[] uuidArray = this.fStorage.readTasksByJobID(uuid);
            this.fStorage.removeJob(uuid);
            for (Uuid uuid2 : uuidArray) {
                this.fWorkUnitCache.remove(uuid2);
            }
            this.fWorkUnitCache.remove(uuid);
        }
        finally {
            this.fWorkUnitCache.unlockAllKeys();
        }
    }

    @Override
    public void addToQueue(Uuid uuid) throws StorageException {
        this.fStorage.addToQueue(uuid);
    }

    @Override
    public void removeFromQueue(Uuid uuid) throws StorageException {
        this.fStorage.removeFromQueue(uuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void promoteJob(Uuid uuid) throws StorageException, WorkUnitStateException {
        this.fWorkUnitCache.lockAllKeys();
        try {
            this.fStorage.promoteJob(uuid);
        }
        finally {
            this.fWorkUnitCache.unlockAllKeys();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void demoteJob(Uuid uuid) throws StorageException, WorkUnitStateException {
        this.fWorkUnitCache.lockAllKeys();
        try {
            this.fStorage.demoteJob(uuid);
        }
        finally {
            this.fWorkUnitCache.unlockAllKeys();
        }
    }

    @Override
    public void updateCredentials(UserCredentials userCredentials) {
        this.fStorage.updateCredentials(userCredentials);
    }

    @Override
    public Uuid[] readTasksByJobID(Uuid uuid) throws StorageException {
        return this.fStorage.readTasksByJobID(uuid);
    }

    @Override
    public Uuid[][] readTasksByJobIDAndState(Uuid uuid, int[] nArray) throws StorageException {
        return this.fStorage.readTasksByJobIDAndState(uuid, nArray);
    }

    @Override
    public Uuid[] readTasksByJobIDAndBeforeState(Uuid uuid, int n) throws MJSException {
        return this.fStorage.readTasksByJobIDAndBeforeState(uuid, n);
    }

    @Override
    public JobIDAndMLType[] readJobsAndTypes() throws StorageException {
        return this.fStorage.readJobsAndTypes();
    }

    @Override
    public JobIDAndMLType[][] readJobsAndTypesByState(int[] nArray) throws StorageException {
        return this.fStorage.readJobsAndTypesByState(nArray);
    }

    @Override
    public Uuid[] readTasksByState(int n) throws StorageException {
        return this.fStorage.readTasksByState(n);
    }

    @Override
    public Uuid[] readTasksByJobIDAndState(Uuid uuid, int n, int n2) throws StorageException {
        return this.fStorage.readTasksByJobIDAndState(uuid, n, n2);
    }

    @Override
    public Uuid[] readJobsByState(int n) throws StorageException {
        return this.fStorage.readJobsByState(n);
    }

    @Override
    public Uuid[] readJobsByJobStateWithTasksInState(int n, int n2) throws StorageException {
        return this.fStorage.readJobsByJobStateWithTasksInState(n, n2);
    }

    @Override
    public Uuid readFirstJobByState(int n) throws StorageException {
        return this.fStorage.readFirstJobByState(n);
    }

    @Override
    public int countTasksByJobID(Uuid uuid) throws StorageException {
        return this.fStorage.countTasksByJobID(uuid);
    }

    @Override
    public int countTasksByJobIDAndState(Uuid uuid, int n) throws StorageException {
        return this.fStorage.countTasksByJobIDAndState(uuid, n);
    }

    @Override
    public int countTasksByJobIDAndBeforeState(Uuid uuid, int n) throws StorageException {
        return this.fStorage.countTasksByJobIDAndBeforeState(uuid, n);
    }

    @Override
    public Uuid putTask(TaskImpl taskImpl) throws StorageException {
        if (taskImpl == null) {
            return null;
        }
        Uuid uuid = taskImpl.getID();
        this.fStorage.putTask(taskImpl);
        return uuid;
    }

    @Override
    public void removeTask(Uuid uuid) throws StorageException {
        try (Cache.CacheToken<Uuid> cacheToken = this.fWorkUnitCache.lock(uuid);){
            this.fStorage.removeTask(uuid);
            this.fWorkUnitCache.remove(cacheToken);
        }
    }

    @Override
    public int updateWorkUnit(WorkUnitImpl workUnitImpl) throws StorageException {
        int n;
        try (Cache.CacheToken<Uuid> cacheToken = this.fWorkUnitCache.lock(workUnitImpl.getID());){
            n = this.fStorage.updateWorkUnit(workUnitImpl);
            if (n > 0) {
                this.fWorkUnitCache.put(cacheToken, workUnitImpl);
            }
        }
        return n;
    }

    @Override
    public void close() throws StorageException {
        this.fWorkUnitCache.clear();
        this.fStorage.close();
    }

    @Override
    public int getCacheSize() {
        return this.fWorkUnitCache.size();
    }

    @Override
    public WorkUnitImpl readWorkUnit(Uuid uuid) throws StorageException {
        try (Cache.CacheToken<Uuid> cacheToken = this.fWorkUnitCache.lock(uuid);){
            WorkUnitImpl workUnitImpl = this.fWorkUnitCache.get(cacheToken);
            if (workUnitImpl == null) {
                workUnitImpl = this.fStorage.readWorkUnit(uuid);
                this.fWorkUnitCache.put(cacheToken, workUnitImpl);
            }
            WorkUnitImpl workUnitImpl2 = workUnitImpl;
            return workUnitImpl2;
        }
    }
}

