/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.profile;

import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.FilePatternFilter;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.toolbox.distcomp.ui.desk.RestartPoolConfirmationDialog;
import com.mathworks.toolbox.distcomp.ui.discover.DiscoverClusterWizard;
import com.mathworks.toolbox.distcomp.ui.model.Selection;
import com.mathworks.toolbox.distcomp.ui.model.SelectionEvent;
import com.mathworks.toolbox.distcomp.ui.model.SelectionListener;
import com.mathworks.toolbox.distcomp.ui.profile.ProfileManagerUI;
import com.mathworks.toolbox.distcomp.ui.profile.model.Profile;
import com.mathworks.toolbox.distcomp.ui.resources.icons.ParallelIcon;
import com.mathworks.widgets.Dialogs;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JComponent;

final class ActionProvider {
    private final ProfileManagerUI fProfileManagerUI;
    private MJAbstractAction fDeleteAction;
    private MJAbstractAction fDuplicateAction;
    private static final String PROFILE_FILE_PATTERN = "*.settings";
    private static final String CONFIGURATIONS_FILE_PATTERN = "*.mat";
    private static final String DEFAULT_ALL_PROFILE_EXPORT_FILE = "AllProfiles.settings";
    private static final String PROFILE_FILE_EXTENSION = ".settings";
    static final String WARN_DELETE_PROFILE = "PCT_DeleteProfile";
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_profile");

    ActionProvider(ProfileManagerUI profileManagerUI) {
        this.fProfileManagerUI = profileManagerUI;
        this.createDeleteAction();
        this.createDuplicateAction();
    }

    MJAbstractAction createSetDefaultProfile() {
        final Selection<Profile> selection = this.fProfileManagerUI.getNavigationPanelSelection();
        final MJAbstractAction mJAbstractAction = new MJAbstractAction(sRes.getString("ProfileManager.SetDefaultAction")){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = ((Profile)selection.getSelection()).getName();
                if (RestartPoolConfirmationDialog.isOkToChangeDefaultProfile((Window)((Object)ActionProvider.this.fProfileManagerUI), ActionProvider.this.fProfileManagerUI.getSessionInfoProvider().getSessionInfo(), ActionProvider.this.fProfileManagerUI.getProfileManager().getDefaultProfileName(), string)) {
                    ActionProvider.this.fProfileManagerUI.getProfileManager().setDefaultProfileName(string);
                }
            }
        };
        if (selection.getSelection() == null || selection.getSelection().equals(this.fProfileManagerUI.getProfileManager().getDefaultProfile())) {
            mJAbstractAction.setEnabled(false);
        } else {
            mJAbstractAction.setEnabled(true);
        }
        selection.addSelectionListener(new SelectionListener<Profile>(){

            @Override
            public void selectionChanged(SelectionEvent<Profile> selectionEvent) {
                Profile profile = selectionEvent.getNewSelection();
                if (profile == null || profile.equals(ActionProvider.this.fProfileManagerUI.getProfileManager().getDefaultProfile())) {
                    mJAbstractAction.setEnabled(false);
                } else {
                    mJAbstractAction.setEnabled(true);
                }
            }
        });
        return mJAbstractAction;
    }

    MJAbstractAction getDuplicateAction() {
        return this.fDuplicateAction;
    }

    private void createDuplicateAction() {
        final Selection<Profile> selection = this.fProfileManagerUI.getNavigationPanelSelection();
        this.fDuplicateAction = new MJAbstractAction(sRes.getString("ProfileManager.DuplicateAction")){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionProvider.this.fDuplicateAction.setEnabled(false);
                String string = ((Profile)selection.getSelection()).getName();
                ActionProvider.this.fProfileManagerUI.getProfileManager().cloneProfile(string);
            }
        };
        this.setupEnableActionWhenSelected(this.fDuplicateAction);
    }

    MJAbstractAction getDeleteAction() {
        return this.fDeleteAction;
    }

    private void createDeleteAction() {
        final Selection<Profile> selection = this.fProfileManagerUI.getNavigationPanelSelection();
        this.fDeleteAction = new MJAbstractAction(sRes.getString("ProfileManager.DeleteAction")){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = ((Profile)selection.getSelection()).getName();
                String string2 = MessageFormat.format(sRes.getString("ProfileManager.DeleteConfirmDialog.Message"), string);
                int n = Dialogs.showOptionalConfirmDialog((Component)((Object)ActionProvider.this.fProfileManagerUI), (Object)string2, (String)sRes.getString("ProfileManager.DeleteConfirmDialog.Title"), (int)0, (int)2, (String)ActionProvider.WARN_DELETE_PROFILE, (int)0, (boolean)true);
                if (n == 0) {
                    ActionProvider.this.fDeleteAction.setEnabled(false);
                    ActionProvider.this.fProfileManagerUI.getProfileManager().removeProfile(string);
                }
            }
        };
        if (selection.getSelection() == null || selection.getSelection().getName().equals("local")) {
            this.fDeleteAction.setEnabled(false);
        } else {
            this.fDeleteAction.setEnabled(true);
        }
        selection.addSelectionListener(new SelectionListener<Profile>(){

            @Override
            public void selectionChanged(SelectionEvent<Profile> selectionEvent) {
                Profile profile = selectionEvent.getNewSelection();
                if (profile == null || profile.getName().equals("local")) {
                    ActionProvider.this.fDeleteAction.setEnabled(false);
                } else {
                    ActionProvider.this.fDeleteAction.setEnabled(true);
                }
            }
        });
    }

    MJAbstractAction createEdit() {
        MJAbstractAction mJAbstractAction = new MJAbstractAction(sRes.getString("ProfileManager.EditAction")){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionProvider.this.fProfileManagerUI.editSelection();
            }
        };
        this.setupEnableActionWhenSelected(mJAbstractAction);
        return mJAbstractAction;
    }

    MJAbstractAction createRename() {
        Selection<Profile> selection = this.fProfileManagerUI.getNavigationPanelSelection();
        final MJAbstractAction mJAbstractAction = new MJAbstractAction(sRes.getString("ProfileManager.RenameAction")){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionProvider.this.fProfileManagerUI.getProfilesTablePanel().editSelectedCell();
            }
        };
        if (selection.getSelection() == null || selection.getSelection().getName().equals("local")) {
            mJAbstractAction.setEnabled(false);
        } else {
            mJAbstractAction.setEnabled(true);
        }
        selection.addSelectionListener(new SelectionListener<Profile>(){

            @Override
            public void selectionChanged(SelectionEvent<Profile> selectionEvent) {
                Profile profile = selectionEvent.getNewSelection();
                if (profile == null || profile.getName().equals("local")) {
                    mJAbstractAction.setEnabled(false);
                } else {
                    mJAbstractAction.setEnabled(true);
                }
            }
        });
        return mJAbstractAction;
    }

    MJAbstractAction createValidate() {
        final Selection<Profile> selection = this.fProfileManagerUI.getNavigationPanelSelection();
        MJAbstractAction mJAbstractAction = new MJAbstractAction(sRes.getString("ProfileManager.ValidateAction")){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionProvider.this.fProfileManagerUI.getValidationManager().validate((Profile)selection.getSelection());
            }
        };
        this.setupEnableActionWhenSelected(mJAbstractAction);
        return mJAbstractAction;
    }

    MJAbstractAction createDiscoverCluster() {
        MJAbstractAction mJAbstractAction = new MJAbstractAction(sRes.getString("ProfileManager.Toolstrip.DiscoverClustersAction")){

            public void actionPerformed(ActionEvent actionEvent) {
                DiscoverClusterWizard.launchWizard((Window)((Object)ActionProvider.this.fProfileManagerUI));
            }
        };
        this.setupEnableActionWhenSelected(mJAbstractAction);
        return mJAbstractAction;
    }

    MJAbstractAction createImport(final Component component) {
        MJAbstractAction mJAbstractAction = new MJAbstractAction(sRes.getString("ProfileManager.ImportAction")){

            public void actionPerformed(ActionEvent actionEvent) {
                File file;
                MJFileChooserPerPlatform mJFileChooserPerPlatform = new MJFileChooserPerPlatform();
                mJFileChooserPerPlatform.setDialogTitle(sRes.getString("ProfileManager.ImportDialog.Title"));
                mJFileChooserPerPlatform.addChoosableFileFilter(new FilePatternFilter(){

                    public String getDescription() {
                        return sRes.getString("ProfileManager.ProfileFile.Description");
                    }

                    public String[] getPatterns() {
                        return new String[]{ActionProvider.PROFILE_FILE_PATTERN};
                    }
                });
                mJFileChooserPerPlatform.addChoosableFileFilter(new FilePatternFilter(){

                    public String getDescription() {
                        return sRes.getString("ProfileManager.ConfigurationFile.Description");
                    }

                    public String[] getPatterns() {
                        return new String[]{ActionProvider.CONFIGURATIONS_FILE_PATTERN};
                    }
                });
                mJFileChooserPerPlatform.showOpenDialog(component);
                int n = mJFileChooserPerPlatform.getState();
                if (n == 0 && (file = mJFileChooserPerPlatform.getSelectedFile()) != null) {
                    ActionProvider.this.fProfileManagerUI.getProfileManager().importAllProfiles(file.getAbsolutePath());
                }
            }
        };
        this.setupEnableActionWhenSelected(mJAbstractAction);
        return mJAbstractAction;
    }

    MJAbstractAction createExportAction(final Component component) {
        final Selection<Profile> selection = this.fProfileManagerUI.getNavigationPanelSelection();
        MJAbstractAction mJAbstractAction = new MJAbstractAction(sRes.getString("ProfileManager.ExportAction")){

            public void actionPerformed(ActionEvent actionEvent) {
                File file;
                MJFileChooserPerPlatform mJFileChooserPerPlatform = new MJFileChooserPerPlatform();
                mJFileChooserPerPlatform.setDialogTitle(sRes.getString("ProfileManager.ExportDialog.Title"));
                mJFileChooserPerPlatform.addChoosableFileFilter(new FilePatternFilter(){

                    public String getDescription() {
                        return sRes.getString("ProfileManager.ProfileFile.Description");
                    }

                    public String[] getPatterns() {
                        return new String[]{ActionProvider.PROFILE_FILE_PATTERN};
                    }
                });
                String string = ((Profile)selection.getSelection()).getName();
                String string2 = string + ActionProvider.PROFILE_FILE_EXTENSION;
                mJFileChooserPerPlatform.setSelectedFile(new File(string2));
                mJFileChooserPerPlatform.showSaveDialog(component);
                int n = mJFileChooserPerPlatform.getState();
                if (n == 0 && (file = mJFileChooserPerPlatform.getSelectedFile()) != null) {
                    ActionProvider.this.fProfileManagerUI.getProfileManager().exportProfile(string, file.getAbsolutePath());
                }
            }
        };
        this.setupEnableActionWhenSelected(mJAbstractAction);
        return mJAbstractAction;
    }

    MJAbstractAction createExportAllAction(final JComponent jComponent) {
        MJAbstractAction mJAbstractAction = new MJAbstractAction(sRes.getString("ProfileManager.ExportAllAction")){

            public void actionPerformed(ActionEvent actionEvent) {
                File file;
                MJFileChooserPerPlatform mJFileChooserPerPlatform = new MJFileChooserPerPlatform();
                mJFileChooserPerPlatform.setDialogTitle(sRes.getString("ProfileManager.ExportDialog.Title"));
                mJFileChooserPerPlatform.addChoosableFileFilter(new FilePatternFilter(){

                    public String getDescription() {
                        return sRes.getString("ProfileManager.ProfileFile.Description");
                    }

                    public String[] getPatterns() {
                        return new String[]{ActionProvider.PROFILE_FILE_PATTERN};
                    }
                });
                mJFileChooserPerPlatform.setSelectedFile(new File(ActionProvider.DEFAULT_ALL_PROFILE_EXPORT_FILE));
                mJFileChooserPerPlatform.showSaveDialog((Component)jComponent);
                int n = mJFileChooserPerPlatform.getState();
                if (n == 0 && (file = mJFileChooserPerPlatform.getSelectedFile()) != null) {
                    ActionProvider.this.fProfileManagerUI.getProfileManager().exportAllProfiles(file.getAbsolutePath());
                }
            }
        };
        this.setupEnableActionWhenSelected(mJAbstractAction);
        return mJAbstractAction;
    }

    static MJAbstractAction createHelpAction() {
        return new MJAbstractAction(sRes.getString("ProfileManager.Toolstrip.HelpAction"), ParallelIcon.HELP.getIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = MLHelpServices.getMapfileName((String)"distcomp", (String)"distcomp_ug");
                MLHelpServices.displayTopic((String)string, (String)"profiles_help");
            }
        };
    }

    private void setupEnableActionWhenSelected(final MJAbstractAction mJAbstractAction) {
        Selection<Profile> selection = this.fProfileManagerUI.getNavigationPanelSelection();
        if (selection.getSelection() == null) {
            mJAbstractAction.setEnabled(false);
        } else {
            mJAbstractAction.setEnabled(true);
        }
        selection.addSelectionListener(new SelectionListener<Profile>(){

            @Override
            public void selectionChanged(SelectionEvent<Profile> selectionEvent) {
                if (selectionEvent.getNewSelection() == null) {
                    mJAbstractAction.setEnabled(false);
                } else {
                    mJAbstractAction.setEnabled(true);
                }
            }
        });
    }
}

