/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.profile;

import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.toolbox.distcomp.ui.model.Selection;
import com.mathworks.toolbox.distcomp.ui.model.SelectionEvent;
import com.mathworks.toolbox.distcomp.ui.model.SelectionListener;
import com.mathworks.toolbox.distcomp.ui.profile.model.Profile;
import com.mathworks.toolbox.distcomp.ui.profile.model.ProfileManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;

public final class ProfileSelector {
    private final Selection<Profile> fProfileSelection;
    private final JComboBox fComboBox;
    private final ProfileManager fProfileManager;
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.toolbox.distcomp.ui.resources.RES_profile");

    public ProfileSelector(ProfileManager profileManager, Selection<Profile> selection) {
        this(profileManager, selection, true);
    }

    public ProfileSelector(ProfileManager profileManager, Selection<Profile> selection, final boolean bl) {
        this.fProfileSelection = selection;
        this.fProfileManager = profileManager;
        final DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        this.fComboBox = new MJComboBox(defaultComboBoxModel);
        this.fComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl3, boolean bl2) {
                JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl3, bl2);
                if (object instanceof Profile) {
                    String string = ((Profile)object).getName();
                    if (bl && ProfileSelector.this.fProfileManager.getDefaultProfile().equals(object)) {
                        string = MessageFormat.format(sRes.getString("ProfileManager.DefaultProfile"), string);
                    }
                    jLabel.setText(string);
                }
                return jLabel;
            }
        });
        this.fComboBox.setAction((Action)new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProfileSelector.this.fProfileSelection.setSelection((Profile)ProfileSelector.this.fComboBox.getSelectedItem());
            }
        });
        if (this.fProfileManager.isInitialized()) {
            this.initializeComboBoxModel(defaultComboBoxModel);
        }
        this.fProfileManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("Initialized")) {
                    ProfileSelector.this.initializeComboBoxModel(defaultComboBoxModel);
                } else if (propertyChangeEvent.getPropertyName().equals("ProfileAdded")) {
                    defaultComboBoxModel.addElement(propertyChangeEvent.getNewValue());
                } else if (propertyChangeEvent.getPropertyName().equals("ProfileRemoved")) {
                    Profile profile;
                    Object object = propertyChangeEvent.getNewValue();
                    if (object.equals(profile = (Profile)ProfileSelector.this.fProfileSelection.getSelection())) {
                        ProfileSelector.this.fProfileSelection.setSelection(ProfileSelector.this.fProfileManager.getDefaultProfile());
                    }
                    defaultComboBoxModel.removeElement(object);
                }
            }
        });
        this.fProfileSelection.addSelectionListener(new SelectionListener<Profile>(){

            @Override
            public void selectionChanged(SelectionEvent<Profile> selectionEvent) {
                ActionListener[] actionListenerArray;
                for (ActionListener actionListener : actionListenerArray = ProfileSelector.this.fComboBox.getActionListeners()) {
                    ProfileSelector.this.fComboBox.removeActionListener(actionListener);
                }
                ProfileSelector.this.fComboBox.setSelectedItem(selectionEvent.getNewSelection());
                for (ActionListener actionListener : actionListenerArray) {
                    ProfileSelector.this.fComboBox.addActionListener(actionListener);
                }
            }
        });
        this.fComboBox.setName("SelectProfileCombobox");
    }

    private void initializeComboBoxModel(DefaultComboBoxModel defaultComboBoxModel) {
        ActionListener[] actionListenerArray = this.fComboBox.getActionListeners();
        for (ActionListener actionListener : actionListenerArray) {
            this.fComboBox.removeActionListener(actionListener);
        }
        List<Profile> list = this.fProfileManager.getProfiles();
        Object object = list.iterator();
        while (object.hasNext()) {
            Profile profile = (Profile)object.next();
            defaultComboBoxModel.addElement(profile);
        }
        object = this.fProfileManager.getDefaultProfile();
        this.fComboBox.setSelectedItem(object);
        for (ActionListener actionListener : actionListenerArray) {
            this.fComboBox.addActionListener(actionListener);
        }
        this.fProfileSelection.setSelection((Profile)object);
    }

    public JComponent getComponent() {
        return this.fComboBox;
    }

    public String getSelectedProfile() {
        return this.fProfileSelection.getSelection().getName();
    }

    public void setSelectedProfile(String string) {
        this.fProfileSelection.setSelection(this.fProfileManager.getProfile(string));
    }
}

