/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.ui.widget;

import com.mathworks.mwswing.MJTextField;
import com.mathworks.toolbox.distcomp.ui.ClickAwayFocusListener;
import com.mathworks.toolbox.distcomp.ui.model.DefaultValue;
import com.mathworks.toolbox.distcomp.ui.model.Property;
import com.mathworks.toolbox.distcomp.ui.widget.ConfigurablePropertyView;
import com.mathworks.toolbox.distcomp.ui.widget.GlassPaneTextContextMenu;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;

public class IntegerVectorView
extends ConfigurablePropertyView {
    private final MJTextField fIntegerVectorTextField;
    private static final String INF = "inf";
    private static final String EMPTY_VALUE = "";

    public IntegerVectorView(Property property, String string) {
        super(property);
        this.fIntegerVectorTextField = this.createIntegerVectorTextField(string);
        this.updateUI(this.getProperty().getValue());
        JComponent jComponent = this.addUseDefaultOverlayDecorator((JComponent)this.fIntegerVectorTextField, string);
        this.addLine(jComponent, 8);
        if (this.getProperty().getPropertyInfo().hasDefaultString()) {
            this.addLine(this.createDefaultValueDecorator());
        }
    }

    private MJTextField createIntegerVectorTextField(String string) {
        final MJTextField mJTextField = new MJTextField();
        int n = (int)mJTextField.getPreferredSize().getHeight();
        mJTextField.setMinimumSize(new Dimension(250, n));
        mJTextField.setMaximumSize(new Dimension(250, n));
        mJTextField.setSize(new Dimension(250, n));
        mJTextField.setPreferredSize(new Dimension(250, n));
        mJTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IntegerVectorView.this.commitEdit();
                mJTextField.getParent().requestFocus();
            }
        });
        mJTextField.addFocusListener((FocusListener)new ClickAwayFocusListener((JComponent)mJTextField, new Runnable(){

            @Override
            public void run() {
                IntegerVectorView.this.commitEdit();
            }
        }));
        mJTextField.addContextMenu((JPopupMenu)((Object)new GlassPaneTextContextMenu()));
        mJTextField.setName(string);
        return mJTextField;
    }

    @Override
    public void updateUI(Object object) {
        String string;
        if (object instanceof DefaultValue) {
            string = EMPTY_VALUE;
        } else if (object instanceof Double) {
            string = IntegerVectorView.createIntegerText((Double)object);
        } else if (object instanceof Double[]) {
            Double[] doubleArray = (Double[])object;
            StringBuilder stringBuilder = new StringBuilder();
            for (Double d : doubleArray) {
                stringBuilder.append(IntegerVectorView.createIntegerText(d));
                stringBuilder.append(" ");
            }
            stringBuilder.substring(0, stringBuilder.length() - 1);
            string = "[" + stringBuilder.substring(0, stringBuilder.length() - 1) + "]";
        } else {
            assert (false) : "Unsupported type " + object.getClass().getSimpleName();
            string = EMPTY_VALUE;
        }
        this.fIntegerVectorTextField.setText(string);
    }

    private static String createIntegerText(Double d) {
        String string;
        if (d.equals(Double.POSITIVE_INFINITY)) {
            string = INF;
        } else {
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setParseIntegerOnly(true);
            numberFormat.setGroupingUsed(false);
            string = numberFormat.format(d);
        }
        return string;
    }

    @Override
    public void commitEdit() {
        Property property = this.getProperty();
        String string = this.fIntegerVectorTextField.getText();
        Object object = IntegerVectorView.convertToDoubleArray(string);
        if (EMPTY_VALUE.equals(object)) {
            property.unsetValue();
        } else {
            property.setValue(object);
        }
    }

    private static Object convertToDoubleArray(String string) {
        if (string == null) {
            return EMPTY_VALUE;
        }
        if ((string = string.trim()).length() == 0) {
            return EMPTY_VALUE;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "[], ");
        ArrayList<Double> arrayList = new ArrayList<Double>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            arrayList.add(IntegerVectorView.createDouble(string2));
        }
        if (arrayList.size() > 1) {
            return arrayList.toArray(new Double[arrayList.size()]);
        }
        if (arrayList.size() == 1) {
            return arrayList.get(0);
        }
        return EMPTY_VALUE;
    }

    private static Double createDouble(String string) {
        Double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = Double.POSITIVE_INFINITY;
        }
        return d;
    }
}

