/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util;

import com.mathworks.mvm.exec.FutureResult;
import com.mathworks.mvm.exec.MvmCancellationException;
import com.mathworks.mvm.exec.MvmException;
import com.mathworks.mvm.exec.MvmExecutionException;
import com.mathworks.mvm.exec.MvmInterruptedException;
import com.mathworks.toolbox.distcomp.util.PackageInfo;
import com.mathworks.toolbox.distcomp.util.RemoteMatlabException;
import com.mathworks.toolbox.parallel.pctutil.concurrent.NamedThreadFactory;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.util.concurrent.CancellationException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

public final class FutureWaiter {
    private static final long GET_TIMEOUT_SECONDS = 60L;
    private final AtomicBoolean fShouldQuit = new AtomicBoolean(false);
    private final ThreadPoolExecutor fThreadPool;

    public FutureWaiter(int n) {
        NamedThreadFactory namedThreadFactory = NamedThreadFactory.createDaemonThreadFactory((String)(this.getClass().getSimpleName() + " fThreadPool-"), (Logger)PackageInfo.LOGGER);
        this.fThreadPool = new ThreadPoolExecutor(1, 1, 100L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(n), (ThreadFactory)namedThreadFactory);
    }

    public void waitAndTrigger(FutureResult futureResult, OnFutureCompletion onFutureCompletion) {
        this.fThreadPool.execute(new WaitTask(futureResult, onFutureCompletion));
        PackageInfo.LOGGER.log(DistcompLevel.SIX, "FutureWaiter.waitAndTrigger(" + futureResult + ", " + onFutureCompletion + ")");
    }

    public void destroy() {
        boolean bl = this.fShouldQuit.getAndSet(true);
        assert (!bl) : "FutureWaiter destroyed multiple times.";
        this.fThreadPool.shutdownNow();
    }

    private final class WaitTask
    implements Runnable {
        private FutureResult fFuture;
        private OnFutureCompletion fToTrigger;

        WaitTask(FutureResult futureResult, OnFutureCompletion onFutureCompletion) {
            this.fFuture = futureResult;
            this.fToTrigger = onFutureCompletion;
        }

        @Override
        public void run() {
            Object object = null;
            Exception exception = null;
            try {
                boolean bl = false;
                while (!bl) {
                    try {
                        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "FutureWaiter about to invoke get() on " + this.fFuture);
                        object = this.fFuture.get(60L, TimeUnit.SECONDS);
                        bl = true;
                    }
                    catch (TimeoutException timeoutException) {
                        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "FutureWaiter still waiting for get() on " + this.fFuture);
                    }
                }
            }
            catch (MvmExecutionException mvmExecutionException) {
                MvmException mvmException = mvmExecutionException.getMvmCause();
                exception = mvmException != null ? mvmException : mvmExecutionException;
            }
            catch (MvmCancellationException mvmCancellationException) {
                MvmInterruptedException mvmInterruptedException = mvmCancellationException.getMvmCause();
                exception = mvmInterruptedException != null ? mvmInterruptedException : mvmCancellationException;
            }
            catch (CancellationException cancellationException) {
                exception = cancellationException;
            }
            catch (InterruptedException interruptedException) {
                exception = interruptedException;
            }
            catch (RuntimeException runtimeException) {
                PackageInfo.LOGGER.log(DistcompLevel.TWO, "FutureWaiter caught unexpected RuntimeException.", runtimeException);
                throw runtimeException;
            }
            catch (Error error) {
                PackageInfo.LOGGER.log(DistcompLevel.TWO, "FutureWaiter caught unexpected Error.", error);
                throw error;
            }
            finally {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "FutureWaiter completed get() loop.");
            }
            if (exception == null) {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "FutureWaiter successfully completed a get() on " + this.fFuture);
            } else {
                exception = RemoteMatlabException.maybeWrapMvmException(exception);
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "FutureWaiter caught an exception during get() on " + this.fFuture, exception);
            }
            if (!FutureWaiter.this.fShouldQuit.get()) {
                this.fToTrigger.run(object, exception);
            }
        }
    }

    public static interface OnFutureCompletion {
        public void run(Object var1, Exception var2);
    }
}

