/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.util.i18n;

import com.mathworks.toolbox.distcomp.util.i18n.BundleKey;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;

public final class MessageGenerator {
    private static final Pattern HOLE_PATTERN = Pattern.compile("\\{[0-9]+\\}");

    private MessageGenerator() {
    }

    private static String createMessage(BundleKey bundleKey, boolean bl, Locale locale, Object ... objectArray) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(bundleKey.getResourceBundleName(), locale);
            String string = resourceBundle.getString(bundleKey.getBundleKey());
            MessageFormat messageFormat = new MessageFormat(string, locale);
            MessageGenerator.verifyNumberOfHoles(messageFormat, string, objectArray, bundleKey, locale);
            String string2 = messageFormat.format(objectArray);
            MessageGenerator.verifyHolesFilledIn(string, string2, objectArray, bundleKey, locale);
            if (bl) {
                string2 = bundleKey + ": " + string2;
            }
            return string2;
        }
        catch (Exception exception) {
            throw new CouldNotCreateMessageException(bundleKey, locale, objectArray, exception);
        }
    }

    private static void verifyNumberOfHoles(MessageFormat messageFormat, String string, Object[] objectArray, BundleKey bundleKey, Locale locale) {
        if (messageFormat.getFormats().length > 0) {
            int n;
            int n2;
            Object object;
            try {
                object = messageFormat.getClass().getDeclaredField("argumentNumbers");
                ((Field)object).setAccessible(true);
                int[] nArray = (int[])((Field)object).get(messageFormat);
                List<Integer> list = Arrays.asList(ArrayUtils.toObject((int[])nArray));
                n2 = Collections.max(list) + 1;
                n = objectArray.length;
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                throw new IllegalStateException(reflectiveOperationException);
            }
            if (n2 != n) {
                object = new IncorrectNumberOfHolesException(bundleKey, locale, string, objectArray, n2, n);
                assert (false) : ((Throwable)object).getMessage();
            }
        }
    }

    private static void verifyHolesFilledIn(String string, String string2, Object[] objectArray, BundleKey bundleKey, Locale locale) {
        Matcher matcher = HOLE_PATTERN.matcher(string2);
        MessageFormat messageFormat = new MessageFormat("{0}", locale);
        for (Object object : objectArray) {
            String string3 = messageFormat.format(new Object[]{object});
            if (string2.contains(string3)) continue;
            MissingArgumentException missingArgumentException = new MissingArgumentException(bundleKey, locale, string, objectArray, string3);
            assert (false) : ((Throwable)missingArgumentException).getMessage();
        }
        if (matcher.find()) {
            HoleNotFilledException holeNotFilledException = new HoleNotFilledException(bundleKey, locale, string, objectArray, string2);
            assert (false) : ((Throwable)holeNotFilledException).getMessage();
        }
    }

    public static String createMessage(BundleKey bundleKey, boolean bl, Object ... objectArray) {
        return MessageGenerator.createMessage(bundleKey, bl, Locale.US, objectArray);
    }

    public static String createLocalizedMessage(BundleKey bundleKey, boolean bl, Object ... objectArray) {
        return MessageGenerator.createMessage(bundleKey, bl, Locale.getDefault(), objectArray);
    }

    public static final class HoleNotFilledException
    extends BadHolesException {
        private final String fFormattedMessage;

        private HoleNotFilledException(BundleKey bundleKey, Locale locale, String string, Object[] objectArray, String string2) {
            super(bundleKey, locale, string, objectArray);
            this.fFormattedMessage = string2;
        }

        @Override
        public String getMessage() {
            return super.getMessage() + "\n Found hole of form '{N}' in message indicating a formatting error." + "\n Formatted message: " + this.fFormattedMessage;
        }
    }

    public static final class MissingArgumentException
    extends BadHolesException {
        private final String fExpected;

        private MissingArgumentException(BundleKey bundleKey, Locale locale, String string, Object[] objectArray, String string2) {
            super(bundleKey, locale, string, objectArray);
            this.fExpected = string2;
        }

        @Override
        public String getMessage() {
            return super.getMessage() + "\n Expected '" + this.fExpected + "' to appear in message.";
        }
    }

    public static final class IncorrectNumberOfHolesException
    extends BadHolesException {
        private final int fExpected;
        private final int fActual;

        private IncorrectNumberOfHolesException(BundleKey bundleKey, Locale locale, String string, Object[] objectArray, int n, int n2) {
            super(bundleKey, locale, string, objectArray);
            this.fExpected = n;
            this.fActual = n2;
        }

        @Override
        public String getMessage() {
            return super.getMessage() + "\n Expected number of holes: " + this.fExpected + ".\n Actual number of holes: " + this.fActual + ".";
        }
    }

    public static abstract class BadHolesException
    extends RuntimeException {
        private final BundleKey fKey;
        private final Locale fLocale;
        private final Object[] fMessageArguments;
        private final String fFormatString;

        private BadHolesException(BundleKey bundleKey, Locale locale, String string, Object[] objectArray) {
            this.fKey = bundleKey;
            this.fLocale = locale;
            this.fMessageArguments = objectArray;
            this.fFormatString = string;
        }

        @Override
        public String getMessage() {
            return "Message arguments incorrect for message with key: " + this.fKey.getBundleKey() + " in locale " + this.fLocale + " with arguments " + Arrays.toString(this.fMessageArguments) + ".\n Format string: " + this.fFormatString + ".";
        }
    }

    public static final class CouldNotCreateMessageException
    extends RuntimeException {
        private final BundleKey fKey;
        private final Locale fLocale;
        private final Object[] fMessageArguments;

        private CouldNotCreateMessageException(BundleKey bundleKey, Locale locale, Object[] objectArray, Exception exception) {
            super(exception);
            this.fKey = bundleKey;
            this.fLocale = locale;
            this.fMessageArguments = objectArray;
        }

        @Override
        public String getMessage() {
            return "Could not create message for key " + this.fKey.getBundleKey() + " in locale " + this.fLocale + " with arguments " + Arrays.toString(this.fMessageArguments);
        }
    }
}

