/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.workunit;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.distcompobjects.DistcompListenableImpl;
import com.mathworks.toolbox.distcomp.jobmanager.statenotification.StateChangeListener;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.storage.StorageException;
import com.mathworks.toolbox.distcomp.storage.WorkUnitStorage;
import com.mathworks.toolbox.distcomp.util.RWLock;
import com.mathworks.toolbox.distcomp.util.SystemTimeProvider;
import com.mathworks.toolbox.distcomp.util.TimeProvider;
import com.mathworks.toolbox.distcomp.workunit.PackageInfo;
import com.mathworks.toolbox.distcomp.workunit.WorkUnit;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitStateException;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.rmi.MarshalledObject;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import net.jini.core.event.RemoteEventListener;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;

public abstract class WorkUnitImpl
extends DistcompListenableImpl
implements WorkUnit {
    public static final long NO_TIMEOUT = Long.MAX_VALUE;
    private final Uuid fWorkUnitId = UuidFactory.generate();
    protected String fName;
    protected long fTimeout = Long.MAX_VALUE;
    private static final long UNSET_SEQUENCE = Long.MIN_VALUE;
    protected transient long fNum = Long.MIN_VALUE;
    protected transient int fState = 0;
    protected long fCreateTime = -1L;
    protected long fStartTime = -1L;
    protected long fFinishTime = -1L;
    private String[] fAuthorisedUsers = new String[0];
    private String fUserName;
    private TimeProvider fTimeProvider;
    private transient WorkUnitStorage fStorage;
    private transient RWLock fLock;
    private transient StateChangeListener fPendingModificationListener;

    protected WorkUnitImpl(String string) {
        this.fTimeProvider = new SystemTimeProvider();
        this.fCreateTime = this.fTimeProvider.currentTimeMillis();
        this.fUserName = string;
    }

    protected WorkUnitImpl(String string, TimeProvider timeProvider) {
        this.fTimeProvider = timeProvider;
        this.fCreateTime = this.fTimeProvider.currentTimeMillis();
        this.fUserName = string;
    }

    protected void resetWorkUnitInfoForRerun() {
        this.setWorkUnitToPending();
        this.fStartTime = -1L;
        this.fFinishTime = -1L;
    }

    protected void setWorkUnitToPending() {
        this.fState = 0;
    }

    void resetLock() {
        this.fLock = new RWLock();
    }

    void setPendingModificationListener(StateChangeListener stateChangeListener) {
        this.fPendingModificationListener = stateChangeListener;
    }

    StateChangeListener getPendingModificationListener() {
        return this.fPendingModificationListener;
    }

    protected void setWorkUnitStorage(WorkUnitStorage workUnitStorage) {
        this.fStorage = workUnitStorage;
    }

    @Override
    public Uuid getID() {
        return this.fWorkUnitId;
    }

    @Override
    public String[] getAuthorisedUsers() {
        return this.invokeWithReadLock(new LockedInvocationNoException<String[]>(){

            @Override
            public String[] invoke() {
                return (String[])WorkUnitImpl.this.fAuthorisedUsers.clone();
            }
        });
    }

    @Override
    public long getTimeout() {
        return this.invokeWithReadLock(new LockedInvocationNoException<Long>(){

            @Override
            public Long invoke() {
                return WorkUnitImpl.this.fTimeout;
            }
        });
    }

    @Override
    public String getUserName() {
        return this.invokeWithReadLock(new LockedInvocationNoException<String>(){

            @Override
            public String invoke() {
                return WorkUnitImpl.this.fUserName;
            }
        });
    }

    @Override
    public long getNum() {
        return this.invokeWithReadLock(new LockedInvocationNoException<Long>(){

            @Override
            public Long invoke() {
                assert (WorkUnitImpl.this.fNum != Long.MIN_VALUE) : "Cannot access the sequence number before it has been set.";
                return WorkUnitImpl.this.fNum;
            }
        });
    }

    @Override
    public int getState() {
        return this.invokeWithReadLock(new LockedInvocationNoException<Integer>(){

            @Override
            public Integer invoke() {
                return WorkUnitImpl.this.fState;
            }
        });
    }

    @Override
    public Date getCreateTime() {
        return this.invokeWithReadLock(new LockedInvocationNoException<Date>(){

            @Override
            public Date invoke() {
                return WorkUnitImpl.this.fCreateTime == -1L ? null : new Date(WorkUnitImpl.this.fCreateTime);
            }
        });
    }

    @Override
    public Date getStartTime() {
        return this.invokeWithReadLock(new LockedInvocationNoException<Date>(){

            @Override
            public Date invoke() {
                return WorkUnitImpl.this.fStartTime == -1L ? null : new Date(WorkUnitImpl.this.fStartTime);
            }
        });
    }

    @Override
    public Date getFinishTime() {
        return this.invokeWithReadLock(new LockedInvocationNoException<Date>(){

            @Override
            public Date invoke() {
                return WorkUnitImpl.this.fFinishTime == -1L ? null : new Date(WorkUnitImpl.this.fFinishTime);
            }
        });
    }

    @Override
    public long getRunningDuration() {
        return this.invokeWithReadLock(new LockedInvocationNoException<Long>(){

            @Override
            public Long invoke() {
                long l = WorkUnitImpl.this.fStartTime == -1L ? 0L : (WorkUnitImpl.this.fFinishTime == -1L ? WorkUnitImpl.this.fTimeProvider.currentTimeMillis() - WorkUnitImpl.this.fStartTime : WorkUnitImpl.this.fFinishTime - WorkUnitImpl.this.fStartTime);
                return l;
            }
        });
    }

    @Override
    public void setTimeout(final long l) throws MJSException {
        this.invokeWithWriteLock(new LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                WorkUnitImpl.this.checkStateBeforeSet("Timeout");
                WorkUnitImpl.this.fTimeout = l;
                return null;
            }
        });
    }

    @Override
    public void addEventListener(final RemoteEventListener remoteEventListener, final long l, final long l2, final MarshalledObject marshalledObject) {
        this.invokeWithWriteLock(new LockedInvocationNoException<Void>(){

            @Override
            public Void invoke() {
                WorkUnitImpl.super.addEventListener(remoteEventListener, l, l2, marshalledObject);
                return null;
            }
        });
    }

    @Override
    public void removeEventListener(final RemoteEventListener remoteEventListener, final long l, final long l2) {
        this.invokeWithWriteLock(new LockedInvocationNoException<Void>(){

            @Override
            public Void invoke() {
                WorkUnitImpl.super.removeEventListener(remoteEventListener, l, l2);
                return null;
            }
        });
    }

    @Override
    public void removeEventListener(final RemoteEventListener remoteEventListener) {
        this.invokeWithWriteLock(new LockedInvocationNoException<Void>(){

            @Override
            public Void invoke() {
                WorkUnitImpl.super.removeEventListener(remoteEventListener);
                return null;
            }
        });
    }

    public abstract String workUnitTypeForPrinting();

    protected String getWorkUnitUserName() {
        return this.fUserName;
    }

    protected void setWorkUnitAuthorisedUsers(String[] stringArray) {
        if (stringArray == null) {
            this.fAuthorisedUsers = new String[0];
        } else {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(Arrays.asList(stringArray));
            this.fAuthorisedUsers = linkedHashSet.toArray(new String[linkedHashSet.size()]);
        }
    }

    protected void setWorkUnitUserName(String string) {
        this.fUserName = string;
    }

    protected void checkStateBeforeSet(String string) throws WorkUnitStateException {
        if (this.fState == 2 || this.fState == 3) {
            throw new IncorrectStateToSetPropertyException(string, this.workUnitTypeForPrinting());
        }
    }

    protected void switchToFinishedState() {
        this.fState = 3;
        this.fFinishTime = this.fTimeProvider.currentTimeMillis();
        this.recordEvent(3L);
    }

    protected void switchToRunningState() {
        this.fState = 2;
        this.fStartTime = this.fTimeProvider.currentTimeMillis();
        this.recordEvent(2L);
    }

    private <T> T invokeAndLogError(LockedInvocation<T> lockedInvocation, String string) throws MJSException {
        try {
            return lockedInvocation.invoke();
        }
        catch (Error error) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Unexpected Error in " + string, error);
            throw error;
        }
        catch (RuntimeException runtimeException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Unexpected RuntimeException in " + string, runtimeException);
            throw runtimeException;
        }
    }

    private <T> T invokeAndLogError(LockedInvocationNoException<T> lockedInvocationNoException, String string) {
        try {
            return lockedInvocationNoException.invoke();
        }
        catch (Error error) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Unexpected Error in " + string, error);
            throw error;
        }
        catch (RuntimeException runtimeException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Unexpected RuntimeException in " + string, runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T invokeWithReadLock(LockedInvocation<T> lockedInvocation) throws MJSException {
        this.fLock.getReadLock();
        try {
            T t = this.invokeAndLogError(lockedInvocation, "invokeWithReadLock(LockedInvocation invocation)");
            return t;
        }
        finally {
            this.fLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T invokeWithWriteLock(LockedInvocation<T> lockedInvocation) throws MJSException {
        this.fLock.getWriteLock();
        try {
            this.updateListenerIfPending();
            T t = this.invokeAndLogError(lockedInvocation, "invokeWithWriteLock(LockedInvocation invocation)");
            return t;
        }
        finally {
            try {
                this.fStorage.updateWorkUnit(this);
            }
            finally {
                this.fLock.releaseWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T invokeWithWriteLock(LockedInvocationNoNotification<T> lockedInvocationNoNotification) throws MJSException {
        this.fLock.getWriteLock();
        try {
            T t = this.invokeAndLogError(lockedInvocationNoNotification, "invokeWithWriteLock(LockedInvocation invocation)");
            return t;
        }
        finally {
            try {
                this.fStorage.updateWorkUnit(this);
            }
            finally {
                this.fLock.releaseWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T invokeWithWriteLock(LockedInvocationNoStorageUpdate<T> lockedInvocationNoStorageUpdate) throws MJSException {
        this.fLock.getWriteLock();
        try {
            T t = this.invokeAndLogError(lockedInvocationNoStorageUpdate, "invokeWithWriteLock(LockedInvocationNoStorageUpdate invocation)");
            return t;
        }
        finally {
            this.fLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T invokeWithReadLock(LockedInvocationNoException<T> lockedInvocationNoException) {
        this.fLock.getReadLock();
        try {
            T t = this.invokeAndLogError(lockedInvocationNoException, "invokeWithReadLock(LockedInvocationNoException invocation)");
            return t;
        }
        finally {
            this.fLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T invokeWithWriteLock(LockedInvocationNoException<T> lockedInvocationNoException) {
        this.fLock.getWriteLock();
        try {
            this.updateListenerIfPending();
            T t = this.invokeAndLogError(lockedInvocationNoException, "invokeWithWriteLock(LockedInvocationNoException invocation)");
            return t;
        }
        finally {
            try {
                this.fStorage.updateWorkUnit(this);
            }
            catch (StorageException storageException) {
                PackageInfo.LOGGER.log(Level.FINE, "Exception occurred in a LockedInvocationNoException.", storageException);
            }
            finally {
                this.fLock.releaseWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T invokeWithWriteLock(LockedInvocationNoStorageUpdateNoException<T> lockedInvocationNoStorageUpdateNoException) {
        this.fLock.getWriteLock();
        try {
            T t = this.invokeAndLogError(lockedInvocationNoStorageUpdateNoException, "invokeWithWriteLock(LockedInvocationNoStorageUpdateNoException invocation)");
            return t;
        }
        finally {
            this.fLock.releaseWriteLock();
        }
    }

    protected boolean haveWriteLock() {
        return this.fLock.haveWriteLock();
    }

    @Override
    public String getName() {
        return (String)this.invokeWithReadLock(new LockedInvocationNoException(){

            public Object invoke() {
                return WorkUnitImpl.this.fName;
            }
        });
    }

    @Override
    public void setName(final String string) throws MJSException {
        this.invokeWithWriteLock(new LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                WorkUnitImpl.this.checkStateBeforeSet("Name");
                WorkUnitImpl.this.doSetName(string);
                return null;
            }
        });
    }

    protected void doSetName(String string) {
        this.fName = string != null && string.length() > 0 ? string : this.getDefaultName();
    }

    protected abstract String getDefaultName();

    protected void updateListenerIfPending() {
        if (this.fState == 0 && this.fPendingModificationListener != null) {
            this.fPendingModificationListener.update();
        }
    }

    public void switchToRunningStateForUnitTests() {
        this.fState = 2;
        this.fStartTime = this.fTimeProvider.currentTimeMillis();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof WorkUnitImpl)) {
            return false;
        }
        WorkUnitImpl workUnitImpl = (WorkUnitImpl)object;
        return this.fWorkUnitId.equals((Object)workUnitImpl.fWorkUnitId);
    }

    public int hashCode() {
        return this.fWorkUnitId.hashCode();
    }

    public String toString() {
        return this.fName + " (" + this.getDefaultName() + "): " + this.getID();
    }

    protected static interface LockedInvocationNoStorageUpdateNoException<T>
    extends LockedInvocationNoException<T> {
    }

    protected static interface LockedInvocationNoException<T> {
        public T invoke();
    }

    protected static interface LockedInvocationNoNotification<T>
    extends LockedInvocation<T> {
    }

    protected static interface LockedInvocationNoStorageUpdate<T>
    extends LockedInvocation<T> {
    }

    protected static interface LockedInvocation<T> {
        public T invoke() throws MJSException;
    }

    private static class IncorrectStateToSetPropertyException
    extends WorkUnitStateException {
        private final BaseMsgID fMessageId;

        IncorrectStateToSetPropertyException(String string, String string2) {
            this.fMessageId = new mjs.IncorrectStateToSetProperty(string, string2);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fMessageId;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fMessageId;
        }
    }
}

