function dnsResolve(host) {
	try {
		var address = Packages.java.net.InetAddress.getByName(String(host));
		var result = address.getHostAddress();
		return result;
	} catch (ex) {
		return null;
	}
}

function dnsDomainLevels(host) {
	try {
		var domainLevels = Packages.ice.net.pac.PacScripter.dnsDomainLevels(String(host));
		return domainLevels;
	}	catch (ex) {
		return null;
	}

}

function weekdayRange(wd1, wd2 , gmt) {
	try {
		var isThisRange = Packages.ice.net.pac.PacScripter.weekdayRange(String(wd1),String(wd2),String(gmt));
		return isThisRange;
	} catch (ex) {
		return null;
	}
}

function myIpAddress() {
	try {
		var address = Packages.java.net.InetAddress.getLocalHost();
		var result = address.getHostAddress();
		var str = result.toString();
		return str;
	} catch (ex) {
		return null;
	}
}

function isPlainHostName(host) {
	try {
		var dots = dnsDomainLevels(host);
		if (dots == 0) return true;
		else return false;
	} catch (ex) {
		return null;
	}
}

function dnsDomainIs(host, domain) {
	try {
		var isit = Packages.ice.net.pac.PacScripter.dnsDomainIs(String(host),String(domain));
		return isit;
	}	 catch (ex) {
		return null;
	}
}

function localHostOrDomainIs(host, domain) {
	try {
		var isit = Packages.ice.net.pac.PacScripter.localHostOrDomainIs(String(host),String(domain));
		return isit;
	} catch (ex) {
		return null;
	}
}

function isResolvable(host) {
	try {
		var address = Packages.java.net.InetAddress.getByName(String(host));
		return true;
	} catch (ex) {
		return null;
	}

}

function isInNet(host, pattern, mask) {
	try {
		var isIt =Packages.ice.net.pac.PacScripter.isInNet(String(host),String(pattern),String(mask));
		return isIt;
	} catch (ex) {
		return null;
	}
}



function timeRange(){
	var argv = timeRange.arguments;
	var argc = argv.length;
	var now = new Date();


	//None makes no sense
	if(argv.length==0 ){
		return false;
	}

	var gmt_value=null;
	if(argv[argc-1]=="GMT" ){
		  gmt_value=argv[argc-1];
		  argc--;
		  now.setMinutes( now.getMinutes()-now.getTimezoneOffset());
	}

	if(argc==1 ){
		return do_dateRange2( now.getFullYear(), now.getMonth(), now.getDate(), argv[0], 0, 0, now.getFullYear(),now.getMonth(), now.getDate(), 13 , 0, -1, gmt_value);
	}
	if(argc==2 ){
	  return do_dateRange2( now.getFullYear(), now.getMonth(), now.getDate(), argv[0], 0, 0, now.getFullYear(),now.getMonth(), now.getDate(), argv[1] , 0, -1, gmt_value);
	}
	if(argc==4 ){
		return do_dateRange2( now.getFullYear(), now.getMonth(), now.getDate(), argv[0], argv[1], 0, now.getFullYear(),now.getMonth(), now.getDate(), argv[2] , argv[3], -1, gmt_value);
	}

	if(argc==6 ){
		return do_dateRange2( now.getFullYear(), now.getMonth(), now.getDate(), argv[0], argv[1], argv[2], now.getFullYear(),now.getMonth(), now.getDate(), argv[3] , argv[4], argv[5], gmt_value);
	}

  return false;

}

function dateRange(){

    var argv = dateRange.arguments;
		var argc = argv.length;
		var now = new Date();


		//None makes no sense
		if(argv.length==0 ){
		   return false;
		}

		var gmt_value=null;
		if(argv[argc-1]=="GMT" ){
		   gmt_value=argv[argc-1];
		   argc--;
		   now.setMinutes( now.getMinutes()-now.getTimezoneOffset());
		}


		if(argc==1 ){
		   if(  argv[0]>31 ){
		      return do_dateRange2(argv[0],0, 1,0 , 0, 0, ++argv[0],0, 1,0 , 0, -1, gmt_value);
		   }else{
		     if(  argv[0]< 31){
		        return do_dateRange2( now.getFullYear(), now.getMonth(), argv[0], 0, 0, 0, now.getFullYear(),now.getMonth(), ++argv[0],0 , 0, -1, gmt_value);
		     }
		   }
		   var month = monthToInt( argv[0] );
		   if( month != -1){
		      return do_dateRange2( now.getFullYear(), month, 1, 0, 0, 0, now.getFullYear(), ++month,1,0 , 0, -1, gmt_value);
		   }
		   return false; //the input makes no sense
		}


		if(argc==2 ){
		   if(  argv[0]>31 && argv[1]>31 ){
		      return do_dateRange2(argv[0],0, 1,0 , 0, 0, ++argv[1],0, 1,0 , 0, -1, gmt_value);
		   }else{
		     if(  argv[0]< 31 && argv[1]< 31){
		        return do_dateRange2( now.getFullYear(), now.getMonth(), argv[0], 0, 0, 0, now.getFullYear(),now.getMonth(), ++argv[1],0 , 0, -1, gmt_value);
		     }
		   }
		   var month1 = monthToInt( argv[0] );
		   var month2 = monthToInt( argv[1] );
		   if( (month1 != -1 ) && (month2 != -1) ){
		   	   return do_dateRange2( now.getFullYear(), month1, 1, 0, 0, 0, now.getFullYear(), ++month2,1,0 , 0, -1, gmt_value);
		   }
		   return false; //the input makes no sense
    	}

    	if(argc==4 ){

		   if(  argv[1]> 31 && argv[3]>31 ){
      		   var month1 = monthToInt( argv[0] );
     		   var month2 = monthToInt( argv[2] );
		       if( (month1 != -1 ) && (month2 != -1) ){
     		      return do_dateRange2(argv[1],month1, 1,0 , 0, 0, argv[3],++month2, 1,0 , 0, -1, gmt_value);
     		   }
		   }else{
		       var month1 = monthToInt( argv[1] );
		       var month2 = monthToInt( argv[3] );
		       if( (month1 != -1 ) && (month2 != -1) ){
		           return do_dateRange2( now.getFullYear(), month1, argv[0], 0, 0, 0, now.getFullYear(),month2,++argv[2],0 , 0, -1, gmt_value);
		       }

		   }
		   return false; //the input makes no sense
    	}

    	if(argc==6 ){
	       var month1 = monthToInt( argv[1] );
	       var month2 = monthToInt( argv[4] );
	       if( (month1 != -1 ) && (month2 != -1) ){
	           return do_dateRange2( argv[2], month1, argv[0], 0, 0, 0, argv[5],month2,++argv[3],0 , 0, -1, gmt_value);
	       }
		   return false; //the input makes no sense
    	}

	    return false;//the input makes no sense

	}

	function monthToInt(month ){
	  if(month=="JAN") return 0;
	  if(month=="FEB") return 1;
	  if(month=="MAR") return 2;
	  if(month=="APR") return 3;
	  if(month=="MAY") return 4;
	  if(month=="JUN") return 5;
	  if(month=="JUL") return 6;
	  if(month=="AUG") return 7;
	  if(month=="SEP") return 8;
	  if(month=="OCT") return 9;
	  if(month=="NOV") return 10;
	  if(month=="DES") return 11;

      return -1;//makes no sense

	}

	function do_dateRange2(year1, month1, day1, hour1, min1, sec1, year2 ,month2, day2,  hour2, min2, sec2, gmt){
		 var now = new Date();
		 var date1= new Date(year1, month1, day1, hour1, min1, sec1);
		 var date2= new Date(year2, month2, day2, hour2, min2, sec2);

		 if( gmt != null && ( gmt == "GMT" )  ){
           now.setMinutes( now.getMinutes()-now.getTimezoneOffset());
         }


		return date1<now && date2>now;

	}

function  shExpMatch(str, shexp){
   var i= 0;
   var k= 0;
   var newone = shexp;

   while(i < shexp.length){
     if(shexp.charAt(i)=="*" ){
        newone = newone.substr(0,i+k)+".*"+newone.substr( i+k+1, newone.length-(i+k))  ;
        k++;
     }
     if(shexp.charAt(i)=="." ){
         newone = newone.substr(0,i+k)+"\\."+newone.substr( i+k+1, newone.length-(i+k))  ;
         k++;
     }
     if(shexp.charAt(i)=="?" ){
         newone = newone.substr(0,i+k)+"."+newone.substr( i+k+1, newone.length-(i+k));
     }
     i++;
   }
   newone="^"+newone+"$";

   regexp= new RegExp(newone);
   var tmp =  regexp.exec(str);

   return tmp!=null;

}

