// Copyright 2014 MathWorks, Inc.

define([
    "dijit/_WidgetBase",
    "dijit/_TemplatedMixin",
    "dojo/_base/declare",
    "dojo/_base/fx",
    "dojo/_base/lang",
    "dojo/dom-style",
    "dojo/i18n!l10n-addons/nls/addonsManager",
    "dojo/io-query",
    "dojo/mouse",
    "dojo/on",
    "dojo/dom-class",
    "dojo/text!templates-addons/InstalledAddonWidget.html",
    "addons/AddonsManager/UninstallAddonEvent",
    "addons/AddonsManager/OpenAddonGalleryDetailPageEvent",
    "addons/AddonsManager/ManagerToMatlabMessages",
    "addons/AddonsManager/AddonType",
    "addons/util/AddonsUtil",
    "require"
], function (_WidgetBase, _TemplatedMixin, declare, baseFx, lang, domStyle,
             addonsManagerResourceBundle, ioQuery, mouse, on, domClass, template, UninstallAddonEvent, OpenAddonGalleryDetailPageEvent, ManagerToMatlabMessages, AddonType, AddonsUtil) {

    return declare([_WidgetBase, _TemplatedMixin], {

        name: "",
        authorName: "",
        addOnType: "",
        installedDate: "",
        isMathworksSupported: false,
        imagePath: "",
        canUninstall: true,

        // Our template - important!
        templateString: template,

        // A reference to our background animation
        mouseAnim: null,

        // Colors for our background animation
        baseBackgroundColor: "#fff",
        mouseBackgroundColor: "rgb(232,235,242)",

        postCreate: function () {
            var domNode = this.domNode;
            var uninstallButtonNode = this.canUninstallNode;
            this.inherited(arguments);
            domStyle.set(domNode, "backgroundColor", this.baseBackgroundColor);
            domStyle.set(uninstallButtonNode, "backgroundColor", this.baseBackgroundColor);
            this.own(
                on(uninstallButtonNode, mouse.enter, lang.hitch(this, "_changeBackground", this.mouseBackgroundColor)),
                on(uninstallButtonNode, mouse.leave, lang.hitch(this, "_changeBackground", this.baseBackgroundColor)),
                on(uninstallButtonNode, "click", lang.hitch(this, function (evt) {
                    if (mouse.isLeft(evt)) {
                        var mlQueryParams = this._getQueryObjectFromURI();
                        var UninstallAddonEventInstance = new UninstallAddonEvent(mlQueryParams);
                        UninstallAddonEventInstance.publishMessage({
                            type: ManagerToMatlabMessages.UNINSTALL_ADD_ON,
                            addOnType: AddonsUtil.getAddonTypeFor(this.params.addOnType),
                            identifier: this.params.identifier
                        });
                        dojo.stopEvent(evt);
                    }
                })),
                on(domNode, "click", lang.hitch(this, "_openDetailPage"))
            );
        },

        _getQueryObjectFromURI: function(){
            var uri = window.location.href;
            var query = uri.substring(uri.indexOf("?") + 1, uri.length);
            var queryObject = ioQuery.queryToObject(query);
            return(queryObject);
        },

        _setImageDataAttr: function (imageData) {
            if (imageData !== "") {
                this._set("imageData", imageData);
                this.imageDataNode.src = imageData;
            }
        },

        _setAuthorNameAttr: function (authorName) {
            this.byLabel.innerHTML = addonsManagerResourceBundle.byLabel;
            if (authorName === "") {
                this.authorNameNode.innerHTML = "";
            }
        },

        _setInstalledDateAttr: function (date) {
            this.installedDateValue.innerHTML =  AddonsUtil._getFormattedDate(date);
            this.installedOnLabel.innerHTML = addonsManagerResourceBundle.installedOnLabel;
            if (date === "") {
                this.installedDateNode.innerHTML = "";
            }
        },

        _setAddOnTypeAttr: function (isMathworksSupported){
            if(this.isMathworksSupported){
                domClass.add(this.addOnTypeNode, "addonTypeIsMathworksSupported");
            }
        },

        _setCanUninstallAttr: function(){
            this.uninstallLabel.innerHTML = addonsManagerResourceBundle.uninstallLabel;
            if(!this.canUninstall){
                domStyle.set(this.canUninstallNode, "display", "none");
            }

        },

        _changeBackground: function (newColor) {
            this.mouseAnim = baseFx.animateProperty({
                node: this.canUninstallNode,
                properties: {
                    backgroundColor: newColor
                },
                onEnd: lang.hitch(this, function () {
                    this.mouseAnim = null;
                })
            }).play();
        },

        _openDetailPage: function(){
            var oldUrl = window.location.href;
            if(this.params.addOnType === AddonType.APP || this.params.addOnType === AddonType.TOOLBOX){
                window.location.href =  oldUrl+"&identifier="+this.params.identifier;
            }
            else{
                var mlQueryParams = this._getQueryObjectFromURI();
                var OpenAddonGalleryDetailPageEventInstance = new OpenAddonGalleryDetailPageEvent(mlQueryParams);
                OpenAddonGalleryDetailPageEventInstance.publishMessage({
                    type: ManagerToMatlabMessages.OPEN_GALLERY_DETAIL_PAGE,
                    identifier: this.params.identifier
                });
            }
        }
    });
});
