// Copyright 2014 MathWorks, Inc.

define([
    "dojo/_base/declare",
    "dojo/dom-style",
    "dojo/_base/lang",
    "dojo/on",
    "dojo/dom-class",
    "dojo/mouse",
    "dojo/io-query",
    "dojo/_base/fx",
    "dojo/i18n!l10n-addons/nls/addonsManager",
    "dijit/_WidgetBase",
    "dijit/_TemplatedMixin",
    "dojo/text!templates-addons/InstalledAddonDetailWidget.html",
    "addons/AddonsManager/UninstallAddonEvent",
    "addons/AddonsManager/ManagerToMatlabMessages",
    "addons/util/AddonsUtil",
    "require"
], function (declare, domStyle, lang, on, domClass, mouse, ioQuery, baseFx, addonsManagerResourceBundle, _WidgetBase, _TemplatedMixin, template, UninstallAddonEvent, ManagerToMatlabMessages, AddonsUtil) {
    return declare([_WidgetBase, _TemplatedMixin], {
        name: "",
        author: "",
        type: "",
        installedOn: "",
        isMathworksSupported: false,
        image: "",
        summary: "",
        description:"",

        // Our template - important!
        templateString: template,

        // A reference to our background animation
        mouseAnim: null,

        // Colors for our background animation
        baseBackgroundColor: "#fff",
        mouseBackgroundColor: "rgb(232,235,242)",

        postCreate: function () {
            var domNode = this.domNode;
            var uninstallButtonNode = this.canUninstallNode;
            this.inherited(arguments);
            domStyle.set(uninstallButtonNode, "backgroundColor", this.baseBackgroundColor);
            this.own(
                on(uninstallButtonNode, mouse.enter,
                    lang.hitch(this, "_changeBackground", this.mouseBackgroundColor)),
                on(uninstallButtonNode, mouse.leave,
                    lang.hitch(this, "_changeBackground", this.baseBackgroundColor)),
                on(uninstallButtonNode, "click", lang.hitch(this, function (evt) {
                    if (mouse.isLeft(evt)) {
                        var mlQueryParams = this._getQueryObjectFromURI();
                        var UninstallAddonEventInstance = new UninstallAddonEvent(mlQueryParams);
                        UninstallAddonEventInstance.publishMessage({
                            type: ManagerToMatlabMessages.UNINSTALL_ADD_ON,
                            addOnType: AddonsUtil.getAddonTypeFor(this.params.addOnType),
                            identifier: this.params.identifier
                        });
                        dojo.stopEvent(evt);
                    }
                }))
            );
        },

        _getQueryObjectFromURI: function(){
            var uri = window.location.href;
            var query = uri.substring(uri.indexOf("?") + 1, uri.length);
            var queryObject = ioQuery.queryToObject(query);
            return(queryObject);
        },

        _setImageDataAttr: function (imageData) {
            if (imageData !== "") {
                this._set("imageData", imageData);
                this.imageDataNode.src = imageData;
            }
        },

        _setAuthorNameAttr: function (authorName) {
            this.byLabel.innerHTML = addonsManagerResourceBundle.byLabel;
            if (authorName === "") {
                this.authorNameNode.innerHTML = "";
            }
        },

        _setInstalledDateAttr: function (date) {
            this.installedDateValue.innerHTML =  AddonsUtil._getFormattedDate(date);
            this.installedOnLabel.innerHTML = addonsManagerResourceBundle.installedOnLabel;
            if (date === "") {
                this.installedDateNode.innerHTML = "";
            }
        },

        _setAddOnTypeAttr: function (isMathworksSupported){
            if(this.isMathworksSupported){
                domClass.add(this.addOnTypeNode, "addonTypeIsMathworksSupported");
            }
        },

        _setCanUninstallAttr: function(){
            this.uninstallLabel.innerHTML = addonsManagerResourceBundle.uninstallLabel;
            if(!this.canUninstall){
                domStyle.set(this.canUninstallNode, "display", "none");
            }

        },

        _setVersionAttr: function(version){
            this.versionLabel.innerHTML = addonsManagerResourceBundle.versionLabel;
            if (version === "") {
                this.versionNode.innerHTML = "";
            }
        },

        _setDescriptionAttr: function(description){
            this.descriptionLabel.innerHTML = addonsManagerResourceBundle.descriptionLabel;
            if (description === "") {
                this.descriptionNode.innerHTML = "";
            }
        },

        _setFileLocationAttr: function (location) {
            this.fileLocationLabel.innerHTML = addonsManagerResourceBundle.fileLocationLabel;
            if(location !== ""){
                this._set("fileLocation", location);
                this.fileLocationNode.href = "matlab:cd('"+location+"')";
                this.fileLocationLinkLabel.innerHTML = addonsManagerResourceBundle.fileLocationLinkLabel;
            }
        },

        _setFileNameAttr: function (list) {
            this.viewFileListLabel.innerHTML = addonsManagerResourceBundle.viewFileListLabel;
            if(list !== []){
                var files = "";
                var location = this._get("fileLocation");
                var absoluteFilePath = this._get("absoluteFilePath");
                var fileName = this._get("fileName");
                var i = 0;
                list.forEach(function (file) {
                    files += "<div class='detailedDescription'><a href=\"matlab:open('" +
                        absoluteFilePath[i] + "');\">" + fileName[i] + "</a></div>";
                    i++;
                });
                this.fileListNode.innerHTML = files;
            }
        },

        _changeBackground: function (newColor) {
            this.mouseAnim = baseFx.animateProperty({
                node: this.canUninstallNode,
                properties: {
                    backgroundColor: newColor
                },
                onEnd: lang.hitch(this, function () {
                    this.mouseAnim = null;
                })
            }).play();
        }
    });
});
