/**
 * Created with IntelliJ IDEA.
 * User: kkaminen
 * Date: 3/7/14
 * Time: 1:54 PM
 * To change this template use File | Settings | File Templates.
 */

define(["dojo/_base/declare",
    "dojo/_base/lang",
    "dojo/dom-construct",
    "dijit/_WidgetBase",
    "dijit/_Container",
    "gbt/widgetview/customdijit/Canvas"
], function (declare, lang, dom, _WidgetBase, _Container, Canvas) {

    return declare([_WidgetBase, _Container], {

        constructor: function (args) {
            if (!(args && args.PeerChannelId)) {
                throw new Error('PeerChannelId must be passed to the GraphicsContainer constructor');
            }

            this.PeerChannelId = args.PeerChannelId;
        },

        //startup is where you add the children of the widget
        startup: function () {
            this.CanvasDijit = new Canvas({Container: this, PeerChannelId: this.PeerChannelId});
            this.CanvasDijit.addToContainer(this);

            this.inherited(arguments);
        },

        setDefaultDimensions: function () {
            this.CanvasDijit.setDefaultDimensions();
        },

        renderGraphics: function () {
            this.CanvasDijit.redrawCanvas();
        }
    });
});