/**
 * Created by IntelliJ IDEA.
 * User: ppremaku
 * Date: 1/24/12
 * Time: 12:59 PM
 * To change this template use File | Settings | File Templates.
 */


//dojo.declare("visualcomponents.graphics.hg2Canvas.HTML5CanvasController", null, {
define([
    "dojo/_base/declare",
    "dojo/aspect",
    "dojo/_base/lang",
    "dojo/dom-style",
	"dojo/window",
    "gbt/widgetview/customdijit/Figure",
	"visualcomponents/graphics/hg2Canvas/HTML5CanvasModel",
	"visualcomponents/graphics/hg2Canvas/HTML5CanvasView",
	"visualcomponents/graphics/MWSG/json_scenetree",
	//"visualcomponents/graphics/MWSG/Interaction3d",
	"MW/remote/MessageService"
], function (declare, aspect, lang, domStyle, win, Figure, HTML5CanvasModel, HTML5CanvasView, json_scenetree, MessageService) {

    return declare([], {

		constructor: function (args, widgetData) {
			//Input Validation
			if (args && args.parent === null) {
				throw new Error('Parent argument must be passed to the hgCanvasController constructor');
			}

			if (args && args.Container === null) {
				throw new Error('Container argument must be passed to the hgCanvasController constructor');
			}

			if (widgetData === null) {
				throw new Error('WidgetData must be passed to the hgCanvasController constructor');
			}

			// Create the model
			this._model = new HTML5CanvasModel(args);
			this._parent = args.parent;
			this.ID = widgetData.getId();

			this._container = args.Container;

			// Create the view
			this._view = new HTML5CanvasView(args);
			/*jslint undef: false*/
			// SceneTree
			this._st = new json_scenetree(this);
			/*jslint undef: true*/
			this._st.setCanvas(this._view.getCanvas());

			MessageService.subscribe("/canvas/" + this.ID + "/command", lang.hitch(this, this.process_cmd));

			// set the renderer to painters for now
			this.process_cmd({ data: {cmd: "setRenderMode", mode: "painters"}});

			// Interactions
			// Removed to disable interactions
			//this._PZR = new Interaction3d(this.getSceneTree(), this._view.getCanvas(), 3);

			// listen to changes in the Axes widget data for resizing
			widgetData.on("propertiesSet", dojo.hitch(this, function (eventData) {

				this.redrawCanvas(eventData);
			}));

			//Listen for this event for canvas window resize
			widgetData.on("PositionChanged", dojo.hitch(this, function (eventData) {

				this.redrawCanvas(eventData);
			}));

			//When everything is complete, tell the server to begin sending events to the scene tree
			widgetData.dispatchEventToServer('CanvasReady', { eventType: 'CanvasReady' });
		},

		redrawCanvas: function (eventData) {
			var size = this._container._contentBox;

			var width = size.w;//size[0];
			var height = size.h;//size[1];

			this._view.setCanvasSize(width, height);

			// added by aswens
			//
			// redraw the scene tree when a property changes
			//
			// When size / location / etc.. changes, then the scenetree needs to be manually told that it has updated
			//
			// Without this explicit call, the canvas will not re-draw when it is dragged and moved in App Designer
			this._st.draw();
		},

		replaceParent: function (parent) {
			//todo Do I need this?
			this._view.replaceParent(parent);
		},

		replaceCanvas: function () {
			this._view.replaceCanvas();

			// Removed to disable interactions
			// this._PZR = new Interaction3d(this.getSceneTree(), this.getCanvas(), 3);
		},

		getSceneTree: function () {
			return this._st;
		},

		getCanvas: function () {
			return this._view.getCanvas();
		},

		setCanvas: function (args) {
			// Do Nothing for now
		},

		process_cmd: function (cmd) {
			// Do stuff
			/*jslint undef: false*/
			/*
			console.log('*********** process_cmd ************');
			console.log(cmd);
			console.log('*********** process_cmd ************');
			*/

			if (!(cmd && cmd.data)) {
				throw new Error('Argument cmd must have a valid data object');
			}

			this._st.process_cmd(cmd.data);
			/*jslint undef: true*/
		}

    });
});
