define([
	"dojo/_base/declare",
    "dojo/dom-construct","dojo/dom-class","dojo/mouse","dojo/_base/fx","dojo/fx","dojox/fx",
	"MW/dialog/DialogUtils",
	"dojo/i18n!cswebview/app/l10n/nls/app",
    "MW/facade/MatlabFacade",
    "dojo/parser", "dojo/on",
    "dijit/form/Select","dijit/form/TextBox","dijit/form/CheckBox", "dijit/form/NumberSpinner", "dijit/form/Textarea","dijit/form/SimpleTextarea","dijit/form/ComboBox","dijit/form/NumberTextBox","dijit/form/ValidationTextBox","dijit/InlineEditBox",
    "dijit/Menu", "dijit/MenuItem","dijit/MenuSeparator",
    "dijit/layout/ContentPane","dojox/layout/TableContainer","dijit/TitlePane", "dojox/layout/ScrollPane"
], function (declare, domConstruct, domClass, mouse, baseFx, fx, xfx,
             DialogUtils,appL10n,
             MatlabFacade,
             parser,on,
             Select, TextBox, CheckBox, NumberSpinner, Textarea, SimpleTextarea, ComboBox, NumberTextBox, ValidationTextBox,InlineEditBox,
             Menu,MenuItem,MenuSeparator,
             ContentPane, TableContainer, TitlePane, ScrollPane
            ) {
	return declare(null, {
	    constructor: function(rootNode) {
	        this.domNode = rootNode;
	    },
		
		start: function () {

            var mypath = "";
            var mygrid = {};
            mydata = [];
            myhash = {};
            var myfacade = {};
            var mymsg = "";
            var myDom = {};
            var myClass = {};
            myBaseFx = {};
            myFx = {};
            myxFx = {};
            comps = {};

            
            myDom = domConstruct;
            myClass = domClass;
            myBaseFx = baseFx;
            myFx = fx;
            myxFx = xfx;

            var that = this;
            var cs_str = "Configuration Parameters: ";

            var top = new dijit.layout.ContentPane({id:"cs_top",class:"cs_top"}).placeAt(that.domNode);
            

            var sys = domConstruct.create('div',{id:"sys"}, top.domNode);

            var count = domConstruct.create('div',{id:"count", innerHTML:cs_str}, sys);

            var filter = createFilterAt(sys);

            var params = domConstruct.create("div",{id:"cs_params",class:"cs_params"}, that.domNode);

            var overlay = domConstruct.create("div",{
                id:"overlay",
                class:"overlay",
            }, that.domNode);
            var overlayCenter = domConstruct.create("center", {
                id:"overlayCenter", class:"overlayCenter"
            },overlay);
            var loadingAnimation = domConstruct.create("img", {
                src:"images-cswebview/loadingAnimation.gif"
            }, overlayCenter);
            var overlayMessage = domConstruct.create("span", {
                id:"overlayMessage",
                class:"overlayMessage",
                innerHTML:"Loading parameters ..."
            }, overlayCenter);
            

            function createFilterAt(sys) {
                var w1 = domConstruct.create('input', {
			        id:"filter",
			        type:"search",
			        class:"filter",
			        placeHolder:"filter parameters by",
			        intermediateChanges: true
		        });

		        
		        var w2 = new dijit.form.TextBox({
			        id:"filter",
			        type:"search",
			        class:"filter",
			        placeHolder:"filter parameters by",
			        intermediateChanges: true
		        });

		        var img = domConstruct.create('img', {
			        src:"images-cswebview/search_24.png",
			        class:"filter_icon",
					
		        });


                var c = new dijit.form.Select({id:"filter_select", class:"filter_select",value:"name", options:[{label:"Name", value:"name"},{label:"Value", value:"value"}]});


                
                c.placeAt(sys);

		        // domConstruct.place(w1, sys);
		        w2.placeAt(sys);
		        w = w2;

		        on(w,"change",function(){
                    filtering(w.value, c.value);
                });
                on(w,"keypress",function(evt){
                    if (evt.keyCode == 13) {
                        filtering(w.value, c.value);
                    }
                });
                on(c,"change",function(){
                    filtering(w.value, c.value);
                });
                
		        domConstruct.place(img, w.domNode, 'first');
            }


            function filtering(v,s){
		        if (s=="name") {
			        filterByName(v);
		        } else {
			        filterByValue(v);
		        }
	        }

	        function filterByName(v){

		        for (var c in comps) {
			        comps[c].count = comps[c].total;
		        }
		        
                v = v.trim();
                
                var v_low = v.toLowerCase();
                if (v_low == v) {
                    var r = new RegExp(v,'gim');
                } else {
                    var r = new RegExp(v,'gm');
                }

                var sum = mydata.length;

                for (var i = 0, n = mydata.length; i < n; i++) {
                    var p = mydata[i];
			        var c = comps[p.listview_component];
                    var q = myhash[p.fullname];

                    var card = q.card;
                    var prompt_dom = q.name;
                    var api_dom = q.api
                    var input = q.input;
                    if (input instanceof dijit.form.Select) {
                        input._resetValue = input.value;
                        input.reset();
                    }
                    
                    var disp = "";
                    
                    if (v) {
                        var prompt_find = p.prompt.search(r);
                        var prompt_str = p.prompt.replace(r, "<span class='highlight'>"+"$&"+"</span>");

                        var api_find = p.name.search(r);
                        var api_str = p.name.replace(r, "<span class='highlight'>"+"$&"+"</span>");

                        if (prompt_find == -1 && api_find == -1) {
                            var disp = "none";
                            sum = sum - 1;
					        c.count--;
                        }
                        
                    } else {
                        var api_str = p.name;
                        var prompt_str = p.prompt;
                        sum = mydata.length;
                    }

			        c.widget.set('title', c.title + c.count + "/" + c.total);
			        c.widget.set('open', true);

                    card.set("style",{"display": disp});
                    prompt_dom.innerHTML = prompt_str;
                    api_dom.innerHTML = api_str;

                }

                count.innerHTML = cs_str + sum + "/" + mydata.length;

		        for (var k in comps) {
			        c = comps[k];
			        if (c.count == 0) {
				        c.widget.set('style', {"display":"none"});
			        } else {
				        c.widget.set('style', {"display":""});
			        }
			        
		        }
            }

	        function filterByValue(v){

		        for (var c in comps) {
			        comps[c].count = comps[c].total;
		        }
		        
                v = v.trim();
                
                var v_low = v.toLowerCase();
                if (v_low == v) {
                    var r = new RegExp(v,'gim');
                } else {
                    var r = new RegExp(v,'gm');
                }

                var sum = mydata.length;

                for (var i = 0, n = mydata.length; i < n; i++) {
                    var p = mydata[i];
			        var c = comps[p.listview_component];
                    var q = myhash[p.fullname];
                    var card = q.card;
                    var input = q.input;

                    var prompt_dom = q.name;
                    if (prompt_dom) {
                        prompt_dom.innerHTML = p.prompt;
                    }
                    
                    var api_dom = q.api;
                    if (api_dom) {
                        api_dom.innerHTML = p.name;
                    }

                    
                    var disp = "";

                    var val = JSON.stringify(p.value);
                    if (input instanceof dijit.form.Select) {
                        for (var j = 0, m = input.options.length; j < m; j++) {
                            var o = input.options[j];
                            if (o.value == p.value) {
                                val = o.label;
                            }
                        }
                    }


                    
                    if (v) {
                        var val_find = val.search(r);
                        var val_str = val.replace(r, "<span class='highlight'>"+"$&"+"</span>");


                        if (p.value === true) {
                            if (v === "on" || v === "true") {
                                val_find = 1;
                            } else {
                                val_find = -1;
                            }
                        } else if (p.value === false) {
                            if (v === "off" || v === "false") {
                                val_find = 1;
                            } else {
                                val_find = -1;
                            }
                        }



                        if (val_find == -1) {
                            disp = "none";
                            sum = sum - 1;
					        c.count--;
					        if (input instanceof dijit.form.Select) {
                                input._resetValue = input.value;
						        input.reset();
					        }

					        
                        } else {
					        if (p.type == "enum") {
						        var span = input.domNode.getElementsByTagName("span")[0];
						        span.innerHTML = val_str;
					        } else if(p.type == "string") {
						        // var hit = new dijit.Tooltip({
							    // connectId:val_dom.id,
							    // label:val_str,
						        // })
						        // hit.open();
					        }
				        }
                        
                    } else {
                        var val_str = val;
                        sum = mydata.length;
				        if (input instanceof dijit.form.Select) {
                            input._resetValue = input.value;
					        input.reset();
				        }
                    }

			        c.widget.set('title', c.title + c.count + "/" + c.total);
			        c.widget.set('open', true);

                    card.set("style",{"display": disp});
                }

                count.innerHTML = cs_str + sum + "/" + mydata.length;

		        for (var k in comps) {
			        c = comps[k];
			        if (c.count == 0) {
				        c.widget.set('style', {"display":"none"});
			        } else {
				        c.widget.set('style', {"display":""});
			        }
			        
		        }
            }

            function scrollTo(comp) {
                var c = comps[comp];
                if (c) {
                    c.widget.domNode.scrollIntoView();
                }
            }
            
            function initialize(data) {
                params.innerHTML = '';
                comps = {};
		        var c = {};
                for (var i = 0, n = data.length; i < n; i++){
                    var p = data[i];
                    var card = get(p, "card");

			        if (comps.hasOwnProperty(p.listview_component)){
				        c = comps[p.listview_component];
			        } else {
				        var w = new dijit.TitlePane({open:true,title:p.listview_component,class:"group"});
				        w.placeAt(params);
				        c = {title:p.listview_component + ": ", widget:w, count:0, total:0};
				        comps[p.listview_component] = c;
			        }
			        
                    card.placeAt(c.widget);
			        c.total++;
                    if (card.style.display !== "none"){
			            c.count++;
                    }
			        c.widget.set('title', p.listview_component + ": " + c.count + "/" + c.total);
                    count.innerHTML = cs_str + (i+1) + "/" + mydata.length;

                    if (c.count == 0) {
				        c.widget.set('style', {"display":"none"});
			        } else {
				        c.widget.set('style', {"display":""});
			        }
                }

                setupMenu();
                setupStatus();

                domClass.add(overlay, 'finish');                
            }

            function setupMenu(){
                var ids = new Array;
                for (var i = 0, n = mydata.length; i < n; i++){
                    var p = mydata[i];
                    ids[i] = p.fullname+"_card";
                }
                
                var pMenu = new dijit.Menu({
                    targetNodeIds: ids
                });
                pMenu.addChild(new dijit.MenuItem({
                    label: "What's this?"
                }));
                pMenu.addChild(new dijit.MenuSeparator());
                pMenu.addChild(new dijit.MenuItem({
                    label: "Show in Category View",
                    onClick:function(evt){
                        var id = this.getParent().currentTarget.id;
                        var st = id.indexOf(':')+1;
                        var len = id.indexOf('_')-st;
                        var name = id.substr(st, len);
                        myfacade.publish(mypath+"/locateInDialog", name);
                        clearHighlights();
                    }
                }));
            }

            function setupStatus(){
                for (var i = 0, n = mydata.length; i < n; i++) {
                    var p = mydata[i];
                    var card = myhash[p.fullname].card;
                    var input = myhash[p.fullname].input;
                    if (p.status > 0 || p.locked == 1){
                        domClass.add(card.domNode, ("card-disabled"));
                        input.set('disabled', true, false);
                    } else {
                        domClass.remove(card.domNode, ("card-disabled"));
                        input.set('disabled', false, false);
                    }
                }
            }

            function resizeCard(p) {
                var q = myhash[p.fullname];
                
                var c = q.card;
                var v = q.value;
                
                var t = q.title;
                var n = q.name;
                var d = q.dscr;
                var a = q.info;
                
                p.expand = p.expand ? false : !p.expand;

                if (p.expand) {
                    var a1 = baseFx.animateProperty({
                        node:c.domNode,
                        properties:{
                            "margin":{start:8,end:30},
                            "-webkit-border-radius":{start:3,end:10}
                        },
                        onAnimate:function(){c.domNode.scrollIntoViewIfNeeded();},
				        onBegin:function(){
					        domClass.add(c.domNode, "expand");
					        domClass.add(t, "expand");
					        domClass.add(v.domNode, "expand");
					        domClass.add(a.domNode, "expand");
					        domClass.add(d, "expand");
				        }
                    });

                    var a2 = baseFx.animateProperty({
                        node:t,
                        properties:{
                            "min-height":300,
					        "font-size":{start:18,end:24}
                        },
                    });

                    var a3 = baseFx.animateProperty({
                        node:n,
                        properties:{
                            "min-height":30,
                        },
                    });

			        fx.combine([a1,a2,a3]).play();
                    
			        
                    
                } else {
                    var a1 = baseFx.animateProperty({
                        node:c.domNode,
                        properties:{
                            "margin":{start:30,end:8},
                            "-webkit-border-radius":{start:10,end:3}
                        },
                        onAnimate:function(){
					        c.domNode.scrollIntoViewIfNeeded();
				        },
				        onPlay:function(){
					        domClass.remove(d, "expand");
					        domClass.remove(c.domNode, "expand");
					        domClass.remove(t, "expand");
					        domClass.remove(v.domNode, "expand");
				        },
				        onEnd:function(){
					        domClass.remove(a.domNode, "expand");
				        }
                    });
                    
			        var a2 = baseFx.animateProperty({
                        node:t,
                        properties:{
                            "min-height":0,
					        "font-size":{start:24, end:18}
                        },
                    });
                    
			        var a3 = baseFx.animateProperty({
                        node:n,
                        properties:{
                            "min-height":0,
                        },
                    });

			        fx.combine([a1,a2,a3]).play();
                }

                var exp = q.exp;
                if (p.expand) {
                    exp.src = "images-cswebview/arrow_contract.png";
                } else {
                    exp.src = "images-cswebview/arrow_expand.png";
                }
            }
            

            
            function createParamCard(p, id) {
                out = new dijit.layout.ContentPane({id:id, class:"card"});
                
                var t = get(p, "title");
                var v = get(p, "value");
                var a = get(p, "info");
                var exp = get(p, "exp");
                
                domConstruct.place(t, out.domNode);
                v.placeAt(out);
                a.placeAt(out);
                domConstruct.place(exp, out.domNode);
                
                return out;
            }

            function createParamExpandIcon(p, id) {
                var exp = domConstruct.create('img', {
                        id:id,
                        class:"exp",
                        src:"images-cswebview/arrow_expand.png"
                });

                on(exp, "click", function(){
                    resizeCard(p);
                })

                return exp;
            }

            function createParamTitle(p, id) {
                var out = domConstruct.create("div", {id:id, class:"title"});
                
                var name = get(p, "name");
                var dscr = get(p, "dscr");

                domConstruct.place(name, out);
                domConstruct.place(dscr, out);

                return out;
            }

            function createParamName(p, id) {
                return domConstruct.create("div", {id:id, "class":"name", "innerHTML":p.prompt, "title":"Display name"});
            }

            function createParamDscr(p, id) {
                return domConstruct.create("div", {id:id, "class":"dscr", "innerHTML":p.tooltip});
            }

            function createParamValue(p, id) {
                var pane =  new dijit.layout.ContentPane({id:id, class:"value", "title":"Parameter value"});
                var w = get(p, "input");
                w.placeAt(pane);
                return pane;
            }

            function createParamInfo(p, id) {
                var out = new dijit.layout.ContentPane({id:id, class:"info"});
                // var out = new dojox.layout.ScrollPane({id:id, class:"info"});

                var api = get(p, "api");
                var comp = get(p, "comp");
                var val = get(p, 'val');

                domConstruct.place(comp, out.domNode);
                domConstruct.place(val, out.domNode);
                domConstruct.place(api, out.domNode);

                domClass.add(comp, "hide");
                domClass.add(val, "hide");

                return out;
            }

            function createParamVal(p, id) {
                var v = JSON.stringify(p.value);
                return domConstruct.create("div", {id:id, "class":"val", "innerHTML":v});
            }

            function createParamApi(p, id) {
                return domConstruct.create("div", {id:id, "class":"api", "innerHTML":p.name, "title":"Command-line name"});                
            }

            function createParamComp(p, id) {
                return domConstruct.create("div", {id:id, "class":"comp", "innerHTML":p.listview_component});
            }
            

            function updateParamCard(p) {
                var q = myhash[p.fullname];
                var card = q.card;
                if (p.status > 0){
                    domClass.add(card.domNode, ("card-disabled"));
                } else {
                    domClass.remove(card.domNode, ("card-disabled"));
                }

                var pane = q.value;
                updatePane(pane, p);
            }

            function sendMsg(msg) {
                myfacade.publish(mypath+"/callback", msg);
            }

            
            // var MyGrid = dojo.declare([Grid,DijitRegistry,Hider,ColumnResizer]);
            
            genHash(mydata);
            mypath = location.search.substring(1);
            myfacade = new MatlabFacade();
            establishConnection(mypath);

            // mygrid.startup();
            

            // mygrid.renderArray(mydata);


            // functions ...

            function genHash(data) {
                for (var i = 0, l = data.length; i < l; i++) {
                    var p = data[i];
                    var q = myhash[p.fullname];
                    if (q) {
                        q.data = p;
                        q.id = i;
                    } else {
                        myhash[p.fullname] = {data:p, id:i};
                    }
                }
            }


            function callback(object, data) {
                var fullname = object.fullname;
                var obj = myhash[fullname].data;
                if (obj.value == data.value) {
                    return;
                }
                
                obj.value = data.value;
                myfacade.publish(mypath+"/callback", data);
                var w = dijit.registry.byId(fullname+'_input');
                domClass.add(w.domNode, 'dirty');

                if (obj.name == "SystemTargetFile") {
                    overlayMessage.innerHTML = "Switching target ..."
                    domClass.remove(overlay, 'finish');
                }
            }

            function establishConnection(path) {
                mypath = path;
                
                var init = myfacade.subscribe(mypath+"/init", function (message) {
                    var data = JSON.parse(message.data);
                    mydata = data;
                    genHash(mydata);
                    initialize(data);
                    // domConstruct.place(params, that.domNode);

                    var var_update = myfacade.subscribe(mypath+"/update", function (message) {
                        var p = JSON.parse(message.data);
                        update(p);
                    });

                    var var_refresh = myfacade.subscribe(mypath+"/refresh", function (message) {
                        mydata = JSON.parse(message.data);
                        genHash(mydata);

                        var top = params.scrollTop;
                        params.innerHTML = "";
                        initialize(mydata);
                        params.scrollTop = top;
                        
                    });

                    var var_highlight = myfacade.subscribe(mypath+"/highlight", function (message) {
                        var name = message.data;
                        var w = dijit.registry.byId(name+"_card");
                        if (w) {
                            domClass.add(w.domNode, "param_highlight");
                            w.domNode.scrollIntoViewIfNeeded();
                        }
                    });

                    var var_clearHighlights = myfacade.subscribe(mypath+"/clearHighlights", function (message) {
                        clearHighlights();
                    });

                    var var_scrollTo = myfacade.subscribe(mypath+"/scrollTo", function (message){
                        scrollTo(message.data);
                    });

                    var var_destroy = myfacade.subscribe(mypath+"/destroy", function (message) {
                        // that.domNode.innerHTML = "The Configuration Set is closed";
                    });
                    
                });

                myfacade.publish(mypath, "ready");
            }

            function clearHighlights() {
                for (var name in myhash){
                    var w = myhash[name].card;
                    domClass.remove(w.domNode, "param_highlight");
                }
            }

            function updatePane(pane, object) {
                var q = myhash[object.fullname];
                var w;
                switch (object.type) {
                case "enum":
                case "int" :
                case "boolean":
                case "string":
                case "minmax":
                    w = q.input;
                    if (w) {
                        updateWidget(w, object);
                    } else {
                        console.log("cannot update: " + object.fullname);
                    }
                    break;
                default:
                    pane.destroyDescendants();
                    w = create(object, "input");
                    w.placeAt(pane);
                }
            }
            
            function createWidget(object, id) {
                var w;
                switch (object.type) {
                case "enum":
                    var opt = JSON.parse(JSON.stringify(object.options));
                    for (var i = 0, n = opt.length; i < n; i++){
                        opt[i].label = opt[i].label.replace('<', '&lt;');
                        opt[i].label = opt[i].label.replace('>', '&gt;');
                    }
                    w = new dijit.form.Select({id:id, value:object.value, options:opt,style:{"width":'100px'}});
                    on(w, "change", function () {callback(object, {name:object.name, value:w.value});});
                    break;
                case "int":
                    w = new dijit.form.NumberTextBox({
                        intermediateChanges:false,
                        required:true,
                        id:id,
                        value:object.value,
                        invalidMessage:"Only accepts numbers"
                    });
                    
                    on(w, "change", function () {
                        if (w.isValid()) {
                            callback(object, {name:object.name, value:w.value});
                        }
                    });
                    break;
                case "boolean":
                    w = new dijit.form.CheckBox({id:id, checked:object.value});
                    on(w, "change", function () {callback(object, {name:object.name, value:w.checked});});
                    break;
                case "string":
                    if (object.value instanceof Array) {
                        object.value = "";
                    }

                    w = new dijit.form.TextBox({intermediateChanges:false,id:id, value:object.value, placeHolder:"<empty>"});
                    on(w, "change", function () {
                        callback(object, {name:object.name, value:w.displayedValue});
                    });
                    on(w,"keypress",function(evt){
                        if (evt.keyCode == 13) {
                            callback(object, {name:object.name, value:w.displayedValue});
                        }
                    });
                    break;
                    
                case "minmax":
                    w = new dijit.form.NumberSpinner({
                        placeHolder:"min:" + object.min + " max:" + object.max,
                        intermediateChanges:false,
                        required:true,
                        id:id,
                        value:object.value,
                        constraints:{min:object.min, max:object.max},
                        invalidMessage:"Only accepts integer from " + object.min + " to " + object.max
                    });
                    
                    on(w, "change", function () {
                        if (w.isValid()) {
                            callback(object, {name:object.name, value:w.value});
                        }
                    });
                    break;
                default:
                    w = getAutoWidget(object.value, object.status > 0 || object.locked == 1, object, "value", object);
                    break;
                }
                w.set("disabled", object.status > 0 || object.locked == 1, false);
                domClass.add(w.domNode, "value_widget");
                return w;
            }

            function getAutoWidget(value, status, ref, id, param){
                var t;
                var w;
                if (value instanceof Array) {
                    t = new dijit.TitlePane({open:true,title:"Array ["+value.length+"]"});
                    w = new dojox.layout.TableContainer({"labelWidth":"1%",customClass:"myclass"});
                    for (var i = 0; i < value.length; i++) {
                        var c = getAutoWidget(value[i], status, value, i, param);
                        c.set('label', '#'+(i+1)+":", false);
                        w.addChild(c);
                    }
                    w.placeAt(t);
                    w.startup();
                    w.set("disabled", status > 0);
                }else if(value instanceof Object) {
                    t = new dijit.TitlePane({open:true,title:"Object"});
                    w = new dojox.layout.TableContainer({"labelWidth":"1%",customClass:"myclass"});
                    for (var k in value) {
                        var c =  getAutoWidget(value[k], status, value, k, param);
                        c.set('label', k+":", false);
                        w.addChild(c);
                    }
                    w.placeAt(t);
                    w.startup();
                    w.set("disabled", status > 0);
                }else if(value.constructor === Number) {
                    t = new dijit.form.NumberTextBox({intermediateChanges:false,value:value,invalidMessage:"Only accepts numbers"});

                    on(t, "change", function () {
                        if (t.isValid()){
                            ref[id] = t.value;
                            sendMsg({name:param.name, value:param.value});
                        }
                    });
                }else if(value.constructor === String) {
                    t = new dijit.form.TextBox({intermediateChanges:false,value:value});

                    on(t, "change", function () {
                        ref[id] = t.value;
                        sendMsg({name:param.name, value:param.value});
                    });
                }else if(value.constructor === Boolean) {
                    t = new dijit.form.CheckBox({checked:value});
                    
                    on(t, "change", function () {
                        ref[id] = t.checked;
                        sendMsg({name:param.name, value:param.value});
                    });
                }

                t.set("disabled", status > 0 );
                return t;
            }

            function updateWidget (w, object) {
                if (object.fullname == "Solver:Solver") {
                    w.options = JSON.parse(JSON.stringify(object.options));
                    w.startup();
                }
                
                if (w instanceof dijit.form.CheckBox) {
                    w.set("checked", object.value, false);
                } else {
                    w.set("value", object.value, false);
                }
                w.set("disabled", object.status > 0 || object.locked == 1, false);
            }

            function get(p, content) {
                var out = myhash[p.fullname][content];
                if (!out) {
                    out = create(p, content);
                }
                return out;
            }

            function create(p, content) {
                var id = p.fullname+"_"+content;
                var out;
                switch (content) {
                case "card":
                    out = createParamCard(p, id);
                    break;
                    
                case "title":
                    out = createParamTitle(p, id);
                    break;
                case "name":
                    out = createParamName(p, id);
                    break;
                case "dscr":
                    out = createParamDscr(p, id);
                    break;
                    
                case "value":
                    out = createParamValue(p, id);
                    break;
                case "input":
                    out = createWidget(p, id);
                    break;
                    
                case "info":
                    out = createParamInfo(p, id);
                    break;
                case "api":
                    out = createParamApi(p, id);
                    break;
                case "comp":
                    out = createParamComp(p, id);
                    break;
                case "val":
                    out = createParamVal(p, id);
                    break;
                    
                    
                case "exp":
                    out = createParamExpandIcon(p, id);
                    break;
                default:
                    out = createParamCard(p, id);
                }

                myhash[p.fullname][content] = out;
                return out;
            }

            function update(p, content) {
                if (myhash.hasOwnProperty(p.fullname)) {
                    var q = myhash[p.fullname];
                    if (JSON.stringify(q.data) == JSON.stringify(p)) {
                        return;  // prevent self-circle
                    }
                    q.data = p;
                    mydata[q.id] = p;
                } else {
                    console.log('cannot update param: ' + p.fullname);
                }

                switch (content) {
                case "card":
                    updateParamCard(p);
                    break;
                default:
                    updateParamCard(p);
                }
            }
            
            
		},
	});
});
