var mypath = "";
var mygrid = {};
var mydata = [];
var myhash = {};
var myfacade = {};
var mymsg = "";
var myDom = {};
var myBaseFx = {};



define([
	"dojo/_base/declare",
    "dojo/dom-construct","dojo/dom-class","dojo/mouse","dojo/_base/fx",
	"MW/dialog/DialogUtils",
	"dojo/i18n!cswebview/app/l10n/nls/app",
    "MW/facade/MatlabFacade",
    "dojo/parser", "dojo/on",
    "dijit/form/Select","dijit/form/TextBox","dijit/form/CheckBox", "dijit/form/NumberSpinner", "dijit/form/Textarea","dijit/form/SimpleTextarea","dijit/form/ComboBox","dijit/form/NumberTextBox","dijit/form/ValidationTextBox","dijit/InlineEditBox",
    "dijit/layout/ContentPane","dojox/layout/TableContainer","dijit/TitlePane"
], function (declare, domConstruct, domClass, mouse,fx,
             DialogUtils,appL10n,
             MatlabFacade,
             parser,on,
             Select, TextBox, CheckBox, NumberSpinner, Textarea, SimpleTextarea, ComboBox, NumberTextBox, ValidationTextBox,InlineEditBox,
             ContentPane, TableContainer, TitlePane
            ) {
	return declare(null, {
	    constructor: function(rootNode) {
	        this.domNode = rootNode;
	    },
		
		start: function () {
            
              mytest = [{"id":1,"status":1,"name":"A","fullname":"Solver:A","type":"struct","prompt":"Param A:","tooltip":"Simulation start time. Note that the values that you specify\nas block initial conitions must be their values at this time.","component":"Solver","dependency":"","value": [{"a":true, "b":5, "c":"hello", "d":{"x":1,"y":2}, "e":[3, 4, "one", "two", {"r":true, "t":0}]}, "string", true ]
              },
              {"id":2,"status":0,"name":"B","fullname":"Solver:B","type":"struct","prompt":"Param B:","tooltip":"Simulation start time. Note that the values that you specify\nas block initial conitions must be their values at this time.","component":"Solver","dependency":"", "value": [{"asdfsdfasdfasdf234234234234asdf":true, "b":5, "c":"hello", "d":{"x":1,"y":2}, "e":[3, 4, "one", "two", {"r":true, "t":0}]}, "string124", true ]
              },
              {"id":3,"status":0,"name":"C","fullname":"Solver:C","type":"struct","prompt":"Param C:","tooltip":"Simulation start time. Note that the values that you specify\nas block initial conitions must be their values at this time.","component":"Solver","dependency":"", "value": 7 },
              {"id":4,"status":0,"name":"D","fullname":"Solver:D","type":"struct","prompt":"Param D:","tooltip":"Simulation start time. Note that the values that you specify\nas block initial conitions must be their values at this time.","component":"Solver","dependency":"", "value": {"a":"s","b":"y"} },

              ];

            myDom = domConstruct;
            myBaseFx = fx;

            var that = this;

            var top = new dijit.layout.ContentPane({id:"cs_top",class:"cs_top",innerHTML:"<div class='cs_name'>Configuration Set</div>"}).placeAt(that.domNode);

            var sys = domConstruct.create('div',{class:"cs_sys",innerHTML:"System Target File: "}, top.domNode);
            // var tlc = new dijit.InlineEditBox({id:"CodeGeneration:SystemTargetFile_value",editor:"text",autoSave: false});
            var tlc = new dijit.form.TextBox({id:"CodeGeneration:SystemTargetFile_value"});
            tlc.placeAt(sys);
            var filter = createFilter();
            filter.placeAt(sys);
            var params = domConstruct.create("div",{id:"cs_params",class:"cs_params"});




            

            function createFilter() {
                var w = new dijit.form.TextBox({placeHolder:"filter by name...",intermediateChanges: true});
                domClass.add(w.domNode, "filter");
                on(w,"change",function(){
                    filtering(w.value);
                });
                return w;
                
            }

            function filtering(v){
                // var root = document.getElementById('root');
                // var params = document.getElementById('cs_params');
                // root.removeChild(params);
                
                v = v.trim();
                
                var v_low = v.toLowerCase();
                if (v_low == v) {
                    var r = new RegExp(v,'gim');
                } else {
                    var r = new RegExp(v,'gm');
                }

                for (var i = 0, n = mydata.length; i < n; i++) {
                    var p = mydata[i];
                    if (p.name == "SystemTargetFile") {
                        continue;
                    }

                    var card = dijit.registry.byId(p.fullname+"_card");
                    var prompt_dom = card.domNode.getElementsByClassName('name')[0];
                    var api_dom = card.domNode.getElementsByClassName('api')[0];
                    var disp = "";
                    
                    if (v) {
                        var prompt_find = p.prompt.search(r);
                        var prompt_str = p.prompt.replace(r, "<span class='highlight'>"+"$&"+"</span>");

                        var api_find = p.name.search(r);
                        var api_str = p.name.replace(r, "<span class='highlight'>"+"$&"+"</span>");

                        if (prompt_find == -1 && api_find == -1) {
                            var disp = "none";
                        }
                        
                    } else {
                        var api_str = p.name;
                        var prompt_str = p.prompt;
                    }

                    card.set("style",{"display": disp});
                    prompt_dom.innerHTML = prompt_str;
                    api_dom.innerHTML = api_str;

                }

                // domConstruct.place(params, root);

            }
            

            function initialize(data) {
                var tlc = data[myhash["CodeGeneration:SystemTargetFile"]];
                var tlc_w = dijit.registry.byId(tlc.fullname+"_value");
                tlc_w.set("value", tlc.value);

                
                for (var i = 0, n = data.length; i < n; i++) {
                    var p = data[i];
                    if (p.name == "SystemTargetFile") {
                        continue;
                    }
                    var card = createParamCard(p);
                    card.placeAt(params);
                }
            }

            function resizeCard(p) {
                var c = dijit.registry.byId(p.fullname+"_card");
                // var t = dijit.registry.byId(p.fullname+"_title");
                var t = c.domNode.getElementsByClassName('title')[0];
                var d = t.getElementsByClassName('dscr')[0];
                var api = c.domNode.getElementsByClassName('api')[0];
                
                p.expand = p.expand ? false : !p.expand;

                if (p.expand) {
                    fx.animateProperty({
                        node:c.domNode,
                        properties:{
                            "margin":{start:10,end:30},
                            "-webkit-border-radius":{start:3,end:10}
                        },
                        onAnimate:function(){c.domNode.scrollIntoViewIfNeeded();}
                    }).play();

                    fx.animateProperty({
                        node:t,
                        properties:{
                            "min-height":300,
                        },
                    }).play();
                    domClass.add(api, "expand");
                    
                } else {
                    fx.animateProperty({
                        node:c.domNode,
                        properties:{
                            "margin":{start:30,end:10},
                            "-webkit-border-radius":{start:10,end:3}
                        },
                        onAnimate:function(){c.domNode.scrollIntoViewIfNeeded();}
                    }).play();
                    fx.animateProperty({
                        node:t,
                        properties:{
                            "min-height":0,
                        },
                    }).play();
                    domClass.remove(api, "expand");
                }


            }
            
            function createParamCard(p) {
                var out = new dijit.layout.ContentPane({id:p.fullname+"_card"});
                var t = createParamTitle(p);
                var v = createParamValue(p);
                var a = createParamAdditionalInfo(p);
                // t.placeAt(out);
                domConstruct.place(t, out.domNode);
                v.placeAt(out);
                domConstruct.place(a,out.domNode);
                domClass.add(out.domNode, "card");
                
                on(t,"dblclick", function(evt){
                    resizeCard(p);
                        
                }); 
                if (p.status > 0){
                    domClass.add(out.domNode, ("card-disabled"));
                }
                return out;
            }

            function createParamTitle(p) {
                // var out = new dijit.layout.ContentPane({id:p.fullname+"_title"});
                var out = domConstruct.create("div", {id:p.fullname+"_title", class:"title"});
                // domClass.add(out.domNode, "title");
                // var tri = domConstruct.create("a", {"href":"", "innerHTML":"<span><span>"});
                var name = domConstruct.create("div", {"class":"name", "innerHTML":p.prompt});
                var dscr = domConstruct.create("div", {"class":"dscr", "innerHTML":p.tooltip});

                var br = domConstruct.create("br");
                // domConstruct.place(tri, out.domNode);
                domConstruct.place(name, out);
                // domConstruct.place(br, out.domNode);
                domConstruct.place(dscr, out);
                return out;
                
            }

            function createParamValue(p) {
                var out = createPane(p);
                domClass.add(out.domNode, "value");
                return out;
            }

            function createParamAdditionalInfo(p) {
                // var out = new dijit.layout.ContentPane({id:p.fullname+"_additional"});
                // domClass.add(out.domNode, "additional");
                var api = domConstruct.create("div", {"class":"api additional", "innerHTML":p.name});
                // domConstruct.place(api, out.domNode);
                return api;

            }

            function updateParamCard(p) {
                var card = dijit.registry.byId(p.fullname+"_card");
                if (p.status > 0){
                    domClass.add(card.domNode, ("card-disabled"));
                } else {
                    domClass.remove(card.domNode, ("card-disabled"));
                }

                var pane = dijit.registry.byId(p.fullname);
                updatePane(pane, p);
            }

            function sendMsg(msg) {
                myfacade.publish(mypath+"/callback", msg);
            }

            
            // var MyGrid = dojo.declare([Grid,DijitRegistry,Hider,ColumnResizer]);
            
            myhash = genHash(mydata);
            mypath = location.search.substring(1);
            myfacade = new MatlabFacade();
            establishConnection(mypath);

            // mygrid.startup();
            

            // mygrid.renderArray(mydata);


            // functions ...

            function genHash(data) {
                var hash = {};
                for (var i = 0, l = data.length; i < l; i++) {
                    var p = data[i];
                    hash[p.fullname] = i;
                }
                return hash;
            }


            function callback(object, data) {
                object.value = data.value;
                myfacade.publish(mypath+"/callback", data);
            }

            function establishConnection(path) {
                mypath = path;
                
                var init = myfacade.subscribe(mypath+"/init", function (message) {
                    mydata = JSON.parse(message.data);
                    myhash = genHash(mydata);
                    initialize(mydata);
                    domConstruct.place(params, that.domNode);

                    var update = myfacade.subscribe(mypath+"/update", function (message) {
                        var p = JSON.parse(message.data);
                        if (myhash.hasOwnProperty(p.fullname)) {
                            var i = myhash[p.fullname];
                            if (JSON.stringify(mydata[i]) == JSON.stringify(p)) {
                                return;  // prevent self-circle
                            }
                            mydata[i] = p;
                        } else {
                            var n = mydata.length;
                            myhash[p.fullname] = n;
                            mydata[n] = p;
                        }
                        updateParamCard(p);
                    });

                    var refresh = myfacade.subscribe(mypath+"/refresh", function (message) {
                        mydata = JSON.parse(message.data);
                        myhash = genHash(mydata);
                        var x = mygrid.bodyNode.scrollLef;
                        var y = mygrid.bodyNode.scrollTop;
                        mygrid.refresh();
                        mygrid.renderArray(mydata);
                        mygrid.scrollTo({x:x, y:y})
                    });

                    var destroy = myfacade.subscribe(mypath+"/destroy", function (message) {
                        mygrid.refresh();
                    });
                    
                });

                myfacade.publish(mypath, "ready");


            }

            function scroll(n) {
                var y1 = mygrid.row(n-1).element.getBoundingClientRect().top;
                var y2 = mygrid.row(0).element.getBoundingClientRect().top;
                mygrid.scrollTo({y:y1-y2});

            }


            function actionRenderName(object, data, cell) {
                var name = '<div class="name">' + object.prompt + '</div>';
                var dscr = '<div class="dscr">' + object.tooltip; + '</div>';
                cell.innerHTML = '<div class="param" id="'+object.name+'_param">' + name  +'<br>'+ dscr + '&nbsp; '+ '</div>';
            }

            function actionRenderValue(object, data, cell) {
                var pane = dijit.registry.byId(object.fullname);
                if (pane) {
                    updatePane(pane, object);
                } else {
                    pane = createPane(object);
                }
                pane.placeAt(cell);
            }

            function createPane(object) {
                var pane =  new dijit.layout.ContentPane({id:object.fullname});
                var w = createWidget(object);
                w.placeAt(pane);
                return pane;
            }

            function updatePane(pane, object) {
                var w;
                switch (object.type) {
                case "enum":
                case "int" :
                case "boolean":
                case "string":
                case "minmax":
                    var id = object.fullname + "_value";
                    w = dijit.registry.byId(id);
                    if (w) {
                        updateWidget(w, object);
                    } else {
                        w = createWidget(object);
                        w.placeAt(pane);
                    }
                    break;
                default:
                    pane.destroyDescendants();
                    w = createWidget(object);
                    w.placeAt(pane);
                }
            }
            
            function createWidget (object) {
                var id = object.fullname + "_value";
                var w = dijit.registry.byId(id);
                if (w) {
                    return w;
                }

                // console.log(object.name);
                switch (object.type) {
                case "enum":
                    w = new dijit.form.Select({id:id, value:object.value, options:JSON.parse(JSON.stringify(object.options)),style:{"width":'100px'}});
                    on(w, "change", function () {callback(object, {name:object.name, value:w.value});});
                    break;
                case "int":
                    w = new dijit.form.NumberTextBox({id:id, value:object.value,invalidMessage:"Only accepts numbers"});
                    on(w, "change", function () {callback(object, {name:object.name, value:w.value});});
                    break;
                case "boolean":
                    w = new dijit.form.CheckBox({id:id, checked:object.value});
                    on(w, "change", function () {callback(object, {name:object.name, value:w.checked});});
                    break;
                case "string":
                    if (object.value instanceof Array) {
                        object.value = "";
                    }
                    
                    w = new dijit.form.TextBox({id:id, value:object.value, placeHolder:"<empty>"});
                    on(w, "change", function () {callback(object, {name:object.name, value:w.value});});
                    break;
                case "minmax":
                    w = new dijit.form.NumberSpinner({intermediateChanges:false,id:id, value:object.value, constraints:{min:object.min, max:object.max}});
                    on(w, "change", function () {callback(object, {name:object.name, value:w.value});});
                    break;
                default:
                    w = getAutoWidget(object.value, object.status, object, "value", object);
                    break;
                }
                w.set("disabled", object.status > 0, false);
                return w;
            }

            function getAutoWidget(value, status, ref, id, param){
                var t;
                var w;
                if (value instanceof Array) {
                    t = new dijit.TitlePane({open:true,title:"Array ["+value.length+"]"});
                    w = new dojox.layout.TableContainer({"labelWidth":"1%",customClass:"myclass"});
                    for (var i = 0; i < value.length; i++) {
                        var c = getAutoWidget(value[i], status, value, i, param);
                        c.set('label', '#'+(i+1)+":", false);
                        w.addChild(c);
                    }
                    w.placeAt(t);
                    w.startup();
                    w.set("disabled", status > 0);
                }else if(value instanceof Object) {
                    t = new dijit.TitlePane({open:true,title:"Object"});
                    w = new dojox.layout.TableContainer({"labelWidth":"1%",customClass:"myclass"});
                    for (var k in value) {
                        var c =  getAutoWidget(value[k], status, value, k, param);
                        c.set('label', k+":", false);
                        w.addChild(c);
                    }
                    w.placeAt(t);
                    w.startup();
                    w.set("disabled", status > 0);
                }else if(value.constructor === Number) {
                    t = new dijit.form.NumberTextBox({value:value,invalidMessage:"Only accepts numbers"});

                    on(t, "change", function () {
                        ref[id] = t.value;
                        sendMsg({name:param.name, value:param.value});
                    });
                }else if(value.constructor === String) {
                    t = new dijit.form.TextBox({value:value});

                    on(t, "change", function () {
                        ref[id] = t.value;
                        sendMsg({name:param.name, value:param.value});
                    });
                }else if(value.constructor === Boolean) {
                    t = new dijit.form.CheckBox({checked:value});
                    
                    on(t, "change", function () {
                        ref[id] = t.checked;
                        sendMsg({name:param.name, value:param.value});
                    });
                }

                t.set("disabled", status > 0);
                return t;
            }

            function updateWidget (w, object) {
                if (object.fullname == "Solver:Solver") {
                    w.options = JSON.parse(JSON.stringify(object.options));
                    w.startup();
                }
                
                if (w instanceof dijit.form.CheckBox) {
                    w.set("checked", object.value, false);
                } else {
                    w.set("value", object.value, false);
                }
                w.set("disabled", object.status > 0, false);
            }


            



            
		},
		
		
	});
});
