// Javascript functions to support operations in Dictionary-file comparison reports

// 
// Copyright 2012 The MathWorks, Inc.

// Getting the root window is browser dependent.  On some platforms the
// parent of root is the window, and window.window is window.
// On other browsers, parent can be undefined.
function getRootWindow() {
  if (parent) {return parent.window;} else {return window;}
}

function openvar(side,varname,entrykey) {
  var rootWindow=getRootWindow();
  if (side=="left") {
    rootWindow.location="matlab:datadict_varview('"+LEFT_FILE+"','"+varname+"','"+entrykey+"')";
  } else {
    rootWindow.location="matlab:datadict_varview('"+RIGHT_FILE+"','"+varname+"','"+entrykey+"')";
  }
}

function comparevar(leftvarname,rightvarname,leftentrykey,rightentrykey) {
  var rootWindow=getRootWindow();
  rootWindow.location="matlab:datadict_varcompare('"+LEFT_FILE+"','"+RIGHT_FILE+"','"+leftvarname+"','"+rightvarname+"','"+leftentrykey+"','"+rightentrykey+"')";
}


function mergeleft(leftvarname,rightvarname,leftentrykey,rightentrykey) {
  var rootWindow=getRootWindow();
  rootWindow.location="matlab:datadict_varmerge('"+RIGHT_FILE+"','"+LEFT_FILE+"','"+rightvarname+"','"+leftvarname+"','"+rightentrykey+"','"+leftentrykey+"','"+REPORT_ID+"')";
}

function mergeright(leftvarname,rightvarname,leftentrykey,rightentrykey) {
  var rootWindow=getRootWindow();
  rootWindow.location="matlab:datadict_varmerge('"+LEFT_FILE+"','"+RIGHT_FILE+"','"+leftvarname+"','"+rightvarname+"','"+leftentrykey+"','"+rightentrykey+"','"+REPORT_ID+"')";
}

function deleteleft(varname,entrykey) {
  var rootWindow=getRootWindow();
  rootWindow.location="matlab:datadict_vardelete('"+LEFT_FILE+"','"+varname+"','"+entrykey+"','"+REPORT_ID+"')";
}

function deleteright(varname,entrykey) {
  var rootWindow=getRootWindow();
  rootWindow.location="matlab:datadict_vardelete('"+RIGHT_FILE+"','"+varname+"','"+entrykey+"','"+REPORT_ID+"')";
}

function deleterefright(refname,refkey) {
  var rootWindow=getRootWindow();
  rootWindow.location="matlab:datadict_refdelete('"+RIGHT_FILE+"','"+refname+"','"+refkey+"','"+REPORT_ID+"')";
}

function insertrefright(refname,refkey) {
  var rootWindow=getRootWindow();
  rootWindow.location="matlab:datadict_refinsert('"+RIGHT_FILE+"','"+LEFT_FILE+"','"+refname+"','"+refkey+"','"+REPORT_ID+"')";
}

function deleterefleft(refname,refkey) {
  var rootWindow=getRootWindow();
  rootWindow.location="matlab:datadict_refdelete('"+LEFT_FILE+"','"+refname+"','"+refkey+"','"+REPORT_ID+"')";
}

function insertrefleft(refname,refkey) {
  var rootWindow=getRootWindow();
  rootWindow.location="matlab:datadict_refinsert('"+LEFT_FILE+"','"+RIGHT_FILE+"','"+refname+"','"+refkey+"','"+REPORT_ID+"')";
}
