/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webproxy;

import com.mathworks.webproxy.SystemProxySettings;
import java.io.File;
import java.net.URL;

final class NativeProxySettings
implements SystemProxySettings {
    private String manualProxyServerList;
    private String autoDetectURL;
    private String autoConfigURL;

    NativeProxySettings() {
        try {
            System.loadLibrary("nativewebproxy");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.getProxySettings();
    }

    NativeProxySettings(String string) {
        try {
            String string2 = System.mapLibraryName("nativewebproxy");
            System.load(new File(string, string2).getAbsolutePath());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.getProxySettings();
    }

    @Override
    public String getManualProxyServerList() {
        return this.manualProxyServerList;
    }

    @Override
    public boolean isAutoDetectEnabled() {
        return !this.autoDetectURL.isEmpty();
    }

    @Override
    public String getAutoDetectProxyServers(URL uRL) {
        return NativeProxySettings.findProxyForURL(uRL, this.autoDetectURL);
    }

    @Override
    public boolean isAutoConfigEnabled() {
        return !this.autoConfigURL.isEmpty();
    }

    @Override
    public String getAutoConfigProxyServers(URL uRL) {
        return NativeProxySettings.findProxyForURL(uRL, this.autoConfigURL);
    }

    private void getProxySettings() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        try {
            NativeProxySettings.getProxySettings(stringBuffer, stringBuffer2, stringBuffer3);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.manualProxyServerList = stringBuffer3.toString();
        this.autoDetectURL = stringBuffer.toString();
        this.autoConfigURL = stringBuffer2.toString();
    }

    private static String findProxyForURL(URL uRL, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            NativeProxySettings.findProxyForURL(uRL.toString(), string, stringBuffer);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    private static native void getProxySettings(StringBuffer var0, StringBuffer var1, StringBuffer var2);

    private static native void findProxyForURL(String var0, String var1, StringBuffer var2);
}

