/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webproxy;

import com.mathworks.net.transport.MWTransportClientPropertiesFactory;
import com.mathworks.webproxy.PropertiesProxyConfiguration;
import com.mathworks.webproxy.ProxyAuthenticationUI;
import com.mathworks.webproxy.ProxyAuthenticator;
import com.mathworks.webproxy.ProxyConfiguration;
import com.mathworks.webproxy.ProxyConfigurationVisitor;
import com.mathworks.webproxy.SystemProxyConfiguration;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashSet;

final class ProxyAuthenticatorImpl
implements ProxyAuthenticator {
    private PasswordAuthentication passwordAuthentication = null;
    private Collection<URL> requestingURLs = new LinkedHashSet<URL>();

    ProxyAuthenticatorImpl() {
    }

    @Override
    public synchronized void setAsDefault(ProxyConfiguration proxyConfiguration, ProxyAuthenticationUI proxyAuthenticationUI) {
        MWTransportClientPropertiesFactory.disableSetAsDefaultAuthenticator();
        AuthenticationProxyConfigurationVisitor authenticationProxyConfigurationVisitor = new AuthenticationProxyConfigurationVisitor(proxyConfiguration, proxyAuthenticationUI);
        Authenticator.setDefault(authenticationProxyConfigurationVisitor);
    }

    private boolean passwordAuthenticationRequiredForURL(URL uRL) {
        return this.isFirstPasswordAuthenticationRequest() || this.passwordAuthenticationFailedOrCancelledForURL(uRL);
    }

    private boolean isFirstPasswordAuthenticationRequest() {
        return this.requestingURLs.isEmpty();
    }

    private boolean passwordAuthenticationFailedOrCancelledForURL(URL uRL) {
        return this.requestingURLs.contains(uRL);
    }

    private void clearPasswordAuthenticationRequests() {
        this.requestingURLs.clear();
    }

    private void passwordAuthenticationRequestedForURL(URL uRL) {
        this.requestingURLs.add(uRL);
    }

    private class AuthenticationProxyConfigurationVisitor
    extends Authenticator
    implements ProxyConfigurationVisitor {
        private final ProxyConfiguration proxyConfiguration;
        private final ProxyAuthenticationUI proxyAuthenticationUI;

        AuthenticationProxyConfigurationVisitor(ProxyConfiguration proxyConfiguration, ProxyAuthenticationUI proxyAuthenticationUI) {
            this.proxyConfiguration = proxyConfiguration;
            this.proxyAuthenticationUI = proxyAuthenticationUI;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            this.proxyConfiguration.accept(this);
            return ProxyAuthenticatorImpl.this.passwordAuthentication;
        }

        @Override
        public void visit(PropertiesProxyConfiguration propertiesProxyConfiguration) {
            ProxyAuthenticatorImpl.this.passwordAuthentication = propertiesProxyConfiguration.getPasswordAuthentication();
        }

        @Override
        public void visit(SystemProxyConfiguration systemProxyConfiguration) {
            if (ProxyAuthenticatorImpl.this.passwordAuthenticationRequiredForURL(this.getRequestingURL())) {
                ProxyAuthenticatorImpl.this.clearPasswordAuthenticationRequests();
                this.promptForPasswordAuthentication(this.getRequestingHost(), this.getRequestingPort());
            }
            ProxyAuthenticatorImpl.this.passwordAuthenticationRequestedForURL(this.getRequestingURL());
        }

        private void promptForPasswordAuthentication(String string, int n) {
            ProxyAuthenticatorImpl.this.passwordAuthentication = this.proxyAuthenticationUI.promptForPasswordAuthentication(string, String.valueOf(n), ProxyAuthenticatorImpl.this.passwordAuthentication);
        }
    }
}

