/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class ComponentUtils {
    private ComponentUtils() {
    }

    public static boolean isChild(Component component, Component component2) {
        return component2 != null && component != null && (component2.equals(component) || ComponentUtils.isChild(component.getParent(), component2));
    }

    public static void setComponentEnabled(Container container, boolean bl) {
        container.setEnabled(bl);
        for (Component component : container.getComponents()) {
            if (component instanceof JComponent) {
                ComponentUtils.setComponentEnabled((Container)component, bl);
                continue;
            }
            component.setEnabled(bl);
        }
    }

    public static Color getActualBackgroundColor(Component component) {
        while (component != null) {
            if (component.isOpaque() && component.isBackgroundSet()) {
                return component.getBackground();
            }
            component = component.getParent();
        }
        return UIManager.getColor("Panel.background");
    }

    public static boolean hasAnyHeavyweights(Component component) {
        if (!(component instanceof Window) && !component.isLightweight()) {
            return true;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                if (!ComponentUtils.hasAnyHeavyweights(container.getComponent(i))) continue;
                return true;
            }
        }
        return false;
    }
}

