/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.google.common.base.Preconditions;
import com.mathworks.mwswing.ResizableIcon;
import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;

public class IconSet
implements ResizableIcon {
    private final List<Icon> fIcons;
    private int fWidth;
    private int fHeight;
    private Icon fIcon;

    public IconSet(Collection<Icon> collection) {
        this.fIcons = new ArrayList<Icon>(collection);
        Collections.sort(this.fIcons, new IconSizeComparator());
        Preconditions.checkArgument((!this.fIcons.isEmpty() ? 1 : 0) != 0, (Object)"No icons were specified");
    }

    public IconSet(Icon ... iconArray) {
        this.fIcons = new ArrayList<Icon>(Arrays.asList(iconArray));
        Collections.sort(this.fIcons, new IconSizeComparator());
        Preconditions.checkArgument((!this.fIcons.isEmpty() ? 1 : 0) != 0, (Object)"No icons were specified");
    }

    private void init() {
        if (this.fIcon == null) {
            this.setToPreferredSize();
        }
    }

    @Override
    public void setDimension(int n, int n2) {
        this.fWidth = n;
        this.fHeight = n2;
        Iterator<Icon> iterator = this.fIcons.iterator();
        while (iterator.hasNext()) {
            Icon icon;
            this.fIcon = icon = iterator.next();
            if (icon.getIconWidth() > n || icon.getIconHeight() > n2) continue;
            break;
        }
    }

    @Override
    public void setToPreferredSize() {
        this.fIcon = this.fIcons.get(0);
        this.fWidth = this.fIcon.getIconWidth();
        this.fHeight = this.fIcon.getIconHeight();
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        this.init();
        this.fIcon.paintIcon(component, graphics, n + (this.fWidth - this.fIcon.getIconWidth()) / 2, n2 + (this.fHeight - this.fIcon.getIconHeight()) / 2);
    }

    @Override
    public int getIconWidth() {
        this.init();
        return this.fWidth;
    }

    @Override
    public int getIconHeight() {
        this.init();
        return this.fHeight;
    }

    public Icon getSmallestIcon() {
        return this.fIcons.isEmpty() ? null : this.fIcons.get(this.fIcons.size() - 1);
    }

    @Override
    public int getSmallestIconWidth() {
        int n = Integer.MAX_VALUE;
        for (Icon icon : this.fIcons) {
            if (icon.getIconWidth() >= n) continue;
            n = icon.getIconWidth();
        }
        return n;
    }

    @Override
    public int getSmallestIconHeight() {
        int n = Integer.MAX_VALUE;
        for (Icon icon : this.fIcons) {
            if (icon.getIconHeight() >= n) continue;
            n = icon.getIconHeight();
        }
        return n;
    }

    public Icon getLargestIcon() {
        return this.fIcons.isEmpty() ? null : this.fIcons.get(0);
    }

    @Override
    public int getLargestIconWidth() {
        int n = Integer.MIN_VALUE;
        for (Icon icon : this.fIcons) {
            if (icon.getIconWidth() <= n) continue;
            n = icon.getIconWidth();
        }
        return n;
    }

    @Override
    public int getLargestIconHeight() {
        int n = Integer.MIN_VALUE;
        for (Icon icon : this.fIcons) {
            if (icon.getIconHeight() <= n) continue;
            n = icon.getIconHeight();
        }
        return n;
    }

    private static class IconSizeComparator
    implements Comparator<Icon> {
        private IconSizeComparator() {
        }

        @Override
        public int compare(Icon icon, Icon icon2) {
            return icon2.getIconHeight() - icon.getIconHeight();
        }
    }
}

