/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.FileExtensionFilter;
import com.mathworks.mwswing.FilePatternFilter;
import com.mathworks.mwswing.MJFileChooser;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.NativeDialogLauncher;
import com.mathworks.util.ArrayUtils;
import com.mathworks.util.FactoryUtils;
import com.mathworks.util.FileUtils;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import foxtrot.Task;
import foxtrot.Worker;
import foxtrot.WorkerThread;
import foxtrot.workers.MultiWorkerThread;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.DualHashBidiMap;

public class MJFileChooserPerPlatform
implements NativeDialogLauncher {
    private static final FilePatternFilter ACCEPT_ALL_FILE_FILTER = new FileExtensionFilter(MJUtilities.intlString("filechooser.platform.all"), "*", true);
    private File fCurrentDirectory;
    private String[] fSelectedFiles;
    private final List<FilePatternFilter> fFileFilters;
    private String fTitle;
    private int fType;
    private int fState;
    private boolean fMultiSelectionEnabled;
    private boolean fFileMustExist;
    private final BidiMap fFileFilterHash;
    private volatile boolean fValidState;
    private int fFilterIndex;
    private boolean fAcceptAllFileFilterUsed;
    private MJFileChooser fFileChooser;
    private static final boolean DEFAULT_USE_SWING_DIALOG;
    private static boolean sUseSwingDialog;
    private static final OpenDialogDelegate DEFAULT_OPEN_DIALOG_DELEGATE;
    private static OpenDialogDelegate sOpenDialogDelegate;
    private static final SaveDialogDelegate DEFAULT_SAVE_DIALOG_DELEGATE;
    private static SaveDialogDelegate sSaveDialogDelegate;
    private final boolean fUseJava;
    private EventListenerList fListenerList = new EventListenerList();
    private ChangeListener fTemporaryListener;
    private boolean fAllowMacBundles = true;
    private boolean fAllowConcurrentInstances = false;
    private int fFileSelectionMode;

    public MJFileChooserPerPlatform() {
        this(new File(FactoryUtils.getDirectorySeed()));
    }

    public MJFileChooserPerPlatform(File file) {
        this(file, sUseSwingDialog);
    }

    public MJFileChooserPerPlatform(String string) {
        this(new File(string));
    }

    public MJFileChooserPerPlatform(File file, boolean bl) {
        if (file == null) {
            throw new IllegalArgumentException("'currentDirectory' cannot be null");
        }
        this.fUseJava = sUseSwingDialog;
        this.fValidState = false;
        this.fFileFilters = new Vector<FilePatternFilter>();
        this.fSelectedFiles = ArrayUtils.EmptyObjects.STRING;
        this.fCurrentDirectory = file;
        this.fFileFilterHash = new DualHashBidiMap();
        this.fFileSelectionMode = 0;
        if (this.fUseJava) {
            this.fFileChooser = this.createJavaFileChooser(file);
            this.fFileFilterHash.put((Object)MJFileChooserPerPlatform.getAcceptAllFileFilter(), (Object)this.fFileChooser.getAcceptAllFileFilter());
        } else {
            this.fFileChooser = null;
        }
        this.setAcceptAllFileFilterUsed(true);
    }

    public void setIncludeFilterExtension(boolean bl) {
        if (this.fUseJava) {
            this.fFileChooser.setIncludeFilterExtension(bl);
        }
    }

    public void setFileHidingEnabled(boolean bl) {
        if (null != this.fFileChooser && this.fUseJava) {
            this.fFileChooser.setFileHidingEnabled(bl);
        }
    }

    public boolean isFileHidingEnabled() {
        boolean bl = false;
        if (null != this.fFileChooser && this.fUseJava) {
            bl = this.fFileChooser.isFileHidingEnabled();
        }
        return bl;
    }

    private MJFileChooser createJavaFileChooser(File file) {
        MJFileChooser mJFileChooser = new MJFileChooser(file);
        mJFileChooser.setApproveListener(new MJFileChooser.ApproveListener(){

            @Override
            public boolean approveSelection() {
                if (MJFileChooserPerPlatform.this.fFileMustExist && MJFileChooserPerPlatform.this.fFileChooser.getDialogType() == 0) {
                    File[] fileArray = MJFileChooserPerPlatform.this.fFileChooser.getSelectedFiles();
                    if (fileArray != null && fileArray.length == 0 && MJFileChooserPerPlatform.this.fFileChooser.getSelectedFile() != null) {
                        fileArray = new File[]{MJFileChooserPerPlatform.this.fFileChooser.getSelectedFile()};
                    }
                    if (fileArray != null && fileArray.length > 0) {
                        for (File file : fileArray) {
                            if (FileUtils.fileExists((File)file)) continue;
                            Object[] objectArray = new Object[]{file.getAbsolutePath()};
                            String string = MessageFormat.format(MJUtilities.intlString("mjfilechooser.fileMustExist"), objectArray);
                            MJOptionPane.showMessageDialog(MJFileChooserPerPlatform.this.fFileChooser, string, MJFileChooserPerPlatform.this.fFileChooser.getDialogTitle(), 0);
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
                return true;
            }
        });
        return mJFileChooser;
    }

    public void setDialogTitle(String string) {
        if (this.fUseJava) {
            this.fFileChooser.setDialogTitle(string);
        } else {
            this.fTitle = string;
        }
    }

    public void setCurrentDirectory(File file) {
        if (file == null) {
            throw new IllegalArgumentException("'dir' cannot be null");
        }
        if (this.fUseJava) {
            this.fFileChooser.setCurrentDirectory(file);
        } else {
            this.fCurrentDirectory = file;
        }
    }

    public File getCurrentDirectory() {
        if (this.fUseJava) {
            return this.fFileChooser.getCurrentDirectory();
        }
        return this.fCurrentDirectory;
    }

    public void addChoosableFileFilter(FilePatternFilter filePatternFilter) {
        if (this.fUseJava) {
            this.addFileFilter(this.getPatternBasedFilter(filePatternFilter));
        } else if (this.fFileFilters.contains(ACCEPT_ALL_FILE_FILTER)) {
            this.fFileFilters.add(this.fFileFilters.size() - 1, filePatternFilter);
        } else {
            this.fFileFilters.add(filePatternFilter);
        }
    }

    public void addChoosableFileFilters(List<FileExtensionFilter> list) {
        for (FileExtensionFilter fileExtensionFilter : list) {
            this.addChoosableFileFilter(fileExtensionFilter);
        }
    }

    public boolean removeChoosableFileFilter(FilePatternFilter filePatternFilter) {
        if (this.fUseJava) {
            FileFilter fileFilter = this.getPatternBasedFilter(filePatternFilter);
            boolean bl = this.fFileChooser.removeChoosableFileFilter(fileFilter);
            this.releasePatternBasedFilter(filePatternFilter);
            return bl;
        }
        boolean bl = false;
        if (this.fFileFilters.contains(filePatternFilter)) {
            bl = true;
            this.fFileFilters.remove(filePatternFilter);
        }
        return bl;
    }

    public List<FilePatternFilter> getChoosableFileFilterList() {
        if (this.fUseJava) {
            FileFilter[] fileFilterArray = this.fFileChooser.getChoosableFileFilters();
            Vector<FilePatternFilter> vector = new Vector<FilePatternFilter>();
            for (FileFilter fileFilter : fileFilterArray) {
                vector.add((FilePatternFilter)this.fFileFilterHash.getKey((Object)fileFilter));
            }
            return vector;
        }
        return this.fFileFilters;
    }

    public FilePatternFilter getFileFilter() {
        FilePatternFilter filePatternFilter = null;
        if (this.fUseJava) {
            filePatternFilter = (FilePatternFilter)this.fFileFilterHash.getKey((Object)this.fFileChooser.getFileFilter());
        } else if (this.fFilterIndex < this.fFileFilters.size()) {
            filePatternFilter = this.fFileFilters.get(this.fFilterIndex);
        }
        return filePatternFilter;
    }

    public int getFileFilterIndex() {
        return this.fFilterIndex;
    }

    public void setFileFilterIndex(int n) {
        this.fFilterIndex = n;
        if (this.fUseJava) {
            this.fFileChooser.setFileFilter(this.fFileChooser.getChoosableFileFilters()[n]);
        }
    }

    public int getFileSelectionMode() {
        if (this.fUseJava) {
            return this.fFileChooser.getFileSelectionMode();
        }
        return this.fFileSelectionMode;
    }

    public void setFileSelectionMode(int n) throws IllegalArgumentException {
        if (this.fUseJava) {
            this.fFileChooser.setFileSelectionMode(n);
        } else {
            if (n < 0 || n > 2) {
                throw new IllegalArgumentException("Wrong value passed for file selection mode");
            }
            this.fFileSelectionMode = n;
        }
    }

    public boolean isAcceptAllFileFilterUsed() {
        return this.fAcceptAllFileFilterUsed;
    }

    public void setAcceptAllFileFilterUsed(boolean bl) {
        if (this.fAcceptAllFileFilterUsed != bl) {
            this.fAcceptAllFileFilterUsed = bl;
            if (this.fUseJava) {
                assert (this.fFileChooser != null);
                this.fFileChooser.removeChoosableFileFilter(this.fFileChooser.getAcceptAllFileFilter());
                if (bl) {
                    this.addFileFilter(this.fFileChooser.getAcceptAllFileFilter());
                }
            } else if (this.fAcceptAllFileFilterUsed) {
                this.removeChoosableFileFilter(ACCEPT_ALL_FILE_FILTER);
                this.addChoosableFileFilter(ACCEPT_ALL_FILE_FILTER);
            } else {
                this.removeChoosableFileFilter(ACCEPT_ALL_FILE_FILTER);
            }
        }
    }

    private void addFileFilter(FileFilter fileFilter) {
        FileFilter[] fileFilterArray = this.fFileChooser.getChoosableFileFilters();
        FileFilter fileFilter2 = fileFilter;
        for (int i = 0; i != fileFilterArray.length; ++i) {
            if (fileFilterArray[i].equals(this.fFileChooser.getAcceptAllFileFilter())) continue;
            fileFilter2 = fileFilterArray[i];
            break;
        }
        this.fFileChooser.addChoosableFileFilter(fileFilter);
        this.fFileChooser.setFileFilter(fileFilter2);
    }

    public static FilePatternFilter getAcceptAllFileFilter() {
        return ACCEPT_ALL_FILE_FILTER;
    }

    public void setSelectedFile(File file) {
        if (this.fUseJava) {
            this.fFileChooser.setSelectedFile(file);
        } else {
            this.setSelectedFiles(new File[]{file});
        }
    }

    public void setSelectedFiles(File[] fileArray) {
        if (this.fUseJava) {
            this.fFileChooser.setSelectedFiles(fileArray);
        } else {
            this.fSelectedFiles = MJFileChooserPerPlatform.getFilepathsFromFiles(fileArray);
        }
        if (fileArray.length > 0 && fileArray[0].getParentFile() != null && fileArray[0].getParentFile().exists()) {
            this.setCurrentDirectory(fileArray[0].getParentFile());
        }
    }

    public void showOpenDialog(Component component, ChangeListener changeListener) throws HeadlessException {
        if (this.fTitle == null) {
            this.fTitle = MJUtilities.intlString("filechooser.platform.open");
        }
        this.fTemporaryListener = changeListener;
        if (this.fUseJava) {
            SwingUtilities.invokeLater(new RunnableJavaOpen(component));
        } else {
            this.fType = 0;
            this.showNativeFileDialog(component);
        }
    }

    public void showOpenDialog(Component component) throws HeadlessException {
        MJFileChooserPerPlatform.getOpenDialogDelegate().showOpenDialog(this, component);
    }

    public static void restoreOpenDialogDelegate() {
        MJFileChooserPerPlatform.setOpenDialogDelegate(DEFAULT_OPEN_DIALOG_DELEGATE);
    }

    public static boolean isDefaultOpenDialogDelegateApplied() {
        return MJFileChooserPerPlatform.getOpenDialogDelegate() == DEFAULT_OPEN_DIALOG_DELEGATE;
    }

    private static OpenDialogDelegate getOpenDialogDelegate() {
        return sOpenDialogDelegate;
    }

    public static void setOpenDialogDelegate(OpenDialogDelegate openDialogDelegate) {
        sOpenDialogDelegate = openDialogDelegate;
    }

    public void showSaveDialog(Component component, ChangeListener changeListener) throws HeadlessException {
        if (this.fTitle == null) {
            this.fTitle = MJUtilities.intlString("filechooser.platform.save");
        }
        this.fTemporaryListener = changeListener;
        if (this.fUseJava) {
            SwingUtilities.invokeLater(new RunnableJavaSave(component));
        } else {
            this.fType = 1;
            this.showNativeFileDialog(component);
        }
    }

    public void showSaveDialog(Component component) throws HeadlessException {
        MJFileChooserPerPlatform.getSaveDialogDelegate().showSaveDialog(this, component);
    }

    public static void restoreSaveDialogDelegate() {
        MJFileChooserPerPlatform.setSaveDialogDelegate(DEFAULT_SAVE_DIALOG_DELEGATE);
    }

    public static boolean isDefaultSaveDialogDelegateApplied() {
        return MJFileChooserPerPlatform.getSaveDialogDelegate() == DEFAULT_SAVE_DIALOG_DELEGATE;
    }

    private static SaveDialogDelegate getSaveDialogDelegate() {
        return sSaveDialogDelegate;
    }

    public static void setSaveDialogDelegate(SaveDialogDelegate saveDialogDelegate) {
        sSaveDialogDelegate = saveDialogDelegate;
    }

    private static ChangeListener createSynchronousDialogSupportChangeListener(final Object object) {
        return new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Object object2 = object;
                synchronized (object2) {
                    object.notifyAll();
                }
            }
        };
    }

    private static void createAndStartSynchronousFoxTrotTask(final Object object, boolean bl) {
        Task task = new Task(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws Exception {
                Object object2 = object;
                synchronized (object2) {
                    object.wait();
                }
                return null;
            }
        };
        try {
            if (bl && !(Worker.getWorkerThread() instanceof MultiWorkerThread)) {
                Worker.setWorkerThread((WorkerThread)new MultiWorkerThread());
            }
            Worker.post((Task)task);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void allowConcurrentInstances() {
        this.fAllowConcurrentInstances = true;
    }

    public int getState() {
        if (!this.fValidState) {
            throw new IllegalStateException("State cannot be queried before a show*Dialog has been called and completed.");
        }
        return this.fState;
    }

    @Override
    public String getDialogTitle() {
        if (this.fUseJava) {
            return this.fFileChooser.getDialogTitle();
        }
        return this.fTitle;
    }

    public void setState(int n) {
        if (n != 1 && n != 0) {
            throw new IllegalArgumentException("State must be either JFileChooser.CANCEL_OPTION or JFileChooser.APPROVE_OPTION");
        }
        this.fState = n;
    }

    public void setMultiSelectionEnabled(boolean bl) {
        if (this.fUseJava) {
            this.fFileChooser.setMultiSelectionEnabled(bl);
        } else {
            this.fMultiSelectionEnabled = bl;
        }
    }

    public boolean isMultiSelectionEnabled() {
        if (this.fUseJava) {
            return this.fFileChooser.isMultiSelectionEnabled();
        }
        return this.fMultiSelectionEnabled;
    }

    public void setFileMustExist(boolean bl) {
        this.fFileMustExist = bl;
    }

    public boolean isFileMustExist() {
        return this.fFileMustExist;
    }

    private void handleJavaDialogClosed() {
        if (this.fState == -1) {
            this.fState = 1;
        }
        this.fCurrentDirectory = this.fFileChooser.getCurrentDirectory();
        if (this.fState == 0) {
            if (this.fFileChooser.isMultiSelectionEnabled()) {
                this.fSelectedFiles = MJFileChooserPerPlatform.getFilepathsFromFiles(this.fFileChooser.getSelectedFiles());
            } else {
                this.fSelectedFiles = new String[1];
                this.fSelectedFiles[0] = this.fFileChooser.getSelectedFile().getAbsolutePath();
            }
            this.fFilterIndex = Arrays.asList(this.fFileChooser.getChoosableFileFilters()).indexOf(this.fFileChooser.getFileFilter());
        }
        this.dialogClosed();
    }

    private static String[] getFilepathsFromFiles(File[] fileArray) {
        String[] stringArray = new String[fileArray.length];
        for (int i = 0; i != fileArray.length; ++i) {
            stringArray[i] = fileArray[i].getAbsolutePath();
        }
        return stringArray;
    }

    private static File[] getFilesFromFilepaths(String[] stringArray) {
        File[] fileArray = new File[stringArray.length];
        for (int i = 0; i != stringArray.length; ++i) {
            fileArray[i] = new File(stringArray[i]);
        }
        return fileArray;
    }

    private static String[] getFilenames(File[] fileArray) {
        String[] stringArray = new String[fileArray.length];
        for (int i = 0; i != fileArray.length; ++i) {
            stringArray[i] = fileArray[i].getName();
        }
        return stringArray;
    }

    private void handleNativeReturnValues(List<String> list) {
        int n = 1;
        if (list != null && list.size() > 1) {
            String string = list.remove(list.size() - 1);
            this.fFilterIndex = Integer.parseInt(string);
            if (list.size() > 0 && this.verifyNoBundlesOnMac(list)) {
                if (list.size() == 1) {
                    this.fCurrentDirectory = new File(list.get(0)).getParentFile();
                }
                this.fSelectedFiles = list.toArray(new String[list.size()]);
                n = 0;
            }
        }
        this.fState = n;
    }

    private boolean verifyNoBundlesOnMac(List<String> list) {
        boolean bl = true;
        if (PlatformInfo.isMacintosh() && !this.isAllowMacBundles()) {
            for (int i = 0; i < list.size(); ++i) {
                if (!NativeJava.isPackage((String)list.get(i))) continue;
                String string = MessageFormat.format(MJUtilities.intlString("filechooser.openedAppFile"), new File(list.get(i)).getName());
                MJOptionPane.showMessageDialog(null, string, "", 2);
                bl = false;
                break;
            }
        }
        return bl;
    }

    public File getSelectedFile() {
        if (this.fUseJava) {
            return this.fFileChooser.getSelectedFile();
        }
        if (this.fSelectedFiles.length == 0) {
            return null;
        }
        return new File(this.fSelectedFiles[0]);
    }

    public File[] getSelectedFiles() {
        if (this.fUseJava) {
            return this.fFileChooser.getSelectedFiles();
        }
        if (this.fSelectedFiles.length == 0) {
            return null;
        }
        File[] fileArray = new File[this.fSelectedFiles.length];
        for (int i = 0; i != fileArray.length; ++i) {
            fileArray[i] = new File(this.fSelectedFiles[i]);
        }
        return fileArray;
    }

    public void setAllowMacBundles(boolean bl) {
        this.fAllowMacBundles = bl;
    }

    public boolean isAllowMacBundles() {
        return this.fAllowMacBundles;
    }

    public static void setUseSwingDialog(boolean bl) {
        sUseSwingDialog = bl;
    }

    public static void restoreUseDefaultSwingDialogSetting() {
        MJFileChooserPerPlatform.setUseSwingDialog(DEFAULT_USE_SWING_DIALOG);
    }

    private void showJavaFileDialog(Component component) {
        this.fFileChooser = this.createJavaFileChooser(this.fCurrentDirectory);
        this.fFileChooser.setCurrentDirectory(this.fCurrentDirectory);
        File[] fileArray = MJFileChooserPerPlatform.getFilesFromFilepaths(this.fSelectedFiles);
        this.fFileChooser.setSelectedFiles(fileArray);
        for (FilePatternFilter filePatternFilter : this.fFileFilters) {
            this.addFileFilter(this.getPatternBasedFilter(filePatternFilter));
        }
        this.fFileChooser.removeChoosableFileFilter(this.fFileChooser.getAcceptAllFileFilter());
        this.fFileChooser.setDialogTitle(this.fTitle);
        this.fFileChooser.setMultiSelectionEnabled(this.fMultiSelectionEnabled);
        this.fFileChooser.setFileSelectionMode(this.fFileSelectionMode);
        if (this.fType == 0) {
            SwingUtilities.invokeLater(new RunnableJavaOpen(component));
        } else {
            SwingUtilities.invokeLater(new RunnableJavaSave(component));
        }
    }

    private void showNativeFileDialog(Component component) {
        String string = System.getProperty("os.version");
        if (PlatformInfo.isWindows() && (double)Float.valueOf(string).floatValue() < 6.0 && this.fFileSelectionMode == 2) {
            this.fFileMustExist = false;
            this.showJavaFileDialog(component);
        } else {
            Thread thread = new Thread(new RunnableNativeDispatch(component, this.fType == 0, this.fCurrentDirectory.getAbsolutePath(), this.fSelectedFiles, this.createNativeFilterString(), this.fTitle, this.fMultiSelectionEnabled, this.fFileMustExist, this.fFileSelectionMode));
            thread.start();
        }
    }

    private String createNativeFilterString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (FilePatternFilter filePatternFilter : this.fFileFilters) {
            MJFileChooserPerPlatform.appendEntryForFilter(stringBuffer, filePatternFilter);
        }
        return stringBuffer.toString();
    }

    private static void appendEntryForFilter(StringBuffer stringBuffer, FilePatternFilter filePatternFilter) {
        stringBuffer.append(filePatternFilter.getDescription());
        String[] stringArray = filePatternFilter.getPatterns();
        stringBuffer.append("!");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(";");
        }
        stringBuffer.append("!");
    }

    private static AWTEventListener createWindowsSpuriousMouseEventListener() {
        return new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent aWTEvent) {
                if (aWTEvent.getID() == 506) {
                    ((InputEvent)aWTEvent).consume();
                }
            }
        };
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.fListenerList.remove(ChangeListener.class, changeListener);
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        this.fListenerList.add(ChangeListener.class, changeListener);
    }

    @Override
    public void dialogClosed() {
        this.fireChangeEvent();
    }

    private void fireChangeEvent() {
        ChangeListener[] changeListenerArray;
        this.fValidState = true;
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : changeListenerArray = (ChangeListener[])this.fListenerList.getListeners(ChangeListener.class)) {
            changeListener.stateChanged(changeEvent);
        }
        if (this.fTemporaryListener != null) {
            this.fTemporaryListener.stateChanged(changeEvent);
            this.fTemporaryListener = null;
        }
    }

    private FileFilter getPatternBasedFilter(FilePatternFilter filePatternFilter) {
        if (this.fFileFilterHash.containsKey((Object)filePatternFilter)) {
            return (FileFilter)this.fFileFilterHash.get((Object)filePatternFilter);
        }
        PatternBasedFilter patternBasedFilter = new PatternBasedFilter(filePatternFilter);
        this.fFileFilterHash.put((Object)filePatternFilter, (Object)patternBasedFilter);
        return patternBasedFilter;
    }

    private void releasePatternBasedFilter(FilePatternFilter filePatternFilter) {
        if (this.fFileFilterHash.containsKey((Object)filePatternFilter)) {
            this.fFileFilterHash.remove((Object)filePatternFilter);
        }
    }

    static {
        sUseSwingDialog = DEFAULT_USE_SWING_DIALOG = PlatformInfo.isXWindows();
        sOpenDialogDelegate = DEFAULT_OPEN_DIALOG_DELEGATE = new OpenDialogDelegateImpl();
        sSaveDialogDelegate = DEFAULT_SAVE_DIALOG_DELEGATE = new SaveDialogDelegateImpl();
    }

    static class PatternBasedFilter
    extends FileFilter {
        private final FilePatternFilter iOrigFilter;

        PatternBasedFilter(FilePatternFilter filePatternFilter) {
            this.iOrigFilter = filePatternFilter;
        }

        public FilePatternFilter getOriginalFilter() {
            return this.iOrigFilter;
        }

        @Override
        public String getDescription() {
            return this.iOrigFilter.getDescription();
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            boolean bl = false;
            for (String string : this.iOrigFilter.getPatterns()) {
                if (bl) continue;
                bl = FileUtils.matchesDirStylePattern((File)file, (String)string);
            }
            return bl;
        }
    }

    private class RunnableNativeDispatch
    implements Runnable {
        private final long iParent;
        private final boolean iOpen;
        private final String iPath;
        private final String iFileName;
        private final String iFilters;
        private final String iTitle;
        private final boolean iMultiSelect;
        private final boolean iFileMustExist;
        private final int iFileSelectionMode;

        RunnableNativeDispatch(Component component, boolean bl, String string, String[] stringArray, String string2, String string3, boolean bl2, boolean bl3, int n) {
            this.iParent = component != null && component.isDisplayable() ? NativeJava.getNativeWindowFromComponent((Component)component) : 0L;
            this.iOpen = bl;
            this.iPath = string;
            if (stringArray != null && stringArray.length > 0) {
                File file = new File(stringArray[0]);
                this.iFileName = file.getName();
            } else {
                this.iFileName = null;
            }
            this.iFilters = string2;
            this.iTitle = string3;
            this.iMultiSelect = bl2;
            this.iFileMustExist = bl3;
            this.iFileSelectionMode = n;
        }

        @Override
        public void run() {
            if (PlatformInfo.isWindows()) {
                this.runWindows();
            } else {
                this.runNative();
            }
        }

        public void runWindows() {
            AWTEventListener aWTEventListener = MJFileChooserPerPlatform.createWindowsSpuriousMouseEventListener();
            Toolkit.getDefaultToolkit().addAWTEventListener(aWTEventListener, 32L);
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            this.runNative();
            if (component != null) {
                component.requestFocusInWindow();
            }
            Toolkit.getDefaultToolkit().removeAWTEventListener(aWTEventListener);
        }

        public void runNative() {
            List list = (List)NativeJava.showNativeFileDialogMulti((long)this.iParent, (boolean)this.iOpen, (String)this.iPath, (String)this.iFileName, (String)this.iFilters, (String)this.iTitle, (boolean)this.iMultiSelect, (boolean)this.iFileMustExist, null, (int)this.iFileSelectionMode);
            MJFileChooserPerPlatform.this.handleNativeReturnValues(list);
            MJFileChooserPerPlatform.this.dialogClosed();
        }
    }

    private class RunnableJavaSave
    implements Runnable {
        private final Component iComponent;

        RunnableJavaSave(Component component) {
            this.iComponent = component;
        }

        @Override
        public void run() {
            MJFileChooserPerPlatform.this.fFileChooser.setShowOverwriteDialog(true);
            MJFileChooserPerPlatform.this.fState = MJFileChooserPerPlatform.this.fFileChooser.showSaveDialog(this.iComponent);
            MJFileChooserPerPlatform.this.handleJavaDialogClosed();
        }
    }

    private class RunnableJavaOpen
    implements Runnable {
        private final Component iComponent;

        RunnableJavaOpen(Component component) {
            this.iComponent = component;
        }

        @Override
        public void run() {
            MJFileChooserPerPlatform.this.fFileChooser.setShowOverwriteDialog(false);
            MJFileChooserPerPlatform.this.fState = MJFileChooserPerPlatform.this.fFileChooser.showOpenDialog(this.iComponent);
            MJFileChooserPerPlatform.this.handleJavaDialogClosed();
        }
    }

    private static class SaveDialogDelegateImpl
    implements SaveDialogDelegate {
        private SaveDialogDelegateImpl() {
        }

        @Override
        public void showSaveDialog(MJFileChooserPerPlatform mJFileChooserPerPlatform, Component component) {
            Object object = new Object();
            mJFileChooserPerPlatform.showSaveDialog(component, MJFileChooserPerPlatform.createSynchronousDialogSupportChangeListener(object));
            MJFileChooserPerPlatform.createAndStartSynchronousFoxTrotTask(object, mJFileChooserPerPlatform.fAllowConcurrentInstances);
        }
    }

    public static interface SaveDialogDelegate {
        public void showSaveDialog(MJFileChooserPerPlatform var1, Component var2);
    }

    private static class OpenDialogDelegateImpl
    implements OpenDialogDelegate {
        private OpenDialogDelegateImpl() {
        }

        @Override
        public void showOpenDialog(MJFileChooserPerPlatform mJFileChooserPerPlatform, Component component) {
            Object object = new Object();
            mJFileChooserPerPlatform.showOpenDialog(component, MJFileChooserPerPlatform.createSynchronousDialogSupportChangeListener(object));
            MJFileChooserPerPlatform.createAndStartSynchronousFoxTrotTask(object, mJFileChooserPerPlatform.fAllowConcurrentInstances);
        }
    }

    public static interface OpenDialogDelegate {
        public void showOpenDialog(MJFileChooserPerPlatform var1, Component var2);
    }
}

