/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.JTextComponent;

public class MJMultilineToggleButton
extends JPanel {
    private JTextComponent fLabel;
    private final JToggleButton fButton;
    private final MouseListener fMouseListener;
    private final KeyListener fKeyListener;

    protected MJMultilineToggleButton(String string, JToggleButton jToggleButton) {
        this(string, jToggleButton, true);
    }

    protected MJMultilineToggleButton(String string, JToggleButton jToggleButton, boolean bl) {
        if (jToggleButton == null) {
            throw new IllegalArgumentException("'button' cannot be null");
        }
        this.fLabel = this.createLabel(string, bl);
        this.fMouseListener = this.createMouseListener();
        this.fKeyListener = this.createKeyListener();
        this.fButton = jToggleButton;
        this.fButton.setText("");
        this.fButton.setOpaque(false);
        this.fButton.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                MJMultilineToggleButton.this.fLabel.repaint();
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                MJMultilineToggleButton.this.fLabel.repaint();
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.fButton, gridBagConstraints);
        this.layOutLabel();
    }

    private void layOutLabel() {
        this.updateListeners();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.fLabel, gridBagConstraints);
    }

    protected JToggleButton getButton() {
        return this.fButton;
    }

    @Override
    public void setEnabled(boolean bl) {
        if (bl != this.isEnabled()) {
            super.setEnabled(bl);
            this.fButton.setEnabled(bl);
            this.fLabel.setEnabled(bl);
            this.updateListeners();
        }
    }

    public JTextComponent getLabel() {
        return this.fLabel;
    }

    public void setLabel(JTextComponent jTextComponent) {
        this.fLabel = jTextComponent;
        this.layOutLabel();
    }

    private MouseListener createMouseListener() {
        return new BasicButtonListener(this.fButton){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                super.mousePressed(this.convertMouseEvent(mouseEvent));
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                super.mouseReleased(this.convertMouseEvent(mouseEvent));
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                super.mouseEntered(this.convertMouseEvent(mouseEvent));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                super.mouseExited(this.convertMouseEvent(mouseEvent));
            }

            private MouseEvent convertMouseEvent(MouseEvent mouseEvent) {
                int n = MJMultilineToggleButton.this.fButton.getWidth() / 2;
                int n2 = MJMultilineToggleButton.this.fButton.getHeight() / 2;
                return new MouseEvent(MJMultilineToggleButton.this.fButton, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), n, n2, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
            }
        };
    }

    private KeyListener createKeyListener() {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 32) {
                    MJMultilineToggleButton.this.toggle();
                }
            }
        };
    }

    protected JTextComponent createLabel(String string, boolean bl) {
        MJMultilineLabel mJMultilineLabel = new MJMultilineLabel(string, bl){

            @Override
            public void paintBorder(Graphics graphics) {
                if (MJMultilineToggleButton.this.fButton.hasFocus()) {
                    if (PlatformInfo.isXWindows()) {
                        graphics.setColor(UIManager.getColor("RadioButton.focus"));
                        graphics.drawRect(0, 1, this.getWidth() - 1, this.getHeight() - 2);
                    } else if (PlatformInfo.isWindows()) {
                        BasicGraphicsUtils.drawDashedRect(graphics, 0, 3, this.getWidth() - 1, this.getHeight() - 4);
                    }
                }
            }
        };
        mJMultilineLabel.setOpaque(false);
        Border border = PlatformInfo.isMacintosh() ? BorderFactory.createEmptyBorder(3, 2, 1, 1) : BorderFactory.createEmptyBorder(3, 0, 1, 1);
        mJMultilineLabel.setBorder(border);
        return mJMultilineLabel;
    }

    private void updateListeners() {
        if (this.isEnabled()) {
            this.fLabel.addMouseListener(this.fMouseListener);
            this.fLabel.addKeyListener(this.fKeyListener);
        } else {
            this.fLabel.removeMouseListener(this.fMouseListener);
            this.fLabel.removeKeyListener(this.fKeyListener);
        }
    }

    private void toggle() {
        this.fButton.setSelected(!this.fButton.isSelected());
        this.fButton.requestFocus();
    }
}

