/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Window;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JWindow;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class MJPopupMenu
extends JPopupMenu {
    private Component fGlass;
    private boolean fCleanupUponClose;

    public MJPopupMenu() {
        this.addPopupMenuListener(new CloseListener());
    }

    public MJPopupMenu(String string) {
        super(string);
        this.addPopupMenuListener(new CloseListener());
    }

    @Override
    public JMenuItem add(Action action) {
        MJMenuItem mJMenuItem = new MJMenuItem(action);
        MJPopupMenu.removeMnemonic(mJMenuItem);
        super.add(mJMenuItem);
        return mJMenuItem;
    }

    @Override
    public JMenuItem add(JMenuItem jMenuItem) {
        MJPopupMenu.removeMnemonic(jMenuItem);
        return super.add(jMenuItem);
    }

    static void removeMnemonic(MenuElement menuElement) {
        MenuElement[] menuElementArray;
        int n;
        if (menuElement instanceof JMenuItem && (n = ((JMenuItem)menuElement).getMnemonic()) != 0) {
            ((JMenuItem)menuElement).setMnemonic('\u0000');
            String string = ((JMenuItem)menuElement).getText();
            String string2 = MJUtilities.removeMnemonicText(string, n);
            if (string2 != string) {
                ((JMenuItem)menuElement).setText(string2);
            }
        }
        if ((menuElementArray = menuElement.getSubElements()) != null) {
            for (int i = 0; i < menuElementArray.length; ++i) {
                MJPopupMenu.removeMnemonic(menuElementArray[i]);
            }
        }
    }

    static boolean isInContextMenu(Container container) {
        if (container == null) {
            return false;
        }
        if (container instanceof MJPopupMenu) {
            return true;
        }
        return MJPopupMenu.isInContextMenu(container.getParent());
    }

    @Override
    public void insert(Action action, int n) {
        MJMenuItem mJMenuItem = new MJMenuItem(action);
        MJPopupMenu.removeMnemonic(mJMenuItem);
        super.insert(mJMenuItem, n);
    }

    @Override
    public void insert(Component component, int n) {
        if (component instanceof MenuElement) {
            MJPopupMenu.removeMnemonic((MenuElement)((Object)component));
        }
        super.insert(component, n);
    }

    public void dispose() {
        MJPopupMenu.dispose(this);
    }

    public static void dispose(JPopupMenu jPopupMenu) {
        int n = jPopupMenu.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = jPopupMenu.getComponent(i);
            if (component instanceof JMenu) {
                MJMenu.dispose((JMenu)component);
                continue;
            }
            if (!(component instanceof AbstractButton)) continue;
            MJUtilities.dispose((AbstractButton)component);
        }
    }

    public void setCleanupUponClose(boolean bl) {
        this.fCleanupUponClose = bl;
    }

    @Override
    public void show(Component component, int n, int n2) {
        Window window;
        Component component2 = SwingUtilities.getRoot(component);
        if (component2 instanceof JFrame) {
            window = (JFrame)component2;
            this.fGlass = ((JFrame)window).getGlassPane();
            if (this.fGlass.isVisible()) {
                this.fGlass.setVisible(false);
            } else {
                this.fGlass = null;
            }
        }
        if (PlatformInfo.isMacintosh() && (window = MJPopupMenu.getTopmostJWindowAncestor(component)) != null) {
            Container container = window.getParent();
            Point point = SwingUtilities.convertPoint(component, n, n2, container);
            component = container;
            n = point.x;
            n2 = point.y;
        }
        super.show(component, n, n2);
    }

    private static JWindow getTopmostJWindowAncestor(Component component) {
        JWindow jWindow = null;
        while (component != null) {
            if (component instanceof JWindow) {
                jWindow = (JWindow)component;
            }
            component = component.getParent();
        }
        return jWindow;
    }

    private class CloseListener
    implements PopupMenuListener {
        private CloseListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            if (MJPopupMenu.this.fGlass != null) {
                MJPopupMenu.this.fGlass.setVisible(true);
                MJPopupMenu.this.fGlass = null;
            }
            if (MJPopupMenu.this.fCleanupUponClose) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MJPopupMenu.this.dispose();
                    }
                });
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }
    }
}

