/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.apache.fop.afp.AFPDataObjectInfo;
import org.apache.fop.afp.AFPGraphics2D;
import org.apache.fop.afp.AFPGraphicsObjectInfo;
import org.apache.fop.afp.AFPImageObjectInfo;
import org.apache.fop.afp.AFPObjectAreaInfo;
import org.apache.fop.afp.AFPResourceInfo;
import org.apache.fop.afp.AFPResourceLevel;
import org.apache.fop.afp.Factory;
import org.apache.fop.afp.ioca.IDEStructureParameter;
import org.apache.fop.afp.ioca.ImageContent;
import org.apache.fop.afp.modca.AbstractDataObject;
import org.apache.fop.afp.modca.AbstractNamedAFPObject;
import org.apache.fop.afp.modca.Document;
import org.apache.fop.afp.modca.GraphicsObject;
import org.apache.fop.afp.modca.ImageObject;
import org.apache.fop.afp.modca.IncludeObject;
import org.apache.fop.afp.modca.ObjectContainer;
import org.apache.fop.afp.modca.Overlay;
import org.apache.fop.afp.modca.PageSegment;
import org.apache.fop.afp.modca.Registry;
import org.apache.fop.afp.modca.ResourceObject;
import org.apache.xmlgraphics.java2d.Graphics2DImagePainter;

public class AFPDataObjectFactory {
    private final Factory factory;

    public AFPDataObjectFactory(Factory factory) {
        this.factory = factory;
    }

    public ObjectContainer createObjectContainer(AFPDataObjectInfo aFPDataObjectInfo) {
        ObjectContainer objectContainer = this.factory.createObjectContainer();
        objectContainer.setViewport(aFPDataObjectInfo);
        Registry.ObjectType objectType = aFPDataObjectInfo.getObjectType();
        AFPResourceInfo aFPResourceInfo = aFPDataObjectInfo.getResourceInfo();
        AFPResourceLevel aFPResourceLevel = aFPResourceInfo.getLevel();
        boolean bl = aFPResourceLevel.isInline();
        objectContainer.setObjectClassification((byte)1, objectType, true, bl, true);
        objectContainer.setData(aFPDataObjectInfo.getData());
        return objectContainer;
    }

    public ImageObject createImage(AFPImageObjectInfo aFPImageObjectInfo) {
        IDEStructureParameter iDEStructureParameter;
        ImageObject imageObject = this.factory.createImageObject();
        imageObject.setViewport(aFPImageObjectInfo);
        if (aFPImageObjectInfo.hasCompression()) {
            int n = aFPImageObjectInfo.getCompression();
            switch (n) {
                case 2: {
                    imageObject.setEncoding((byte)-128);
                    break;
                }
                case 3: {
                    imageObject.setEncoding((byte)-127);
                    break;
                }
                case 4: {
                    imageObject.setEncoding((byte)-126);
                    break;
                }
                case -125: {
                    imageObject.setEncoding((byte)n);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid compression scheme: " + n);
                }
            }
        }
        ImageContent imageContent = imageObject.getImageSegment().getImageContent();
        int n = aFPImageObjectInfo.getBitsPerPixel();
        imageObject.setIDESize((byte)n);
        switch (n) {
            case 1: {
                break;
            }
            case 4: 
            case 8: {
                iDEStructureParameter = imageContent.needIDEStructureParameter();
                iDEStructureParameter.setBitsPerComponent(new int[]{n});
                iDEStructureParameter.setColorModel((byte)18);
                break;
            }
            case 24: {
                iDEStructureParameter = imageContent.needIDEStructureParameter();
                iDEStructureParameter.setDefaultRGBColorModel();
                break;
            }
            case 32: {
                iDEStructureParameter = imageContent.needIDEStructureParameter();
                iDEStructureParameter.setDefaultCMYKColorModel();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported number of bits per pixel: " + n);
            }
        }
        if (n > 1 && aFPImageObjectInfo.isSubtractive()) {
            iDEStructureParameter = imageContent.needIDEStructureParameter();
            iDEStructureParameter.setSubtractive(aFPImageObjectInfo.isSubtractive());
        }
        imageObject.setData(aFPImageObjectInfo.getData());
        return imageObject;
    }

    public GraphicsObject createGraphic(AFPGraphicsObjectInfo aFPGraphicsObjectInfo) {
        GraphicsObject graphicsObject = this.factory.createGraphicsObject();
        graphicsObject.setViewport(aFPGraphicsObjectInfo);
        AFPGraphics2D aFPGraphics2D = aFPGraphicsObjectInfo.getGraphics2D();
        aFPGraphics2D.setGraphicsObject(graphicsObject);
        graphicsObject.setColorConverter(aFPGraphics2D.getPaintingState().getColorConverter());
        Graphics2DImagePainter graphics2DImagePainter = aFPGraphicsObjectInfo.getPainter();
        Rectangle2D rectangle2D = aFPGraphicsObjectInfo.getArea();
        aFPGraphics2D.scale(1.0, -1.0);
        aFPGraphics2D.translate(0.0, -rectangle2D.getHeight());
        graphics2DImagePainter.paint((Graphics2D)((Object)aFPGraphics2D), rectangle2D);
        graphicsObject.setComplete(true);
        return graphicsObject;
    }

    public IncludeObject createInclude(String string, AFPDataObjectInfo aFPDataObjectInfo) {
        Object object;
        IncludeObject includeObject = this.factory.createInclude(string);
        if (aFPDataObjectInfo instanceof AFPImageObjectInfo) {
            includeObject.setObjectType((byte)-5);
        } else if (aFPDataObjectInfo instanceof AFPGraphicsObjectInfo) {
            includeObject.setObjectType((byte)-69);
        } else {
            includeObject.setObjectType((byte)-110);
            object = aFPDataObjectInfo.getObjectType();
            if (object != null) {
                includeObject.setObjectClassification((byte)16, (Registry.ObjectType)object, true, false, true);
            } else {
                throw new IllegalStateException("Failed to set Object Classification Triplet on Object Container.");
            }
        }
        object = aFPDataObjectInfo.getObjectAreaInfo();
        int n = ((AFPObjectAreaInfo)object).getX();
        int n2 = ((AFPObjectAreaInfo)object).getY();
        includeObject.setObjectAreaOffset(n, n2);
        int n3 = ((AFPObjectAreaInfo)object).getWidth();
        int n4 = ((AFPObjectAreaInfo)object).getHeight();
        includeObject.setObjectAreaSize(n3, n4);
        int n5 = ((AFPObjectAreaInfo)object).getRotation();
        includeObject.setObjectAreaOrientation(n5);
        int n6 = ((AFPObjectAreaInfo)object).getWidthRes();
        int n7 = ((AFPObjectAreaInfo)object).getHeightRes();
        includeObject.setMeasurementUnits(n6, n7);
        includeObject.setMappingOption((byte)32);
        return includeObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResourceObject createResource(AbstractNamedAFPObject abstractNamedAFPObject, AFPResourceInfo aFPResourceInfo, Registry.ObjectType objectType) {
        ResourceObject resourceObject = null;
        String string = aFPResourceInfo.getName();
        resourceObject = string != null ? this.factory.createResource(string) : this.factory.createResource();
        if (abstractNamedAFPObject instanceof Document) {
            resourceObject.setType((byte)-88);
        } else if (abstractNamedAFPObject instanceof PageSegment) {
            resourceObject.setType((byte)-5);
        } else if (abstractNamedAFPObject instanceof Overlay) {
            resourceObject.setType((byte)-4);
        } else {
            if (!(abstractNamedAFPObject instanceof AbstractDataObject)) throw new UnsupportedOperationException("Unsupported resource object type " + abstractNamedAFPObject);
            AbstractDataObject abstractDataObject = (AbstractDataObject)abstractNamedAFPObject;
            if (abstractNamedAFPObject instanceof ObjectContainer) {
                resourceObject.setType((byte)-110);
                resourceObject.setObjectClassification((byte)1, objectType, true, false, true);
            } else if (abstractNamedAFPObject instanceof ImageObject) {
                resourceObject.setType((byte)6);
            } else {
                if (!(abstractNamedAFPObject instanceof GraphicsObject)) throw new UnsupportedOperationException("Unsupported resource object for data object type " + abstractDataObject);
                resourceObject.setType((byte)3);
            }
        }
        resourceObject.setDataObject(abstractNamedAFPObject);
        return resourceObject;
    }
}

