/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.fonts;

import java.util.Arrays;

public class CharacterSetOrientation {
    private int ascender;
    private int descender;
    private int capHeight;
    private int[] charsWidths = null;
    private int xHeight;
    private char firstChar;
    private char lastChar;
    private int orientation = 0;
    private int spaceIncrement;
    private int emSpaceIncrement = -1;

    public CharacterSetOrientation(int n) {
        this.orientation = n;
        this.charsWidths = new int[256];
        Arrays.fill(this.charsWidths, -1);
    }

    public int getAscender() {
        return this.ascender;
    }

    public int getCapHeight() {
        return this.capHeight;
    }

    public int getDescender() {
        return this.descender;
    }

    public char getFirstChar() {
        return this.firstChar;
    }

    public char getLastChar() {
        return this.lastChar;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int[] getWidths() {
        int[] nArray = new int[this.getLastChar() - this.getFirstChar() + 1];
        System.arraycopy(this.charsWidths, this.getFirstChar(), nArray, 0, this.getLastChar() - this.getFirstChar() + 1);
        return nArray;
    }

    public int getXHeight() {
        return this.xHeight;
    }

    public int getWidth(char c) {
        if (c >= this.charsWidths.length) {
            throw new IllegalArgumentException("Invalid character: " + c + " (" + Integer.toString(c) + "), maximum is " + (this.charsWidths.length - 1));
        }
        return this.charsWidths[c];
    }

    public void setAscender(int n) {
        this.ascender = n;
    }

    public void setCapHeight(int n) {
        this.capHeight = n;
    }

    public void setDescender(int n) {
        this.descender = n;
    }

    public void setFirstChar(char c) {
        this.firstChar = c;
    }

    public void setLastChar(char c) {
        this.lastChar = c;
    }

    public void setWidth(char c, int n) {
        if (c >= this.charsWidths.length) {
            int[] nArray = new int[c - this.firstChar + 1];
            System.arraycopy(this.charsWidths, 0, nArray, 0, this.charsWidths.length);
            Arrays.fill(nArray, this.charsWidths.length, c - this.firstChar, -1);
            this.charsWidths = nArray;
        }
        this.charsWidths[c] = n;
    }

    public void setXHeight(int n) {
        this.xHeight = n;
    }

    public int getSpaceIncrement() {
        return this.spaceIncrement;
    }

    public void setSpaceIncrement(int n) {
        this.spaceIncrement = n;
    }

    public int getEmSpaceIncrement() {
        return this.emSpaceIncrement;
    }

    public void setEmSpaceIncrement(int n) {
        this.emSpaceIncrement = n;
    }
}

