/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.goca;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.afp.goca.AbstractGraphicsDrawingOrder;
import org.apache.fop.afp.util.BinaryUtils;

public abstract class AbstractGraphicsCoord
extends AbstractGraphicsDrawingOrder {
    protected int[] coords = null;
    protected boolean relative = false;

    public AbstractGraphicsCoord(int[] nArray) {
        if (nArray == null) {
            this.relative = true;
        } else {
            this.coords = nArray;
        }
    }

    public AbstractGraphicsCoord(int[] nArray, boolean bl) {
        this(nArray);
        this.relative = bl;
    }

    public AbstractGraphicsCoord(int n, int n2) {
        this(new int[]{n, n2});
    }

    public AbstractGraphicsCoord(int n, int n2, int n3, int n4) {
        this(new int[]{n, n2, n3, n4});
    }

    public int getDataLength() {
        return 2 + (this.coords != null ? this.coords.length * 2 : 0);
    }

    int getCoordinateDataStartIndex() {
        return 2;
    }

    byte[] getData() {
        byte[] byArray = super.getData();
        if (this.coords != null) {
            this.addCoords(byArray, this.getCoordinateDataStartIndex());
        }
        return byArray;
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        outputStream.write(this.getData());
    }

    protected void addCoords(byte[] byArray, int n) {
        int n2 = 0;
        while (n2 < this.coords.length) {
            byte[] byArray2 = BinaryUtils.convert(this.coords[n2], 2);
            byArray[n] = byArray2[0];
            byArray[n + 1] = byArray2[1];
            ++n2;
            n += 2;
        }
    }

    public String toString() {
        String string = "";
        for (int i = 0; i < this.coords.length; ++i) {
            string = string + (i % 2 == 0 ? "x" : "y");
            string = string + i / 2 + "=" + this.coords[i] + ",";
        }
        string = string.substring(0, string.length() - 1);
        return this.getName() + "{" + string + "}";
    }

    protected boolean isRelative() {
        return this.relative;
    }
}

