/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.goca;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.afp.StructuredData;
import org.apache.fop.afp.goca.AbstractGraphicsDrawingOrderContainer;
import org.apache.fop.afp.goca.GraphicsChainedSegment;
import org.apache.fop.afp.util.BinaryUtils;
import org.apache.fop.afp.util.StringUtils;

public final class GraphicsData
extends AbstractGraphicsDrawingOrderContainer {
    public static final int MAX_DATA_LEN = 8208;
    private GraphicsChainedSegment currentSegment = null;
    private boolean segmentedData;

    public int getDataLength() {
        return 8 + super.getDataLength();
    }

    public void setSegmentedData(boolean bl) {
        this.segmentedData = bl;
    }

    public String createSegmentName() {
        return StringUtils.lpad(String.valueOf((this.objects != null ? this.objects.size() : 0) + 1), '0', 4);
    }

    public GraphicsChainedSegment newSegment() {
        return this.newSegment(false, false);
    }

    public GraphicsChainedSegment newSegment(boolean bl, boolean bl2) {
        String string = this.createSegmentName();
        if (this.currentSegment == null) {
            this.currentSegment = new GraphicsChainedSegment(string);
        } else {
            this.currentSegment.setComplete(true);
            this.currentSegment = new GraphicsChainedSegment(string, this.currentSegment.getNameBytes(), bl, bl2);
        }
        super.addObject(this.currentSegment);
        return this.currentSegment;
    }

    public void addObject(StructuredData structuredData) {
        if (this.currentSegment == null || this.currentSegment.getDataLength() + structuredData.getDataLength() >= 8192) {
            this.newSegment(true, false);
        }
        this.currentSegment.addObject(structuredData);
    }

    public StructuredData removeCurrentSegment() {
        this.currentSegment = null;
        return super.removeLast();
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[9];
        GraphicsData.copySF(byArray, (byte)-45, (byte)-18, (byte)-69);
        int n = this.getDataLength();
        byte[] byArray2 = BinaryUtils.convert(n, 2);
        byArray[1] = byArray2[0];
        byArray[2] = byArray2[1];
        if (this.segmentedData) {
            byArray[6] = (byte)(byArray[6] | 0x20);
        }
        outputStream.write(byArray);
        this.writeObjects(this.objects, outputStream);
    }

    public String toString() {
        return "GraphicsData(len: " + this.getDataLength() + ")";
    }

    public void addSegment(GraphicsChainedSegment graphicsChainedSegment) {
        this.currentSegment = graphicsChainedSegment;
        super.addObject(this.currentSegment);
    }
}

