/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.fop.afp.modca.AbstractAFPObject;
import org.apache.fop.afp.ptoca.PtocaConstants;
import org.apache.fop.afp.util.BinaryUtils;

public class PresentationTextData
extends AbstractAFPObject
implements PtocaConstants {
    private static final int MAX_SIZE = 8192;
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private static final int HEADER_LENGTH = 9;

    public PresentationTextData() {
        this(false);
    }

    public PresentationTextData(boolean bl) {
        byte[] byArray = new byte[]{90, 0, 0, -45, -18, -101, 0, 0, 0};
        this.baos.write(byArray, 0, 9);
        if (bl) {
            this.baos.write(new byte[]{43, -45}, 0, 2);
        }
    }

    public int getBytesAvailable() {
        return 8192 - this.baos.size() + 9;
    }

    protected OutputStream getOutputStream() {
        return this.baos;
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        assert (this.getBytesAvailable() >= 0);
        byte[] byArray = this.baos.toByteArray();
        byte[] byArray2 = BinaryUtils.convert(byArray.length - 1, 2);
        byArray[1] = byArray2[0];
        byArray[2] = byArray2[1];
        outputStream.write(byArray);
    }
}

