/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.modca.triplets;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.afp.modca.Registry;
import org.apache.fop.afp.modca.triplets.AbstractTriplet;
import org.apache.fop.afp.util.StringUtils;

public class ObjectClassificationTriplet
extends AbstractTriplet {
    public static final byte CLASS_TIME_INVARIANT_PAGINATED_PRESENTATION_OBJECT = 1;
    public static final byte CLASS_TIME_VARIANT_PRESENTATION_OBJECT = 16;
    public static final byte CLASS_EXECUTABLE_PROGRAM = 32;
    public static final byte CLASS_SETUP_FILE = 48;
    public static final byte CLASS_SECONDARY_RESOURCE = 64;
    public static final byte CLASS_DATA_OBJECT_FONT = 65;
    private final byte objectClass;
    private final Registry.ObjectType objectType;
    private final boolean containerHasOEG;
    private final boolean dataInContainer;
    private final boolean dataInOCD;
    private final String objectLevel;
    private final String companyName;
    private static final int OBJECT_LEVEL_LEN = 8;
    private static final int OBJECT_TYPE_NAME_LEN = 32;
    private static final int COMPANY_NAME_LEN = 32;

    public ObjectClassificationTriplet(byte by, Registry.ObjectType objectType, boolean bl, boolean bl2, boolean bl3) {
        this(by, objectType, bl, bl2, bl3, null, null);
    }

    public ObjectClassificationTriplet(byte by, Registry.ObjectType objectType, boolean bl, boolean bl2, boolean bl3, String string, String string2) {
        super((byte)16);
        this.objectClass = by;
        if (objectType == null) {
            throw new IllegalArgumentException("MO:DCA Registry object type is null");
        }
        this.objectType = objectType;
        this.dataInContainer = bl;
        this.containerHasOEG = bl2;
        this.dataInOCD = bl3;
        this.objectLevel = string;
        this.companyName = string2;
    }

    public byte[] getStructureFlagsAsBytes(boolean bl, boolean bl2, boolean bl3) {
        byte[] byArray = new byte[2];
        byArray[0] = bl ? (byte)(byArray[0] | 0xC0) : (byte)(byArray[0] | 0x40);
        byArray[0] = bl2 ? (byte)(byArray[0] | 0x30) : (byte)(byArray[0] | 0x10);
        byArray[0] = bl3 ? (byte)(byArray[0] | 0xC) : (byte)(byArray[0] | 4);
        byArray[1] = 0;
        return byArray;
    }

    public int getDataLength() {
        return 96;
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        byte[] byArray = this.getData();
        byArray[2] = 0;
        byArray[3] = this.objectClass;
        byArray[4] = 0;
        byArray[5] = 0;
        byte[] byArray2 = this.getStructureFlagsAsBytes(this.dataInContainer, this.containerHasOEG, this.dataInOCD);
        byArray[6] = byArray2[0];
        byArray[7] = byArray2[1];
        byte[] byArray3 = this.objectType.getOID();
        System.arraycopy(byArray3, 0, byArray, 8, byArray3.length);
        byte[] byArray4 = StringUtils.rpad(this.objectType.getName(), ' ', 32).getBytes("Cp1146");
        System.arraycopy(byArray4, 0, byArray, 24, byArray4.length);
        byte[] byArray5 = StringUtils.rpad(this.objectLevel, ' ', 8).getBytes("Cp1146");
        System.arraycopy(byArray5, 0, byArray, 56, byArray5.length);
        byte[] byArray6 = StringUtils.rpad(this.companyName, ' ', 32).getBytes("Cp1146");
        System.arraycopy(byArray6, 0, byArray, 64, byArray6.length);
        outputStream.write(byArray);
    }
}

