/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.Version;
import org.apache.fop.accessibility.DummyStructureTreeEventHandler;
import org.apache.fop.accessibility.StructureTreeEventHandler;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.events.DefaultEventBroadcaster;
import org.apache.fop.events.Event;
import org.apache.fop.events.EventBroadcaster;
import org.apache.fop.events.EventListener;
import org.apache.fop.events.FOPEventListenerProxy;
import org.apache.fop.events.LoggingEventListener;
import org.apache.fop.fo.FOEventHandler;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.RendererFactory;
import org.apache.fop.render.XMLHandlerRegistry;
import org.apache.fop.render.intermediate.IFDocumentHandler;
import org.apache.xmlgraphics.image.loader.ImageContext;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageSessionContext;

public class FOUserAgent {
    public static final float DEFAULT_TARGET_RESOLUTION = 72.0f;
    private static Log log = LogFactory.getLog((String)"FOP");
    private FopFactory factory;
    private String base = null;
    private URIResolver uriResolver = null;
    private float targetResolution = 72.0f;
    private Map rendererOptions = new HashMap();
    private File outputFile = null;
    private IFDocumentHandler documentHandlerOverride = null;
    private Renderer rendererOverride = null;
    private FOEventHandler foEventHandlerOverride = null;
    private boolean locatorEnabled = true;
    private boolean conserveMemoryPolicy = false;
    private EventBroadcaster eventBroadcaster = new FOPEventBroadcaster();
    private StructureTreeEventHandler structureTreeEventHandler = DummyStructureTreeEventHandler.INSTANCE;
    protected String producer = "Apache FOP Version " + Version.getVersion();
    protected String creator = null;
    protected Date creationDate = null;
    protected String author = null;
    protected String title = null;
    protected String subject = null;
    protected String keywords = null;
    private ImageSessionContext imageSessionContext = new AbstractImageSessionContext(){

        public ImageContext getParentContext() {
            return FOUserAgent.this.getFactory();
        }

        public float getTargetResolution() {
            return FOUserAgent.this.getTargetResolution();
        }

        public Source resolveURI(String string) {
            return FOUserAgent.this.resolveURI(string);
        }
    };

    public FOUserAgent(FopFactory fopFactory) {
        if (fopFactory == null) {
            throw new NullPointerException("The factory parameter must not be null");
        }
        this.factory = fopFactory;
        this.setBaseURL(fopFactory.getBaseURL());
        this.setTargetResolution(fopFactory.getTargetResolution());
        this.setAccessibility(fopFactory.isAccessibilityEnabled());
    }

    public FopFactory getFactory() {
        return this.factory;
    }

    public void setDocumentHandlerOverride(IFDocumentHandler iFDocumentHandler) {
        if (this.isAccessibilityEnabled()) {
            this.setStructureTreeEventHandler(iFDocumentHandler.getStructureTreeEventHandler());
        }
        this.documentHandlerOverride = iFDocumentHandler;
    }

    public IFDocumentHandler getDocumentHandlerOverride() {
        return this.documentHandlerOverride;
    }

    public void setRendererOverride(Renderer renderer) {
        this.rendererOverride = renderer;
    }

    public Renderer getRendererOverride() {
        return this.rendererOverride;
    }

    public void setFOEventHandlerOverride(FOEventHandler fOEventHandler) {
        this.foEventHandlerOverride = fOEventHandler;
    }

    public FOEventHandler getFOEventHandlerOverride() {
        return this.foEventHandlerOverride;
    }

    public void setProducer(String string) {
        this.producer = string;
    }

    public String getProducer() {
        return this.producer;
    }

    public void setCreator(String string) {
        this.creator = string;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreationDate(Date date) {
        this.creationDate = date;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setAuthor(String string) {
        this.author = string;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setKeywords(String string) {
        this.keywords = string;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public Map getRendererOptions() {
        return this.rendererOptions;
    }

    public void setBaseURL(String string) {
        this.base = string;
    }

    public void setFontBaseURL(String string) {
        try {
            this.getFactory().getFontManager().setFontBaseURL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(malformedURLException.getMessage());
        }
    }

    public String getBaseURL() {
        return this.base;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.uriResolver = uRIResolver;
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public Source resolveURI(String string) {
        return this.resolveURI(string, this.getBaseURL());
    }

    public Source resolveURI(String string, String string2) {
        Source source = null;
        boolean bl = string.startsWith("data:");
        if (!bl && this.uriResolver != null) {
            try {
                source = this.uriResolver.resolve(string, string2);
            }
            catch (TransformerException transformerException) {
                log.error((Object)("Attempt to resolve URI '" + string + "' failed: "), (Throwable)transformerException);
            }
        }
        if (source == null) {
            source = this.getFactory().resolveURI(string, string2);
        }
        return source;
    }

    public void setOutputFile(File file) {
        this.outputFile = file;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public float getTargetPixelUnitToMillimeter() {
        return 25.4f / this.targetResolution;
    }

    public float getTargetResolution() {
        return this.targetResolution;
    }

    public void setTargetResolution(float f) {
        this.targetResolution = f;
        if (log.isDebugEnabled()) {
            log.debug((Object)("target-resolution set to: " + this.targetResolution + "dpi (px2mm=" + this.getTargetPixelUnitToMillimeter() + ")"));
        }
    }

    public void setTargetResolution(int n) {
        this.setTargetResolution((float)n);
    }

    public ImageSessionContext getImageSessionContext() {
        return this.imageSessionContext;
    }

    public String getFontBaseURL() {
        String string = this.getFactory().getFontManager().getFontBaseURL();
        return string != null ? string : this.getBaseURL();
    }

    public float getSourcePixelUnitToMillimeter() {
        return this.getFactory().getSourcePixelUnitToMillimeter();
    }

    public float getSourceResolution() {
        return this.getFactory().getSourceResolution();
    }

    public String getPageHeight() {
        return this.getFactory().getPageHeight();
    }

    public String getPageWidth() {
        return this.getFactory().getPageWidth();
    }

    public boolean validateStrictly() {
        return this.getFactory().validateStrictly();
    }

    public boolean isBreakIndentInheritanceOnReferenceAreaBoundary() {
        return this.getFactory().isBreakIndentInheritanceOnReferenceAreaBoundary();
    }

    public RendererFactory getRendererFactory() {
        return this.getFactory().getRendererFactory();
    }

    public XMLHandlerRegistry getXMLHandlerRegistry() {
        return this.getFactory().getXMLHandlerRegistry();
    }

    public void setLocatorEnabled(boolean bl) {
        this.locatorEnabled = bl;
    }

    public boolean isLocatorEnabled() {
        return this.locatorEnabled;
    }

    public EventBroadcaster getEventBroadcaster() {
        return this.eventBroadcaster;
    }

    public boolean isConserveMemoryPolicyEnabled() {
        return this.conserveMemoryPolicy;
    }

    public void setConserveMemoryPolicy(boolean bl) {
        this.conserveMemoryPolicy = bl;
    }

    public boolean isComplexScriptFeaturesEnabled() {
        return this.factory.isComplexScriptFeaturesEnabled();
    }

    public void setComplexScriptFeaturesEnabled(boolean bl) {
        this.factory.setComplexScriptFeaturesEnabled(bl);
    }

    public void setAccessibility(boolean bl) {
        if (bl) {
            this.getRendererOptions().put("accessibility", Boolean.TRUE);
        }
    }

    public boolean isAccessibilityEnabled() {
        Boolean bl = (Boolean)this.getRendererOptions().get("accessibility");
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public void setStructureTreeEventHandler(StructureTreeEventHandler structureTreeEventHandler) {
        this.structureTreeEventHandler = structureTreeEventHandler;
    }

    public StructureTreeEventHandler getStructureTreeEventHandler() {
        return this.structureTreeEventHandler;
    }

    private class FOPEventBroadcaster
    extends DefaultEventBroadcaster {
        private EventListener rootListener;

        public FOPEventBroadcaster() {
            this.rootListener = new EventListener(){

                public void processEvent(Event event) {
                    if (!FOPEventBroadcaster.this.listeners.hasEventListeners()) {
                        FOPEventBroadcaster.this.addEventListener(new LoggingEventListener(LogFactory.getLog(FOUserAgent.class)));
                    }
                    FOPEventBroadcaster.this.rootListener = new FOPEventListenerProxy(FOPEventBroadcaster.this.listeners, FOUserAgent.this);
                    FOPEventBroadcaster.this.rootListener.processEvent(event);
                }
            };
        }

        public void broadcastEvent(Event event) {
            this.rootListener.processEvent(event);
        }
    }
}

