/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.fop.ResourceEventProducer;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.AreaEventProducer;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.RenderPagesModel;
import org.apache.fop.fonts.FontInfo;
import org.xml.sax.SAXException;

public class CachedRenderPagesModel
extends RenderPagesModel {
    private Map<PageViewport, String> pageMap = new HashMap<PageViewport, String>();
    protected File baseDir = new File(System.getProperty("java.io.tmpdir"));

    public CachedRenderPagesModel(FOUserAgent fOUserAgent, String string, FontInfo fontInfo, OutputStream outputStream) throws FOPException {
        super(fOUserAgent, string, fontInfo, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkPreparedPages(PageViewport pageViewport, boolean bl) {
        Iterator iterator = this.prepared.iterator();
        while (iterator.hasNext()) {
            PageViewport pageViewport2 = (PageViewport)iterator.next();
            if (pageViewport2.isResolved() || bl) {
                if (pageViewport2 != pageViewport) {
                    Object object;
                    try {
                        String string = this.pageMap.get(pageViewport2);
                        object = new File(this.baseDir, string);
                        log.debug((Object)("Loading page from: " + object));
                        ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream((File)object)));
                        try {
                            pageViewport2.loadPage(objectInputStream);
                        }
                        finally {
                            IOUtils.closeQuietly((InputStream)objectInputStream);
                        }
                        if (!((File)object).delete()) {
                            ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get(this.renderer.getUserAgent().getEventBroadcaster());
                            resourceEventProducer.cannotDeleteTempFile(this, (File)object);
                        }
                        this.pageMap.remove(pageViewport2);
                    }
                    catch (Exception exception) {
                        object = AreaEventProducer.Provider.get(this.renderer.getUserAgent().getEventBroadcaster());
                        object.pageLoadError(this, pageViewport2.getPageNumberString(), exception);
                    }
                }
                this.renderPage(pageViewport2);
                pageViewport2.clear();
                iterator.remove();
                continue;
            }
            if (this.renderer.supportsOutOfOrder()) continue;
            break;
        }
        if (pageViewport != null && pageViewport.getPage() != null) {
            this.savePage(pageViewport);
            pageViewport.clear();
        }
        return this.renderer.supportsOutOfOrder() || this.prepared.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void savePage(PageViewport pageViewport) {
        try {
            String string = "fop-page-" + pageViewport.getPageIndex() + ".ser";
            File file = new File(this.baseDir, string);
            file.deleteOnExit();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            try {
                pageViewport.savePage(objectOutputStream);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)objectOutputStream);
            }
            this.pageMap.put(pageViewport, string);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Page saved to temporary file: " + file));
            }
        }
        catch (IOException iOException) {
            AreaEventProducer areaEventProducer = AreaEventProducer.Provider.get(this.renderer.getUserAgent().getEventBroadcaster());
            areaEventProducer.pageSaveError(this, pageViewport.getPageNumberString(), iOException);
        }
    }

    public void endDocument() throws SAXException {
        super.endDocument();
    }
}

