/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.cli;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.cli.CommandLineOptions;

public final class Main {
    private Main() {
    }

    public static URL[] getJARList() throws MalformedURLException {
        String string;
        int n;
        File[] fileArray;
        File file;
        String string2 = System.getProperty("fop.home");
        File file2 = string2 != null ? new File(string2).getAbsoluteFile() : new File(".").getAbsoluteFile().getParentFile();
        if ("build".equals(file2.getName())) {
            file = file2;
            file2 = file2.getParentFile();
        } else {
            file = new File(file2, "build");
        }
        File file3 = new File(file, "fop.jar");
        if (!file3.exists()) {
            file3 = new File(file2, "fop.jar");
        }
        if (!file3.exists()) {
            throw new RuntimeException("fop.jar not found in directory: " + file2.getAbsolutePath() + " (or below)");
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        arrayList.add(file3.toURI().toURL());
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".jar");
            }
        };
        File file4 = new File(file2, "lib");
        if (!file4.exists()) {
            file4 = file2;
        }
        if ((fileArray = file4.listFiles(fileFilter)) != null) {
            n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                arrayList.add(fileArray[i].toURI().toURL());
            }
        }
        if ((string = System.getProperty("fop.optional.lib")) != null && (fileArray = new File(string).listFiles(fileFilter)) != null) {
            int n2 = fileArray.length;
            for (n = 0; n < n2; ++n) {
                arrayList.add(fileArray[n].toURI().toURL());
            }
        }
        URL[] uRLArray = arrayList.toArray(new URL[arrayList.size()]);
        return uRLArray;
    }

    public static boolean checkDependencies() {
        try {
            Class<?> clazz = Class.forName("org.apache.commons.io.IOUtils");
            if (clazz != null) {
                clazz = Class.forName("org.apache.avalon.framework.configuration.Configuration");
            }
            return clazz != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void startFOPWithDynamicClasspath(String[] stringArray) {
        try {
            URL[] uRLArray = Main.getJARList();
            URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, null);
            Thread.currentThread().setContextClassLoader(uRLClassLoader);
            Class<?> clazz = Class.forName("org.apache.fop.cli.Main", true, uRLClassLoader);
            Method method = clazz.getMethod("startFOP", String[].class);
            method.invoke(null, new Object[]{stringArray});
        }
        catch (Exception exception) {
            System.err.println("Unable to start FOP:");
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startFOP(String[] stringArray) {
        CommandLineOptions commandLineOptions = null;
        FOUserAgent fOUserAgent = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            String string;
            block12: {
                commandLineOptions = new CommandLineOptions();
                if (!commandLineOptions.parse(stringArray)) {
                    System.exit(0);
                }
                fOUserAgent = commandLineOptions.getFOUserAgent();
                string = commandLineOptions.getOutputFormat();
                try {
                    if (commandLineOptions.getOutputFile() != null) {
                        bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(commandLineOptions.getOutputFile()));
                        fOUserAgent.setOutputFile(commandLineOptions.getOutputFile());
                    } else if (commandLineOptions.isOutputToStdOut()) {
                        bufferedOutputStream = new BufferedOutputStream(System.out);
                    }
                    if (!"text/xsl".equals(string)) {
                        commandLineOptions.getInputHandler().renderTo(fOUserAgent, string, bufferedOutputStream);
                        break block12;
                    }
                    commandLineOptions.getInputHandler().transformTo(bufferedOutputStream);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(bufferedOutputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)bufferedOutputStream);
            if (!"application/X-fop-awt-preview".equals(string)) {
                System.exit(0);
            }
        }
        catch (Exception exception) {
            if (commandLineOptions != null) {
                commandLineOptions.getLogger().error((Object)"Exception", (Throwable)exception);
                if (commandLineOptions.getOutputFile() != null) {
                    commandLineOptions.getOutputFile().delete();
                }
            }
            System.exit(1);
        }
    }

    public static void main(String[] stringArray) {
        if (Main.checkDependencies()) {
            Main.startFOP(stringArray);
        } else {
            Main.startFOPWithDynamicClasspath(stringArray);
        }
    }
}

