/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.bidi;

import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.complexscripts.bidi.BidiResolver;
import org.apache.fop.complexscripts.bidi.TextInterval;
import org.apache.fop.complexscripts.bidi.UnicodeBidiAlgorithm;
import org.apache.fop.fo.CharIterator;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.traits.Direction;
import org.apache.fop.traits.WritingModeTraits;
import org.apache.fop.traits.WritingModeTraitsGetter;
import org.apache.fop.util.CharUtilities;

public class DelimitedTextRange {
    private FONode fn;
    private StringBuffer buffer;
    private List intervals;
    private static final Log log = LogFactory.getLog(BidiResolver.class);

    public DelimitedTextRange(FONode fONode) {
        this.fn = fONode;
        this.buffer = new StringBuffer();
        this.intervals = new Vector();
    }

    public FONode getNode() {
        return this.fn;
    }

    public void append(CharIterator charIterator, FONode fONode) {
        if (charIterator != null) {
            int n;
            int n2 = n = this.buffer.length();
            while (charIterator.hasNext()) {
                char c = charIterator.nextChar();
                this.buffer.append(c);
                ++n2;
            }
            this.intervals.add(new TextInterval(fONode, n, n2));
        }
    }

    public void append(char c, FONode fONode) {
        if (c != '\u0000') {
            int n = this.buffer.length();
            int n2 = n + 1;
            this.buffer.append(c);
            this.intervals.add(new TextInterval(fONode, n, n2));
        }
    }

    public boolean isEmpty() {
        return this.buffer.length() == 0;
    }

    public void resolve() {
        WritingModeTraitsGetter writingModeTraitsGetter = WritingModeTraits.getWritingModeTraitsGetter(this.getNode());
        if (writingModeTraitsGetter != null) {
            this.resolve(writingModeTraitsGetter.getInlineProgressionDirection());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("DR: " + this.fn.getLocalName() + " { <" + CharUtilities.toNCRefs(this.buffer.toString()) + ">");
        stringBuffer.append(", intervals <");
        boolean bl = true;
        for (TextInterval textInterval : this.intervals) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(',');
            }
            stringBuffer.append(textInterval.toString());
        }
        stringBuffer.append("> }");
        return stringBuffer.toString();
    }

    private void resolve(Direction direction) {
        int[] nArray = UnicodeBidiAlgorithm.resolveLevels(this.buffer, direction);
        if (nArray != null) {
            this.assignLevels(nArray);
            this.assignBlockLevel(direction);
            this.assignTextLevels();
        }
    }

    private void assignLevels(int[] nArray) {
        Vector vector = new Vector(this.intervals.size());
        for (TextInterval textInterval : this.intervals) {
            vector.addAll(this.assignLevels(textInterval, nArray));
        }
        if (!vector.equals(this.intervals)) {
            this.intervals = vector;
        }
    }

    private List assignLevels(TextInterval textInterval, int[] nArray) {
        int n;
        Vector<TextInterval> vector = new Vector<TextInterval>();
        FONode fONode = textInterval.getNode();
        int n2 = n = textInterval.getStart();
        int n3 = textInterval.getEnd();
        while (n2 < n3) {
            int n4;
            int n5;
            int n6 = nArray[n5];
            for (n4 = n5 = n2; n4 < n3 && nArray[n4] == n6; ++n4) {
            }
            if (textInterval.getStart() == n5 && textInterval.getEnd() == n4) {
                textInterval.setLevel(n6);
            } else {
                textInterval = new TextInterval(fONode, n, n5, n4, n6);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("AL(" + n6 + "): " + textInterval));
            }
            vector.add(textInterval);
            n2 = n4;
        }
        return vector;
    }

    private void assignTextLevels() {
        for (TextInterval textInterval : this.intervals) {
            textInterval.assignTextLevels();
        }
    }

    private void assignBlockLevel(Direction direction) {
        int n = direction == Direction.RL ? 1 : 0;
        for (TextInterval textInterval : this.intervals) {
            this.assignBlockLevel(textInterval.getNode(), n);
        }
    }

    private void assignBlockLevel(FONode fONode, int n) {
        for (FONode fONode2 = fONode; fONode2 != null; fONode2 = fONode2.getParent()) {
            FObj fObj;
            if (!(fONode2 instanceof FObj) || !(fObj = (FObj)fONode2).isBidiRangeBlockItem()) continue;
            if (fObj.getBidiLevel() >= 0) break;
            fObj.setBidiLevel(n);
            break;
        }
    }
}

