/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.fonts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.fop.complexscripts.fonts.AdvancedTypographicTableFormatException;

public class GlyphMappingTable {
    public static final int GLYPH_MAPPING_TYPE_EMPTY = 0;
    public static final int GLYPH_MAPPING_TYPE_MAPPED = 1;
    public static final int GLYPH_MAPPING_TYPE_RANGE = 2;

    public int getType() {
        return -1;
    }

    public List getEntries() {
        return null;
    }

    public int getMappingSize() {
        return 0;
    }

    public int getMappedIndex(int n) {
        return -1;
    }

    public static class MappingRange {
        private final int gidStart;
        private final int gidEnd;
        private final int index;

        public MappingRange() {
            this(0, 0, 0);
        }

        public MappingRange(int n, int n2, int n3) {
            if (n < 0 || n2 < 0 || n3 < 0) {
                throw new AdvancedTypographicTableFormatException();
            }
            if (n > n2) {
                throw new AdvancedTypographicTableFormatException();
            }
            this.gidStart = n;
            this.gidEnd = n2;
            this.index = n3;
        }

        public int getStart() {
            return this.gidStart;
        }

        public int getEnd() {
            return this.gidEnd;
        }

        public int getIndex() {
            return this.index;
        }

        public int[] getInterval() {
            return new int[]{this.gidStart, this.gidEnd};
        }

        public int[] getInterval(int[] nArray) {
            if (nArray == null || nArray.length != 2) {
                throw new IllegalArgumentException();
            }
            nArray[0] = this.gidStart;
            nArray[1] = this.gidEnd;
            return nArray;
        }

        public int getLength() {
            return this.gidStart - this.gidEnd;
        }
    }

    protected static abstract class RangeMappingTable
    extends GlyphMappingTable {
        private int[] sa = null;
        private int[] ea = null;
        private int[] ma = null;
        private int miMax = -1;

        public RangeMappingTable(List list) {
            this.populate(list);
        }

        public int getType() {
            return 2;
        }

        public List getEntries() {
            ArrayList<MappingRange> arrayList = new ArrayList<MappingRange>();
            if (this.sa != null) {
                int n = this.sa.length;
                for (int i = 0; i < n; ++i) {
                    arrayList.add(new MappingRange(this.sa[i], this.ea[i], this.ma[i]));
                }
            }
            return arrayList;
        }

        public int getMappingSize() {
            return this.miMax + 1;
        }

        public int getMappedIndex(int n) {
            int n2 = Arrays.binarySearch(this.sa, n);
            int n3 = n2 >= 0 ? this.getMappedIndex(n, this.sa[n2], this.ma[n2]) : ((n2 = -(n2 + 1)) == 0 ? -1 : (n > this.ea[--n2] ? -1 : this.getMappedIndex(n, this.sa[n2], this.ma[n2])));
            return n3;
        }

        public abstract int getMappedIndex(int var1, int var2, int var3);

        private void populate(List list) {
            int n = 0;
            int n2 = list.size();
            int n3 = -1;
            int n4 = -1;
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            int[] nArray3 = new int[n2];
            for (Object e : list) {
                if (e instanceof MappingRange) {
                    MappingRange mappingRange = (MappingRange)e;
                    int n5 = mappingRange.getStart();
                    int n6 = mappingRange.getEnd();
                    int n7 = mappingRange.getIndex();
                    if (n5 < 0 || n5 > 65535) {
                        throw new AdvancedTypographicTableFormatException("illegal glyph range: [" + n5 + "," + n6 + "]: bad start index");
                    }
                    if (n6 < 0 || n6 > 65535) {
                        throw new AdvancedTypographicTableFormatException("illegal glyph range: [" + n5 + "," + n6 + "]: bad end index");
                    }
                    if (n5 > n6) {
                        throw new AdvancedTypographicTableFormatException("illegal glyph range: [" + n5 + "," + n6 + "]: start index exceeds end index");
                    }
                    if (n5 < n3) {
                        throw new AdvancedTypographicTableFormatException("out of order glyph range: [" + n5 + "," + n6 + "]");
                    }
                    if (n7 < 0) {
                        throw new AdvancedTypographicTableFormatException("illegal mapping index: " + n7);
                    }
                    nArray[n] = n5;
                    nArray2[n] = n3 = n6;
                    nArray3[n] = n7;
                    int n8 = n7 + (n6 - n5);
                    if (n8 > n4) {
                        n4 = n8;
                    }
                    ++n;
                    continue;
                }
                throw new AdvancedTypographicTableFormatException("illegal mapping entry, must be Integer: " + e);
            }
            assert (n == n2);
            assert (this.sa == null);
            assert (this.ea == null);
            assert (this.ma == null);
            this.sa = nArray;
            this.ea = nArray2;
            this.ma = nArray3;
            this.miMax = n4;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('{');
            int n = this.sa.length;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append('[');
                stringBuffer.append(Integer.toString(this.sa[i]));
                stringBuffer.append(Integer.toString(this.ea[i]));
                stringBuffer.append("]:");
                stringBuffer.append(Integer.toString(this.ma[i]));
            }
            stringBuffer.append('}');
            return stringBuffer.toString();
        }
    }

    protected static class MappedMappingTable
    extends GlyphMappingTable {
        public int getType() {
            return 1;
        }
    }

    protected static class EmptyMappingTable
    extends GlyphMappingTable {
        public EmptyMappingTable() {
            this(null);
        }

        public EmptyMappingTable(List list) {
        }

        public int getType() {
            return 0;
        }

        public List getEntries() {
            return new ArrayList();
        }

        public int getMappingSize() {
            return 0;
        }

        public int getMappedIndex(int n) {
            return -1;
        }
    }
}

