/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.fonts;

import org.apache.fop.complexscripts.fonts.GlyphPositioningSubtable;
import org.apache.fop.complexscripts.fonts.GlyphPositioningTable;
import org.apache.fop.complexscripts.fonts.GlyphProcessingState;
import org.apache.fop.complexscripts.fonts.GlyphTable;
import org.apache.fop.complexscripts.util.GlyphSequence;
import org.apache.fop.complexscripts.util.ScriptContextTester;

public class GlyphPositioningState
extends GlyphProcessingState {
    private int fontSize;
    private int[] widths;
    private int[][] adjustments;
    private boolean adjusted;

    public GlyphPositioningState(GlyphSequence glyphSequence, String string, String string2, String string3, int n, int[] nArray, int[][] nArray2, ScriptContextTester scriptContextTester) {
        super(glyphSequence, string, string2, string3, scriptContextTester);
        this.fontSize = n;
        this.widths = nArray;
        this.adjustments = nArray2;
    }

    public GlyphPositioningState(GlyphPositioningState glyphPositioningState) {
        super(glyphPositioningState);
        this.fontSize = glyphPositioningState.fontSize;
        this.widths = glyphPositioningState.widths;
        this.adjustments = glyphPositioningState.adjustments;
    }

    public int getWidth(int n) {
        if (this.widths != null && n < this.widths.length) {
            return this.widths[n];
        }
        return 0;
    }

    public boolean adjust(GlyphPositioningTable.Value value) {
        return this.adjust(value, 0);
    }

    public boolean adjust(GlyphPositioningTable.Value value, int n) {
        assert (value != null);
        if (this.index + n < this.indexLast) {
            return value.adjust(this.adjustments[this.index + n], this.fontSize);
        }
        throw new IndexOutOfBoundsException();
    }

    public int[] getAdjustment() {
        return this.getAdjustment(0);
    }

    public int[] getAdjustment(int n) throws IndexOutOfBoundsException {
        if (this.index + n < this.indexLast) {
            return this.adjustments[this.index + n];
        }
        throw new IndexOutOfBoundsException();
    }

    public boolean apply(GlyphPositioningSubtable glyphPositioningSubtable) {
        assert (glyphPositioningSubtable != null);
        this.updateSubtableState(glyphPositioningSubtable);
        boolean bl = glyphPositioningSubtable.position(this);
        this.resetSubtableState();
        return bl;
    }

    public boolean apply(GlyphTable.RuleLookup[] ruleLookupArray, int n) {
        if (ruleLookupArray != null && ruleLookupArray.length > 0) {
            for (GlyphTable.RuleLookup ruleLookup : ruleLookupArray) {
                GlyphPositioningState glyphPositioningState;
                GlyphTable.LookupTable lookupTable;
                if (ruleLookup == null || (lookupTable = ruleLookup.getLookup()) == null || !lookupTable.position(glyphPositioningState = new GlyphPositioningState(this), ruleLookup.getSequenceIndex())) continue;
                this.setAdjusted(true);
            }
            this.consume(n);
            return true;
        }
        return false;
    }

    public void applyDefault() {
        super.applyDefault();
    }

    public void setAdjusted(boolean bl) {
        this.adjusted = bl;
    }

    public boolean getAdjusted() {
        return this.adjusted;
    }
}

