/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.scripts;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.complexscripts.bidi.BidiClass;
import org.apache.fop.complexscripts.fonts.GlyphDefinitionTable;
import org.apache.fop.complexscripts.scripts.DefaultScriptProcessor;
import org.apache.fop.complexscripts.util.GlyphContextTester;
import org.apache.fop.complexscripts.util.GlyphSequence;
import org.apache.fop.complexscripts.util.ScriptContextTester;

public class ArabicScriptProcessor
extends DefaultScriptProcessor {
    private static final Log log = LogFactory.getLog(ArabicScriptProcessor.class);
    private static final String[] gsubFeatures = new String[]{"calt", "ccmp", "fina", "init", "isol", "liga", "medi", "rlig"};
    private static final String[] gposFeatures = new String[]{"curs", "kern", "mark", "mkmk"};
    private final ScriptContextTester subContextTester = new SubstitutionScriptContextTester();
    private final ScriptContextTester posContextTester = new PositioningScriptContextTester();
    private static int[] isolatedInitials = new int[]{1569, 1570, 1571, 1572, 1573, 1575, 1583, 1584, 1585, 1586, 1608, 1649, 1650, 1651, 1653, 1654, 1655, 1672, 1673, 1674, 1675, 1676, 1677, 1678, 1679, 1680, 1681, 1682, 1683, 1684, 1685, 1686, 1687, 1688, 1689, 1732, 1733, 1734, 1735, 1736, 1737, 1738, 1739, 1743, 1774, 1775};
    private static int[] isolatedFinals = new int[]{1569};

    ArabicScriptProcessor(String string) {
        super(string);
    }

    public String[] getSubstitutionFeatures() {
        return gsubFeatures;
    }

    public ScriptContextTester getSubstitutionContextTester() {
        return this.subContextTester;
    }

    public String[] getPositioningFeatures() {
        return gposFeatures;
    }

    public ScriptContextTester getPositioningContextTester() {
        return this.posContextTester;
    }

    public GlyphSequence reorderCombiningMarks(GlyphDefinitionTable glyphDefinitionTable, GlyphSequence glyphSequence, int[][] nArray, String string, String string2) {
        return glyphSequence;
    }

    private static boolean inFinalContext(String string, String string2, String string3, GlyphSequence glyphSequence, int n, int n2) {
        int n3;
        GlyphSequence.CharAssociation charAssociation = glyphSequence.getAssociation(n);
        int[] nArray = glyphSequence.getCharacterArray(false);
        int n4 = glyphSequence.getCharacterCount();
        if (n4 == 0) {
            return false;
        }
        int n5 = charAssociation.getStart();
        if (!ArabicScriptProcessor.hasFinalPrecedingContext(nArray, n4, n5, n3 = charAssociation.getEnd())) {
            return false;
        }
        if (ArabicScriptProcessor.forcesFinalThisContext(nArray, n4, n5, n3)) {
            return true;
        }
        return ArabicScriptProcessor.hasFinalFollowingContext(nArray, n4, n5, n3);
    }

    private static boolean inInitialContext(String string, String string2, String string3, GlyphSequence glyphSequence, int n, int n2) {
        int n3;
        GlyphSequence.CharAssociation charAssociation = glyphSequence.getAssociation(n);
        int[] nArray = glyphSequence.getCharacterArray(false);
        int n4 = glyphSequence.getCharacterCount();
        if (n4 == 0) {
            return false;
        }
        int n5 = charAssociation.getStart();
        if (!ArabicScriptProcessor.hasInitialPrecedingContext(nArray, n4, n5, n3 = charAssociation.getEnd())) {
            return false;
        }
        return ArabicScriptProcessor.hasInitialFollowingContext(nArray, n4, n5, n3);
    }

    private static boolean inIsolateContext(String string, String string2, String string3, GlyphSequence glyphSequence, int n, int n2) {
        GlyphSequence.CharAssociation charAssociation = glyphSequence.getAssociation(n);
        int n3 = glyphSequence.getCharacterCount();
        if (n3 == 0) {
            return false;
        }
        return charAssociation.getStart() == 0 && charAssociation.getEnd() == n3;
    }

    private static boolean inLigatureContext(String string, String string2, String string3, GlyphSequence glyphSequence, int n, int n2) {
        int n3;
        GlyphSequence.CharAssociation charAssociation = glyphSequence.getAssociation(n);
        int[] nArray = glyphSequence.getCharacterArray(false);
        int n4 = glyphSequence.getCharacterCount();
        if (n4 == 0) {
            return false;
        }
        int n5 = charAssociation.getStart();
        if (!ArabicScriptProcessor.hasLigaturePrecedingContext(nArray, n4, n5, n3 = charAssociation.getEnd())) {
            return false;
        }
        return ArabicScriptProcessor.hasLigatureFollowingContext(nArray, n4, n5, n3);
    }

    private static boolean inMedialContext(String string, String string2, String string3, GlyphSequence glyphSequence, int n, int n2) {
        int n3;
        GlyphSequence.CharAssociation charAssociation = glyphSequence.getAssociation(n);
        int[] nArray = glyphSequence.getCharacterArray(false);
        int n4 = glyphSequence.getCharacterCount();
        if (n4 == 0) {
            return false;
        }
        int n5 = charAssociation.getStart();
        if (!ArabicScriptProcessor.hasMedialPrecedingContext(nArray, n4, n5, n3 = charAssociation.getEnd())) {
            return false;
        }
        if (!ArabicScriptProcessor.hasMedialThisContext(nArray, n4, n5, n3)) {
            return false;
        }
        return ArabicScriptProcessor.hasMedialFollowingContext(nArray, n4, n5, n3);
    }

    private static boolean hasFinalPrecedingContext(int[] nArray, int n, int n2, int n3) {
        int n4;
        int n5 = 0;
        int n6 = 0;
        for (int i = n2; i > 0 && ((n4 = i - 1) < 0 || n4 >= n || (n6 = BidiClass.getBidiClass(n5 = nArray[n4])) == 14); --i) {
        }
        if (n6 != 5) {
            return false;
        }
        return !ArabicScriptProcessor.hasIsolateInitial(n5);
    }

    private static boolean forcesFinalThisContext(int[] nArray, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = 0;
        int n7 = 0;
        int n8 = n3 - n2;
        for (int i = 0; i < n8 && ((n5 = n2 + (n4 = n8 - i - 1)) < 0 || n5 >= n || (n7 = BidiClass.getBidiClass(n6 = nArray[n5])) == 14); ++i) {
        }
        if (n7 != 5) {
            return false;
        }
        return ArabicScriptProcessor.hasIsolateInitial(n6);
    }

    private static boolean hasFinalFollowingContext(int[] nArray, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = n;
        for (int i = n3; i < n6 && (n5 = BidiClass.getBidiClass(n4 = nArray[i])) == 14; ++i) {
        }
        if (n5 != 5) {
            return true;
        }
        return ArabicScriptProcessor.hasIsolateFinal(n4);
    }

    private static boolean hasInitialPrecedingContext(int[] nArray, int n, int n2, int n3) {
        int n4;
        int n5 = 0;
        int n6 = 0;
        for (int i = n2; i > 0 && ((n4 = i - 1) < 0 || n4 >= n || (n6 = BidiClass.getBidiClass(n5 = nArray[n4])) == 14); --i) {
        }
        if (n6 != 5) {
            return true;
        }
        return ArabicScriptProcessor.hasIsolateInitial(n5);
    }

    private static boolean hasInitialFollowingContext(int[] nArray, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = n;
        for (int i = n3; i < n6 && (n5 = BidiClass.getBidiClass(n4 = nArray[i])) == 14; ++i) {
        }
        if (n5 != 5) {
            return false;
        }
        return !ArabicScriptProcessor.hasIsolateFinal(n4);
    }

    private static boolean hasMedialPrecedingContext(int[] nArray, int n, int n2, int n3) {
        int n4;
        int n5 = 0;
        int n6 = 0;
        for (int i = n2; i > 0 && ((n4 = i - 1) < 0 || n4 >= n || (n6 = BidiClass.getBidiClass(n5 = nArray[n4])) == 14); --i) {
        }
        if (n6 != 5) {
            return false;
        }
        return !ArabicScriptProcessor.hasIsolateInitial(n5);
    }

    private static boolean hasMedialThisContext(int[] nArray, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = 0;
        int n9 = 0;
        int n10 = n3 - n2;
        for (n7 = 0; n7 < n10 && ((n6 = n2 + n7) < 0 || n6 >= n || (n9 = BidiClass.getBidiClass(n8 = nArray[n2 + n7])) == 14); ++n7) {
        }
        if (n9 != 5) {
            return false;
        }
        n7 = 0;
        n10 = 0;
        int n11 = n3 - n2;
        for (n6 = 0; n6 < n11 && ((n5 = n2 + (n4 = n11 - n6 - 1)) < 0 || n5 >= n || (n10 = BidiClass.getBidiClass(n7 = nArray[n5])) == 14); ++n6) {
        }
        if (n10 != 5) {
            return false;
        }
        if (ArabicScriptProcessor.hasIsolateFinal(n8)) {
            return false;
        }
        return !ArabicScriptProcessor.hasIsolateInitial(n7);
    }

    private static boolean hasMedialFollowingContext(int[] nArray, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = n;
        for (int i = n3; i < n6 && (n5 = BidiClass.getBidiClass(n4 = nArray[i])) == 14; ++i) {
        }
        if (n5 != 5) {
            return false;
        }
        return !ArabicScriptProcessor.hasIsolateFinal(n4);
    }

    private static boolean hasLigaturePrecedingContext(int[] nArray, int n, int n2, int n3) {
        return true;
    }

    private static boolean hasLigatureFollowingContext(int[] nArray, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = n;
        for (int i = n3; i < n6 && (n5 = BidiClass.getBidiClass(n4 = nArray[i])) == 14; ++i) {
        }
        return n5 == 5;
    }

    private static boolean hasIsolateInitial(int n) {
        return Arrays.binarySearch(isolatedInitials, n) >= 0;
    }

    private static boolean hasIsolateFinal(int n) {
        return Arrays.binarySearch(isolatedFinals, n) >= 0;
    }

    private static class PositioningScriptContextTester
    implements ScriptContextTester {
        private static Map testerMap = new HashMap();

        private PositioningScriptContextTester() {
        }

        public GlyphContextTester getTester(String string) {
            return (GlyphContextTester)testerMap.get(string);
        }
    }

    private static class SubstitutionScriptContextTester
    implements ScriptContextTester {
        private static Map testerMap = new HashMap();

        private SubstitutionScriptContextTester() {
        }

        public GlyphContextTester getTester(String string) {
            return (GlyphContextTester)testerMap.get(string);
        }

        static {
            testerMap.put("fina", new GlyphContextTester(){

                public boolean test(String string, String string2, String string3, GlyphSequence glyphSequence, int n, int n2) {
                    return ArabicScriptProcessor.inFinalContext(string, string2, string3, glyphSequence, n, n2);
                }
            });
            testerMap.put("init", new GlyphContextTester(){

                public boolean test(String string, String string2, String string3, GlyphSequence glyphSequence, int n, int n2) {
                    return ArabicScriptProcessor.inInitialContext(string, string2, string3, glyphSequence, n, n2);
                }
            });
            testerMap.put("isol", new GlyphContextTester(){

                public boolean test(String string, String string2, String string3, GlyphSequence glyphSequence, int n, int n2) {
                    return ArabicScriptProcessor.inIsolateContext(string, string2, string3, glyphSequence, n, n2);
                }
            });
            testerMap.put("liga", new GlyphContextTester(){

                public boolean test(String string, String string2, String string3, GlyphSequence glyphSequence, int n, int n2) {
                    return ArabicScriptProcessor.inLigatureContext(string, string2, string3, glyphSequence, n, n2);
                }
            });
            testerMap.put("medi", new GlyphContextTester(){

                public boolean test(String string, String string2, String string3, GlyphSequence glyphSequence, int n, int n2) {
                    return ArabicScriptProcessor.inMedialContext(string, string2, string3, glyphSequence, n, n2);
                }
            });
        }
    }
}

