/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.scripts;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.complexscripts.fonts.GlyphTable;
import org.apache.fop.complexscripts.scripts.DefaultScriptProcessor;
import org.apache.fop.complexscripts.scripts.DevanagariScriptProcessor;
import org.apache.fop.complexscripts.scripts.GujaratiScriptProcessor;
import org.apache.fop.complexscripts.scripts.GurmukhiScriptProcessor;
import org.apache.fop.complexscripts.scripts.ScriptProcessor;
import org.apache.fop.complexscripts.util.CharScript;
import org.apache.fop.complexscripts.util.GlyphContextTester;
import org.apache.fop.complexscripts.util.GlyphSequence;
import org.apache.fop.complexscripts.util.ScriptContextTester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndicScriptProcessor
extends DefaultScriptProcessor {
    private static final Log log = LogFactory.getLog(IndicScriptProcessor.class);
    private static final String[] gsubReqFeatures = new String[]{"abvf", "abvs", "akhn", "blwf", "blws", "ccmp", "cjct", "clig", "half", "haln", "locl", "nukt", "pref", "pres", "pstf", "psts", "rkrf", "rphf", "vatu"};
    private static final String[] gsubOptFeatures = new String[]{"afrc", "calt", "dlig"};
    private static final String[] gposReqFeatures = new String[]{"abvm", "blwm", "dist", "kern"};
    private static final String[] gposOptFeatures = new String[0];
    private final ScriptContextTester subContextTester = new SubstitutionScriptContextTester();
    private final ScriptContextTester posContextTester = new PositioningScriptContextTester();
    private static Set<String> basicShapingFeatures;
    private static final String[] basicShapingFeatureStrings;
    private static Set<String> presentationFeatures;
    private static final String[] presentationFeatureStrings;

    public static ScriptProcessor makeProcessor(String string) {
        switch (CharScript.scriptCodeFromTag(string)) {
            case 315: 
            case 1315: {
                return new DevanagariScriptProcessor(string);
            }
            case 320: 
            case 1320: {
                return new GujaratiScriptProcessor(string);
            }
            case 310: 
            case 1310: {
                return new GurmukhiScriptProcessor(string);
            }
        }
        return new IndicScriptProcessor(string);
    }

    IndicScriptProcessor(String string) {
        super(string);
    }

    @Override
    public String[] getSubstitutionFeatures() {
        return gsubReqFeatures;
    }

    @Override
    public String[] getOptionalSubstitutionFeatures() {
        return gsubOptFeatures;
    }

    @Override
    public ScriptContextTester getSubstitutionContextTester() {
        return this.subContextTester;
    }

    @Override
    public String[] getPositioningFeatures() {
        return gposReqFeatures;
    }

    @Override
    public String[] getOptionalPositioningFeatures() {
        return gposOptFeatures;
    }

    @Override
    public ScriptContextTester getPositioningContextTester() {
        return this.posContextTester;
    }

    @Override
    public GlyphSequence substitute(GlyphSequence glyphSequence, String string, String string2, GlyphTable.UseSpec[] useSpecArray, ScriptContextTester scriptContextTester) {
        assert (useSpecArray != null);
        GlyphSequence[] glyphSequenceArray = this.syllabize(glyphSequence, string, string2);
        int n = glyphSequenceArray.length;
        for (int i = 0; i < n; ++i) {
            GlyphSequence glyphSequence2 = glyphSequenceArray[i];
            for (GlyphTable.UseSpec useSpec : useSpecArray) {
                if (!this.isBasicShapingUse(useSpec)) continue;
                glyphSequence2.setPredications(true);
                glyphSequence2 = useSpec.substitute(glyphSequence2, string, string2, scriptContextTester);
            }
            glyphSequence2 = this.reorderPreBaseMatra(glyphSequence2);
            glyphSequence2 = this.reorderReph(glyphSequence2);
            int n2 = useSpecArray.length;
            for (int j = 0; j < n2; ++j) {
                GlyphTable.UseSpec useSpec;
                useSpec = useSpecArray[j];
                if (!this.isPresentationUse(useSpec)) continue;
                glyphSequence2.setPredications(true);
                glyphSequence2 = useSpec.substitute(glyphSequence2, string, string2, scriptContextTester);
            }
            glyphSequenceArray[i] = glyphSequence2;
        }
        return this.unsyllabize(glyphSequence, glyphSequenceArray);
    }

    protected Class<? extends Syllabizer> getSyllabizerClass() {
        return null;
    }

    private GlyphSequence[] syllabize(GlyphSequence glyphSequence, String string, String string2) {
        return Syllabizer.getSyllabizer(string, string2, this.getSyllabizerClass()).syllabize(glyphSequence);
    }

    private GlyphSequence unsyllabize(GlyphSequence glyphSequence, GlyphSequence[] glyphSequenceArray) {
        return GlyphSequence.join(glyphSequence, glyphSequenceArray);
    }

    private boolean isBasicShapingUse(GlyphTable.UseSpec useSpec) {
        assert (useSpec != null);
        if (basicShapingFeatures != null) {
            return basicShapingFeatures.contains(useSpec.getFeature());
        }
        return false;
    }

    private boolean isPresentationUse(GlyphTable.UseSpec useSpec) {
        assert (useSpec != null);
        if (presentationFeatures != null) {
            return presentationFeatures.contains(useSpec.getFeature());
        }
        return false;
    }

    private GlyphSequence reorderPreBaseMatra(GlyphSequence glyphSequence) {
        int n;
        int n2 = this.findPreBaseMatra(glyphSequence);
        if (n2 >= 0 && (n = this.findPreBaseMatraTarget(glyphSequence, n2)) >= 0 && n != n2) {
            glyphSequence = this.reorder(glyphSequence, n2, n);
        }
        return glyphSequence;
    }

    protected int findPreBaseMatra(GlyphSequence glyphSequence) {
        return -1;
    }

    protected int findPreBaseMatraTarget(GlyphSequence glyphSequence, int n) {
        return -1;
    }

    private GlyphSequence reorderReph(GlyphSequence glyphSequence) {
        int n;
        int n2 = this.findReph(glyphSequence);
        if (n2 >= 0 && (n = this.findRephTarget(glyphSequence, n2)) >= 0 && n != n2) {
            glyphSequence = this.reorder(glyphSequence, n2, n);
        }
        return glyphSequence;
    }

    protected int findReph(GlyphSequence glyphSequence) {
        return -1;
    }

    protected int findRephTarget(GlyphSequence glyphSequence, int n) {
        return -1;
    }

    private GlyphSequence reorder(GlyphSequence glyphSequence, int n, int n2) {
        return GlyphSequence.reorder(glyphSequence, n, 1, n2);
    }

    @Override
    public boolean position(GlyphSequence glyphSequence, String string, String string2, int n, GlyphTable.UseSpec[] useSpecArray, int[] nArray, int[][] nArray2, ScriptContextTester scriptContextTester) {
        boolean bl = super.position(glyphSequence, string, string2, n, useSpecArray, nArray, nArray2, scriptContextTester);
        return bl;
    }

    static {
        basicShapingFeatureStrings = new String[]{"abvf", "akhn", "blwf", "cjct", "half", "locl", "nukt", "pref", "pstf", "rkrf", "rphf", "vatu"};
        basicShapingFeatures = new HashSet<String>();
        for (String string : basicShapingFeatureStrings) {
            basicShapingFeatures.add(string);
        }
        presentationFeatureStrings = new String[]{"abvs", "blws", "calt", "haln", "pres", "psts"};
        presentationFeatures = new HashSet<String>();
        for (String string : presentationFeatureStrings) {
            presentationFeatures.add(string);
        }
    }

    protected static class Segment {
        static final int OTHER = 0;
        static final int SYLLABLE = 1;
        private int start;
        private int end;
        private int type;

        Segment(int n, int n2, int n3) {
            this.start = n;
            this.end = n2;
            this.type = n3;
        }

        int getStart() {
            return this.start;
        }

        int getEnd() {
            return this.end;
        }

        int getOffset() {
            return this.start;
        }

        int getCount() {
            return this.end - this.start;
        }

        int getType() {
            return this.type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DefaultSyllabizer
    extends Syllabizer {
        DefaultSyllabizer(String string, String string2) {
            super(string, string2);
        }

        @Override
        GlyphSequence[] syllabize(GlyphSequence glyphSequence) {
            int[] nArray = glyphSequence.getCharacterArray(false);
            int n = glyphSequence.getCharacterCount();
            if (n == 0) {
                return new GlyphSequence[]{glyphSequence};
            }
            return this.segmentize(glyphSequence, this.segmentize(nArray, n));
        }

        protected Segment[] segmentize(int[] nArray, int n) {
            Vector<Segment> vector = new Vector<Segment>(n);
            int n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                int n4 = this.findStartOfSyllable(nArray, n2, n3);
                if (n4 > n2) {
                    vector.add(new Segment(n2, n4, 0));
                    n2 = n4;
                } else if (n4 > n2) {
                    vector.add(new Segment(n2, n3, 0));
                    n2 = n3;
                }
                n4 = this.findEndOfSyllable(nArray, n2, n3);
                if (n4 > n2) {
                    vector.add(new Segment(n2, n4, 1));
                    n2 = n4;
                    continue;
                }
                vector.add(new Segment(n2, n3, 0));
                n2 = n3;
            }
            return vector.toArray(new Segment[vector.size()]);
        }

        protected GlyphSequence[] segmentize(GlyphSequence glyphSequence, Segment[] segmentArray) {
            int n = glyphSequence.getGlyphCount();
            int[] nArray = glyphSequence.getGlyphArray(false);
            GlyphSequence.CharAssociation[] charAssociationArray = glyphSequence.getAssociations(0, -1);
            Vector<GlyphSequence> vector = new Vector<GlyphSequence>();
            for (Segment segment : segmentArray) {
                Vector<Integer> vector2 = new Vector<Integer>(n);
                Vector<GlyphSequence.CharAssociation> vector3 = new Vector<GlyphSequence.CharAssociation>(n);
                for (int i = 0; i < n; ++i) {
                    GlyphSequence.CharAssociation charAssociation = charAssociationArray[i];
                    if (!charAssociation.contained(segment.getOffset(), segment.getCount())) continue;
                    vector2.add(nArray[i]);
                    vector3.add(charAssociation);
                }
                if (vector2.size() <= 0) continue;
                vector.add(new GlyphSequence(glyphSequence, null, DefaultSyllabizer.toIntArray(vector2), null, null, vector3.toArray(new GlyphSequence.CharAssociation[vector3.size()]), null));
            }
            if (vector.size() > 0) {
                return vector.toArray(new GlyphSequence[vector.size()]);
            }
            return new GlyphSequence[]{glyphSequence};
        }

        protected int findStartOfSyllable(int[] nArray, int n, int n2) {
            return n2;
        }

        protected int findEndOfSyllable(int[] nArray, int n, int n2) {
            return n;
        }

        private static int[] toIntArray(Vector<Integer> vector) {
            int n = vector.size();
            int[] nArray = new int[vector.size()];
            int n2 = n;
            for (int i = 0; i < n2; ++i) {
                nArray[i] = vector.get(i);
            }
            return nArray;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class Syllabizer
    implements Comparable {
        private String script;
        private String language;
        private static Map<String, Syllabizer> syllabizers = new HashMap<String, Syllabizer>();

        Syllabizer(String string, String string2) {
            this.script = string;
            this.language = string2;
        }

        abstract GlyphSequence[] syllabize(GlyphSequence var1);

        public int hashCode() {
            int n = 0;
            n = 7 * n + (n ^ this.script.hashCode());
            n = 11 * n + (n ^ this.language.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (object instanceof Syllabizer) {
                Syllabizer syllabizer = (Syllabizer)object;
                if (!syllabizer.script.equals(this.script)) {
                    return false;
                }
                return syllabizer.language.equals(this.language);
            }
            return false;
        }

        public int compareTo(Object object) {
            int n;
            if (object instanceof Syllabizer) {
                Syllabizer syllabizer = (Syllabizer)object;
                n = this.script.compareTo(syllabizer.script);
                if (n == 0) {
                    n = this.language.compareTo(syllabizer.language);
                }
            } else {
                n = -1;
            }
            return n;
        }

        static Syllabizer getSyllabizer(String string, String string2, Class<? extends Syllabizer> clazz) {
            String string3 = Syllabizer.makeSyllabizerId(string, string2);
            Syllabizer syllabizer = syllabizers.get(string3);
            if (syllabizer == null) {
                syllabizer = Syllabizer.makeSyllabizer(string, string2, clazz);
                if (syllabizer == null) {
                    syllabizer = new DefaultSyllabizer(string, string2);
                }
                syllabizers.put(string3, syllabizer);
            }
            return syllabizer;
        }

        static String makeSyllabizerId(String string, String string2) {
            return string + ":" + string2;
        }

        static Syllabizer makeSyllabizer(String string, String string2, Class<? extends Syllabizer> clazz) {
            Syllabizer syllabizer;
            try {
                Constructor<? extends Syllabizer> constructor = clazz.getDeclaredConstructor(String.class, String.class);
                syllabizer = constructor.newInstance(string, string2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                syllabizer = null;
            }
            catch (InstantiationException instantiationException) {
                syllabizer = null;
            }
            catch (IllegalAccessException illegalAccessException) {
                syllabizer = null;
            }
            catch (InvocationTargetException invocationTargetException) {
                syllabizer = null;
            }
            return syllabizer;
        }
    }

    private static class PositioningScriptContextTester
    implements ScriptContextTester {
        private static Map testerMap = new HashMap();

        private PositioningScriptContextTester() {
        }

        public GlyphContextTester getTester(String string) {
            return (GlyphContextTester)testerMap.get(string);
        }
    }

    private static class SubstitutionScriptContextTester
    implements ScriptContextTester {
        private static Map testerMap = new HashMap();

        private SubstitutionScriptContextTester() {
        }

        public GlyphContextTester getTester(String string) {
            return (GlyphContextTester)testerMap.get(string);
        }
    }
}

