/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.events.model;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.fop.events.model.EventProducerModel;
import org.apache.xmlgraphics.util.XMLizable;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class EventModel
implements Serializable,
XMLizable {
    private static final long serialVersionUID = 7468592614934605082L;
    private Map producers = new LinkedHashMap();

    public void addProducer(EventProducerModel eventProducerModel) {
        this.producers.put(eventProducerModel.getInterfaceName(), eventProducerModel);
    }

    public Iterator getProducers() {
        return this.producers.values().iterator();
    }

    public EventProducerModel getProducer(String string) {
        return (EventProducerModel)this.producers.get(string);
    }

    public EventProducerModel getProducer(Class clazz) {
        return this.getProducer(clazz.getName());
    }

    public void toSAX(ContentHandler contentHandler) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        String string = "event-model";
        contentHandler.startElement("", string, string, attributesImpl);
        Iterator iterator = this.getProducers();
        while (iterator.hasNext()) {
            ((XMLizable)iterator.next()).toSAX(contentHandler);
        }
        contentHandler.endElement("", string, string);
    }

    private void writeXMLizable(XMLizable xMLizable, File file) throws IOException {
        OutputStream outputStream = new FileOutputStream(file);
        outputStream = new BufferedOutputStream(outputStream);
        StreamResult streamResult = new StreamResult(outputStream);
        try {
            SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            TransformerHandler transformerHandler = sAXTransformerFactory.newTransformerHandler();
            Transformer transformer = transformerHandler.getTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformerHandler.setResult(streamResult);
            transformerHandler.startDocument();
            xMLizable.toSAX((ContentHandler)transformerHandler);
            transformerHandler.endDocument();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new IOException(transformerConfigurationException.getMessage());
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            throw new IOException(transformerFactoryConfigurationError.getMessage());
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException.getMessage());
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }

    public void saveToXML(File file) throws IOException {
        this.writeXMLizable(this, file);
    }
}

