/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.accessibility.StructureTreeElement;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.complexscripts.bidi.DelimitedTextRange;
import org.apache.fop.fo.CharIterator;
import org.apache.fop.fo.FOEventHandler;
import org.apache.fop.fo.FOTreeBuilderContext;
import org.apache.fop.fo.FOValidationEventProducer;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.OneCharIterator;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.extensions.ExtensionAttachment;
import org.apache.fop.fo.pagination.Root;
import org.apache.fop.util.ContentHandlerFactory;
import org.apache.fop.util.text.AdvancedMessageFormat;
import org.apache.xmlgraphics.util.QName;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.helpers.LocatorImpl;

public abstract class FONode
implements Cloneable {
    protected static final String FO_URI = "http://www.w3.org/1999/XSL/Format";
    protected static final String FOX_URI = "http://xmlgraphics.apache.org/fop/extensions";
    protected FONode parent;
    protected FONode[] siblings;
    protected Locator locator;
    protected static final Log log = LogFactory.getLog(FONode.class);

    protected FONode(FONode fONode) {
        this.parent = fONode;
    }

    public FONode clone(FONode fONode, boolean bl) throws FOPException {
        FONode fONode2 = (FONode)this.clone();
        fONode2.parent = fONode;
        fONode2.siblings = null;
        return fONode2;
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
    }

    public void bind(PropertyList propertyList) throws FOPException {
    }

    public void setLocator(Locator locator) {
        if (locator != null) {
            this.locator = new LocatorImpl(locator);
        }
    }

    public Locator getLocator() {
        return this.locator;
    }

    public FOEventHandler getFOEventHandler() {
        return this.parent.getFOEventHandler();
    }

    public FOTreeBuilderContext getBuilderContext() {
        return this.parent.getBuilderContext();
    }

    protected boolean inMarker() {
        return this.getBuilderContext().inMarker();
    }

    public FOUserAgent getUserAgent() {
        return this.getFOEventHandler().getUserAgent();
    }

    public Log getLogger() {
        return log;
    }

    public void processNode(String string, Locator locator, Attributes attributes, PropertyList propertyList) throws FOPException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unhandled element: " + string + (locator != null ? " at " + FONode.getLocatorString(locator) : "")));
        }
    }

    protected PropertyList createPropertyList(PropertyList propertyList, FOEventHandler fOEventHandler) throws FOPException {
        return null;
    }

    protected void validateChildNode(Locator locator, String string, String string2) throws ValidationException {
    }

    protected static void validateChildNode(FONode fONode, Locator locator, String string, String string2) throws ValidationException {
        fONode.validateChildNode(locator, string, string2);
    }

    protected void addCharacters(char[] cArray, int n, int n2, PropertyList propertyList, Locator locator) throws FOPException {
    }

    protected void characters(char[] cArray, int n, int n2, PropertyList propertyList, Locator locator) throws FOPException {
        this.addCharacters(cArray, n, n + n2, propertyList, locator);
    }

    protected void startOfNode() throws FOPException {
    }

    protected void endOfNode() throws FOPException {
        this.finalizeNode();
    }

    protected void addChildNode(FONode fONode) throws FOPException {
    }

    public void removeChild(FONode fONode) {
    }

    public void finalizeNode() throws FOPException {
    }

    public FONode getParent() {
        return this.parent;
    }

    public FONodeIterator getChildNodes() {
        return null;
    }

    public FONodeIterator getChildNodes(FONode fONode) {
        return null;
    }

    public CharIterator charIterator() {
        return new OneCharIterator('\u0000');
    }

    public static String getNodePrefix(String string) {
        if (string.equals(FO_URI)) {
            return "fo";
        }
        if (string.equals(FOX_URI)) {
            return "fox";
        }
        if (string.equals("http://xmlgraphics.apache.org/fop/internal")) {
            return "foi";
        }
        if (string.equals("http://www.w3.org/2000/svg")) {
            return "svg";
        }
        return null;
    }

    public static String getNodeString(String string, String string2) {
        String string3 = FONode.getNodePrefix(string);
        if (string3 != null) {
            return string3 + ":" + string2;
        }
        return "(Namespace URI: \"" + string + "\", " + "Local Name: \"" + string2 + "\")";
    }

    protected FOValidationEventProducer getFOValidationEventProducer() {
        return FOValidationEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
    }

    protected void tooManyNodesError(Locator locator, String string, String string2) throws ValidationException {
        this.tooManyNodesError(locator, new QName(string, string2));
    }

    protected void tooManyNodesError(Locator locator, QName qName) throws ValidationException {
        this.getFOValidationEventProducer().tooManyNodes(this, this.getName(), qName, locator);
    }

    protected void tooManyNodesError(Locator locator, String string) throws ValidationException {
        this.tooManyNodesError(locator, new QName(FO_URI, string));
    }

    protected void nodesOutOfOrderError(Locator locator, String string, String string2) throws ValidationException {
        this.nodesOutOfOrderError(locator, string, string2, false);
    }

    protected void nodesOutOfOrderError(Locator locator, String string, String string2, boolean bl) throws ValidationException {
        this.getFOValidationEventProducer().nodeOutOfOrder(this, this.getName(), string, string2, bl, locator);
    }

    protected void invalidChildError(Locator locator, String string, String string2) throws ValidationException {
        this.invalidChildError(locator, this.getName(), string, string2, null);
    }

    protected void invalidChildError(Locator locator, String string, String string2, String string3, String string4) throws ValidationException {
        String string5 = FONode.getNodePrefix(string2);
        QName qName = string5 != null ? new QName(string2, string5, string3) : new QName(string2, string3);
        this.getFOValidationEventProducer().invalidChild(this, string, qName, string4, locator);
    }

    protected void missingChildElementError(String string) throws ValidationException {
        this.getFOValidationEventProducer().missingChildElement(this, this.getName(), string, false, this.locator);
    }

    protected void missingChildElementError(String string, boolean bl) throws ValidationException {
        this.getFOValidationEventProducer().missingChildElement(this, this.getName(), string, bl, this.locator);
    }

    protected void missingPropertyError(String string) throws ValidationException {
        this.getFOValidationEventProducer().missingProperty(this, this.getName(), string, this.locator);
    }

    protected static String errorText(Locator locator) {
        return "Error(" + FONode.getLocatorString(locator) + "): ";
    }

    protected static String warningText(Locator locator) {
        return "Warning(" + FONode.getLocatorString(locator) + "): ";
    }

    public static String getLocatorString(Locator locator) {
        if (locator == null) {
            return "Unknown location";
        }
        return locator.getLineNumber() + "/" + locator.getColumnNumber();
    }

    public static String decorateWithContextInfo(String string, FONode fONode) {
        if (fONode != null) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(" (").append(fONode.getContextInfo()).append(")");
            return stringBuffer.toString();
        }
        return string;
    }

    public String getContextInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getLocalName() != null) {
            stringBuffer.append(this.getName());
            stringBuffer.append(", ");
        }
        if (this.locator != null) {
            stringBuffer.append("location: ");
            stringBuffer.append(FONode.getLocatorString(this.locator));
        } else {
            String string = this.gatherContextInfo();
            if (string != null) {
                stringBuffer.append("\"");
                stringBuffer.append(string);
                stringBuffer.append("\"");
            } else {
                stringBuffer.append("no context info available");
            }
        }
        if (stringBuffer.length() > 80) {
            stringBuffer.setLength(80);
        }
        return stringBuffer.toString();
    }

    protected String getContextInfoAlt() {
        String string = this.gatherContextInfo();
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.getLocalName() != null) {
                stringBuffer.append(this.getName());
                stringBuffer.append(", ");
            }
            stringBuffer.append("\"");
            stringBuffer.append(string);
            stringBuffer.append("\"");
            return stringBuffer.toString();
        }
        return null;
    }

    protected String gatherContextInfo() {
        return null;
    }

    public Root getRoot() {
        return this.parent.getRoot();
    }

    public String getName() {
        return this.getName(this.getNormalNamespacePrefix());
    }

    public String getName(String string) {
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string).append(':').append(this.getLocalName());
            return stringBuffer.toString();
        }
        return this.getLocalName();
    }

    public abstract String getLocalName();

    public abstract String getNormalNamespacePrefix();

    public String getNamespaceURI() {
        return null;
    }

    public int getNameId() {
        return 0;
    }

    public ExtensionAttachment getExtensionAttachment() {
        return null;
    }

    public ContentHandlerFactory getContentHandlerFactory() {
        return null;
    }

    protected boolean canHaveMarkers() {
        int n = this.getNameId();
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 16: 
            case 35: 
            case 36: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 81: {
                return true;
            }
        }
        return false;
    }

    protected static void attachSiblings(FONode fONode, FONode fONode2) {
        if (fONode.siblings == null) {
            fONode.siblings = new FONode[2];
        }
        if (fONode2.siblings == null) {
            fONode2.siblings = new FONode[2];
        }
        fONode.siblings[1] = fONode2;
        fONode2.siblings[0] = fONode;
    }

    public boolean isDelimitedTextRangeBoundary(int n) {
        return true;
    }

    public Stack collectDelimitedTextRanges(Stack stack) {
        if (this.isRangeBoundaryBefore()) {
            this.maybeNewRange(stack);
        }
        DelimitedTextRange delimitedTextRange = stack.size() > 0 ? (DelimitedTextRange)stack.peek() : null;
        stack = this.collectDelimitedTextRanges(stack, delimitedTextRange);
        if (this.isRangeBoundaryAfter()) {
            this.maybeNewRange(stack);
        }
        return stack;
    }

    protected Stack collectDelimitedTextRanges(Stack stack, DelimitedTextRange delimitedTextRange) {
        FONodeIterator fONodeIterator = this.getChildNodes();
        while (fONodeIterator != null && fONodeIterator.hasNext()) {
            stack = ((FONode)fONodeIterator.next()).collectDelimitedTextRanges(stack);
        }
        return stack;
    }

    public boolean isBidiRangeBlockItem() {
        return false;
    }

    private DelimitedTextRange maybeNewRange(Stack stack) {
        DelimitedTextRange delimitedTextRange = null;
        DelimitedTextRange delimitedTextRange2 = null;
        if (stack.empty()) {
            if (this.isBidiRangeBlockItem()) {
                delimitedTextRange2 = new DelimitedTextRange(this);
            }
        } else {
            delimitedTextRange = (DelimitedTextRange)stack.peek();
            if (!(delimitedTextRange == null || delimitedTextRange.isEmpty() && FONode.isSelfOrDescendent(delimitedTextRange.getNode(), this))) {
                delimitedTextRange2 = new DelimitedTextRange(this);
            }
        }
        if (delimitedTextRange2 != null) {
            stack.push(delimitedTextRange2);
        } else {
            delimitedTextRange2 = delimitedTextRange;
        }
        return delimitedTextRange2;
    }

    private boolean isRangeBoundaryBefore() {
        return this.isDelimitedTextRangeBoundary(13);
    }

    private boolean isRangeBoundaryAfter() {
        return this.isDelimitedTextRangeBoundary(3);
    }

    private static boolean isSelfOrDescendent(FONode fONode, FONode fONode2) {
        for (FONode fONode3 = fONode2; fONode3 != null; fONode3 = fONode3.getParent()) {
            if (fONode3 != fONode) continue;
            return true;
        }
        return false;
    }

    public void setStructureTreeElement(StructureTreeElement structureTreeElement) {
        throw new UnsupportedOperationException();
    }

    public static interface FONodeIterator
    extends ListIterator {
        public FObj parentNode();

        public FONode nextNode();

        public FONode previousNode();

        public FONode firstNode();

        public FONode lastNode();
    }

    public static class GatherContextInfoFunction
    implements AdvancedMessageFormat.Function {
        public Object evaluate(Map map) {
            Object object;
            Object object2 = map.get("source");
            if (object2 instanceof PropertyList) {
                object = (PropertyList)object2;
                object2 = ((PropertyList)object).getFObj();
            }
            if (object2 instanceof FONode) {
                object = (FONode)object2;
                return ((FONode)object).getContextInfoAlt();
            }
            return null;
        }

        public Object getName() {
            return "gatherContextInfo";
        }
    }
}

