/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.accessibility.fo.FO2StructureTreeConverter;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.FormattingResults;
import org.apache.fop.fo.ElementMapping;
import org.apache.fop.fo.ElementMappingRegistry;
import org.apache.fop.fo.FOEventHandler;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FOTreeBuilderContext;
import org.apache.fop.fo.FOValidationEventProducer;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.PropertyListMaker;
import org.apache.fop.fo.StaticPropertyList;
import org.apache.fop.fo.UnknownXMLObj;
import org.apache.fop.fo.pagination.Root;
import org.apache.fop.util.ContentHandlerFactory;
import org.apache.xmlgraphics.util.QName;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class FOTreeBuilder
extends DefaultHandler {
    private static final Log LOG = LogFactory.getLog(FOTreeBuilder.class);
    protected ElementMappingRegistry elementMappingRegistry;
    protected Root rootFObj = null;
    protected MainFOHandler mainFOHandler;
    protected ContentHandler delegate;
    private FOTreeBuilderContext builderContext;
    private FOEventHandler foEventHandler;
    private Locator locator;
    private FOUserAgent userAgent;
    private boolean used = false;
    private boolean empty = true;
    private int depth;

    public FOTreeBuilder(String string, FOUserAgent fOUserAgent, OutputStream outputStream) throws FOPException {
        this.userAgent = fOUserAgent;
        this.elementMappingRegistry = this.userAgent.getFactory().getElementMappingRegistry();
        this.foEventHandler = fOUserAgent.getRendererFactory().createFOEventHandler(fOUserAgent, string, outputStream);
        if (this.userAgent.isAccessibilityEnabled()) {
            this.foEventHandler = new FO2StructureTreeConverter(fOUserAgent.getStructureTreeEventHandler(), this.foEventHandler);
        }
        this.builderContext = new FOTreeBuilderContext();
        this.builderContext.setPropertyListMaker(new PropertyListMaker(){

            public PropertyList make(FObj fObj, PropertyList propertyList) {
                return new StaticPropertyList(fObj, propertyList);
            }
        });
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    protected Locator getEffectiveLocator() {
        return this.userAgent.isLocatorEnabled() ? this.locator : null;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.delegate.characters(cArray, n, n2);
    }

    public void startDocument() throws SAXException {
        if (this.used) {
            throw new IllegalStateException("FOTreeBuilder (and the Fop class) cannot be reused. Please instantiate a new instance.");
        }
        this.used = true;
        this.empty = true;
        this.rootFObj = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Building formatting object tree");
        }
        this.foEventHandler.startDocument();
        this.mainFOHandler = new MainFOHandler();
        this.mainFOHandler.startDocument();
        this.delegate = this.mainFOHandler;
    }

    public void endDocument() throws SAXException {
        this.delegate.endDocument();
        if (this.rootFObj == null && this.empty) {
            FOValidationEventProducer fOValidationEventProducer = FOValidationEventProducer.Provider.get(this.userAgent.getEventBroadcaster());
            fOValidationEventProducer.emptyDocument(this);
        }
        this.rootFObj = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Parsing of document complete");
        }
        this.foEventHandler.endDocument();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        ++this.depth;
        this.delegate.startElement(string, string2, string3, attributes);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.delegate.endElement(string, string2, string3);
        --this.depth;
        if (this.depth == 0 && this.delegate != this.mainFOHandler) {
            this.delegate.endDocument();
            this.delegate = this.mainFOHandler;
            this.delegate.endElement(string, string2, string3);
        }
    }

    public void warning(SAXParseException sAXParseException) {
        LOG.warn((Object)sAXParseException.getLocalizedMessage());
    }

    public void error(SAXParseException sAXParseException) {
        LOG.error((Object)sAXParseException.toString());
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        LOG.error((Object)sAXParseException.toString());
        throw sAXParseException;
    }

    public FOEventHandler getEventHandler() {
        return this.foEventHandler;
    }

    public FormattingResults getResults() {
        return this.getEventHandler().getResults();
    }

    private class MainFOHandler
    extends DefaultHandler {
        protected FONode currentFObj = null;
        protected PropertyList currentPropertyList;
        private int nestedMarkerDepth = 0;

        private MainFOHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            FONode fONode;
            Object object;
            PropertyList propertyList = null;
            if (FOTreeBuilder.this.rootFObj == null) {
                FOTreeBuilder.this.empty = false;
                if (!string.equals("http://www.w3.org/1999/XSL/Format") || !string2.equals("root")) {
                    object = FOValidationEventProducer.Provider.get(FOTreeBuilder.this.userAgent.getEventBroadcaster());
                    object.invalidFORoot(this, FONode.getNodeString(string, string2), FOTreeBuilder.this.getEffectiveLocator());
                }
            } else if (this.currentFObj.getNamespaceURI().equals("http://www.w3.org/1999/XSL/Format") || this.currentFObj.getNamespaceURI().equals("http://xmlgraphics.apache.org/fop/extensions")) {
                this.currentFObj.validateChildNode(FOTreeBuilder.this.locator, string, string2);
            }
            object = this.findFOMaker(string, string2);
            try {
                fONode = ((ElementMapping.Maker)object).make(this.currentFObj);
                if (FOTreeBuilder.this.rootFObj == null) {
                    FOTreeBuilder.this.rootFObj = (Root)fONode;
                    FOTreeBuilder.this.rootFObj.setBuilderContext(FOTreeBuilder.this.builderContext);
                    FOTreeBuilder.this.rootFObj.setFOEventHandler(FOTreeBuilder.this.foEventHandler);
                }
                propertyList = fONode.createPropertyList(this.currentPropertyList, FOTreeBuilder.this.foEventHandler);
                fONode.processNode(string2, FOTreeBuilder.this.getEffectiveLocator(), attributes, propertyList);
                if (fONode.getNameId() == 44) {
                    if (FOTreeBuilder.this.builderContext.inMarker()) {
                        ++this.nestedMarkerDepth;
                    } else {
                        FOTreeBuilder.this.builderContext.switchMarkerContext(true);
                    }
                }
                if (fONode.getNameId() == 53) {
                    FOTreeBuilder.this.builderContext.getXMLWhiteSpaceHandler().reset();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new SAXException(illegalArgumentException);
            }
            ContentHandlerFactory contentHandlerFactory = fONode.getContentHandlerFactory();
            if (contentHandlerFactory != null) {
                ContentHandler contentHandler = contentHandlerFactory.createContentHandler();
                if (contentHandler instanceof ContentHandlerFactory.ObjectSource && fONode instanceof ContentHandlerFactory.ObjectBuiltListener) {
                    ((ContentHandlerFactory.ObjectSource)((Object)contentHandler)).setObjectBuiltListener((ContentHandlerFactory.ObjectBuiltListener)((Object)fONode));
                }
                contentHandler.startDocument();
                contentHandler.startElement(string, string2, string3, attributes);
                FOTreeBuilder.this.depth = 1;
                FOTreeBuilder.this.delegate = contentHandler;
            }
            if (this.currentFObj != null) {
                this.currentFObj.addChildNode(fONode);
            }
            this.currentFObj = fONode;
            if (propertyList != null && !FOTreeBuilder.this.builderContext.inMarker()) {
                this.currentPropertyList = propertyList;
            }
            if (this.currentFObj.getNameId() != 10) {
                this.currentFObj.startOfNode();
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.currentFObj == null) {
                throw new SAXException("endElement() called for " + string3 + " where there is no current element.");
            }
            if (!this.currentFObj.getLocalName().equals(string2) || !this.currentFObj.getNamespaceURI().equals(string)) {
                throw new SAXException("Mismatch: " + this.currentFObj.getLocalName() + " (" + this.currentFObj.getNamespaceURI() + ") vs. " + string2 + " (" + string + ")");
            }
            if (this.currentFObj.getNameId() != 10) {
                this.currentFObj.endOfNode();
            }
            if (this.currentPropertyList != null && this.currentPropertyList.getFObj() == this.currentFObj && !FOTreeBuilder.this.builderContext.inMarker()) {
                this.currentPropertyList = this.currentPropertyList.getParentPropertyList();
            }
            if (this.currentFObj.getNameId() == 44) {
                if (this.nestedMarkerDepth == 0) {
                    FOTreeBuilder.this.builderContext.switchMarkerContext(false);
                } else {
                    --this.nestedMarkerDepth;
                }
            }
            if (this.currentFObj.getParent() == null) {
                LOG.debug((Object)("endElement for top-level " + this.currentFObj.getName()));
            }
            this.currentFObj = this.currentFObj.getParent();
        }

        public void characters(char[] cArray, int n, int n2) throws FOPException {
            if (this.currentFObj != null) {
                this.currentFObj.characters(cArray, n, n2, this.currentPropertyList, FOTreeBuilder.this.getEffectiveLocator());
            }
        }

        public void endDocument() throws SAXException {
            this.currentFObj = null;
        }

        private ElementMapping.Maker findFOMaker(String string, String string2) throws FOPException {
            ElementMapping.Maker maker = FOTreeBuilder.this.elementMappingRegistry.findFOMaker(string, string2, FOTreeBuilder.this.locator);
            if (maker instanceof UnknownXMLObj.Maker) {
                FOValidationEventProducer fOValidationEventProducer = FOValidationEventProducer.Provider.get(FOTreeBuilder.this.userAgent.getEventBroadcaster());
                String string3 = this.currentFObj != null ? this.currentFObj.getName() : "{" + string + "}" + string2;
                fOValidationEventProducer.unknownFormattingObject(this, string3, new QName(string, string2), FOTreeBuilder.this.getEffectiveLocator());
            }
            return maker;
        }
    }
}

