/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.awt.Color;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.fo.CharIterator;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObjMixed;
import org.apache.fop.fo.NullCharIterator;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.properties.BreakPropertySet;
import org.apache.fop.fo.properties.CommonAccessibility;
import org.apache.fop.fo.properties.CommonAccessibilityHolder;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonFont;
import org.apache.fop.fo.properties.CommonHyphenation;
import org.apache.fop.fo.properties.CommonMarginBlock;
import org.apache.fop.fo.properties.CommonRelativePosition;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fo.properties.SpaceProperty;
import org.xml.sax.Locator;

public class Block
extends FObjMixed
implements BreakPropertySet,
CommonAccessibilityHolder {
    private boolean blockOrInlineItemFound = false;
    private boolean initialPropertySetFound = false;
    private CommonAccessibility commonAccessibility;
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private CommonFont commonFont;
    private CommonHyphenation commonHyphenation;
    private CommonMarginBlock commonMarginBlock;
    private CommonRelativePosition commonRelativePosition;
    private int breakAfter;
    private int breakBefore;
    private Color color;
    private int hyphenationKeep;
    private Numeric hyphenationLadderCount;
    private int intrusionDisplace;
    private KeepProperty keepTogether;
    private KeepProperty keepWithNext;
    private KeepProperty keepWithPrevious;
    private Length lastLineEndIndent;
    private int linefeedTreatment;
    private SpaceProperty lineHeight;
    private int lineHeightShiftAdjustment;
    private int lineStackingStrategy;
    private Numeric orphans;
    private int whiteSpaceTreatment;
    private int span;
    private int textAlign;
    private int textAlignLast;
    private Length textIndent;
    private int whiteSpaceCollapse;
    private Numeric widows;
    private int wrapOption;
    private int disableColumnBalancing;

    public Block(FONode fONode) {
        super(fONode);
    }

    public void bind(PropertyList propertyList) throws FOPException {
        super.bind(propertyList);
        this.commonAccessibility = CommonAccessibility.getInstance(propertyList);
        this.commonBorderPaddingBackground = propertyList.getBorderPaddingBackgroundProps();
        this.commonFont = propertyList.getFontProps();
        this.commonHyphenation = propertyList.getHyphenationProps();
        this.commonMarginBlock = propertyList.getMarginBlockProps();
        this.commonRelativePosition = propertyList.getRelativePositionProps();
        this.breakAfter = propertyList.get(58).getEnum();
        this.breakBefore = propertyList.get(59).getEnum();
        this.color = propertyList.get(72).getColor(this.getUserAgent());
        this.hyphenationKeep = propertyList.get(118).getEnum();
        this.hyphenationLadderCount = propertyList.get(119).getNumeric();
        this.intrusionDisplace = propertyList.get(130).getEnum();
        this.keepTogether = propertyList.get(131).getKeep();
        this.keepWithNext = propertyList.get(132).getKeep();
        this.keepWithPrevious = propertyList.get(133).getKeep();
        this.lastLineEndIndent = propertyList.get(135).getLength();
        this.linefeedTreatment = propertyList.get(143).getEnum();
        this.lineHeight = propertyList.get(144).getSpace();
        this.lineHeightShiftAdjustment = propertyList.get(145).getEnum();
        this.lineStackingStrategy = propertyList.get(146).getEnum();
        this.orphans = propertyList.get(168).getNumeric();
        this.whiteSpaceTreatment = propertyList.get(262).getEnum();
        this.span = propertyList.get(226).getEnum();
        this.textAlign = propertyList.get(245).getEnum();
        this.textAlignLast = propertyList.get(246).getEnum();
        this.textIndent = propertyList.get(250).getLength();
        this.whiteSpaceCollapse = propertyList.get(261).getEnum();
        this.widows = propertyList.get(263).getNumeric();
        this.wrapOption = propertyList.get(266).getEnum();
        this.disableColumnBalancing = propertyList.get(273).getEnum();
    }

    protected void startOfNode() throws FOPException {
        super.startOfNode();
        this.getFOEventHandler().startBlock(this);
    }

    protected void endOfNode() throws FOPException {
        super.endOfNode();
        this.getFOEventHandler().endBlock(this);
    }

    public CommonAccessibility getCommonAccessibility() {
        return this.commonAccessibility;
    }

    public CommonMarginBlock getCommonMarginBlock() {
        return this.commonMarginBlock;
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public CommonFont getCommonFont() {
        return this.commonFont;
    }

    public CommonHyphenation getCommonHyphenation() {
        return this.commonHyphenation;
    }

    public int getBreakAfter() {
        return this.breakAfter;
    }

    public int getBreakBefore() {
        return this.breakBefore;
    }

    public Numeric getHyphenationLadderCount() {
        return this.hyphenationLadderCount;
    }

    public KeepProperty getKeepWithNext() {
        return this.keepWithNext;
    }

    public KeepProperty getKeepWithPrevious() {
        return this.keepWithPrevious;
    }

    public KeepProperty getKeepTogether() {
        return this.keepTogether;
    }

    public int getOrphans() {
        return this.orphans.getValue();
    }

    public int getWidows() {
        return this.widows.getValue();
    }

    public int getLineStackingStrategy() {
        return this.lineStackingStrategy;
    }

    public Color getColor() {
        return this.color;
    }

    public SpaceProperty getLineHeight() {
        return this.lineHeight;
    }

    public int getSpan() {
        return this.span;
    }

    public int getTextAlign() {
        return this.textAlign;
    }

    public int getTextAlignLast() {
        return this.textAlignLast;
    }

    public Length getTextIndent() {
        return this.textIndent;
    }

    public Length getLastLineEndIndent() {
        return this.lastLineEndIndent;
    }

    public int getWrapOption() {
        return this.wrapOption;
    }

    protected void validateChildNode(Locator locator, String string, String string2) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(string)) {
            if ("marker".equals(string2)) {
                if (this.blockOrInlineItemFound || this.initialPropertySetFound) {
                    this.nodesOutOfOrderError(locator, "fo:marker", "initial-property-set? (#PCDATA|%inline;|%block;)");
                }
            } else if ("initial-property-set".equals(string2)) {
                if (this.initialPropertySetFound) {
                    this.tooManyNodesError(locator, "fo:initial-property-set");
                } else if (this.blockOrInlineItemFound) {
                    this.nodesOutOfOrderError(locator, "fo:initial-property-set", "(#PCDATA|%inline;|%block;)");
                } else {
                    this.initialPropertySetFound = true;
                }
            } else if (this.isBlockOrInlineItem(string, string2)) {
                this.blockOrInlineItemFound = true;
            } else {
                this.invalidChildError(locator, string, string2);
            }
        }
    }

    public int getLinefeedTreatment() {
        return this.linefeedTreatment;
    }

    public int getWhitespaceTreatment() {
        return this.whiteSpaceTreatment;
    }

    public int getWhitespaceCollapse() {
        return this.whiteSpaceCollapse;
    }

    public CommonRelativePosition getCommonRelativePosition() {
        return this.commonRelativePosition;
    }

    public int getHyphenationKeep() {
        return this.hyphenationKeep;
    }

    public int getIntrusionDisplace() {
        return this.intrusionDisplace;
    }

    public int getLineHeightShiftAdjustment() {
        return this.lineHeightShiftAdjustment;
    }

    public int getDisableColumnBalancing() {
        return this.disableColumnBalancing;
    }

    public CharIterator charIterator() {
        return NullCharIterator.getInstance();
    }

    public String getLocalName() {
        return "block";
    }

    public int getNameId() {
        return 3;
    }
}

