/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.InlineLevel;
import org.xml.sax.Locator;

public class Inline
extends InlineLevel {
    private Length alignmentAdjust;
    private int alignmentBaseline;
    private Length baselineShift;
    private int dominantBaseline;
    private boolean blockOrInlineItemFound = false;
    private boolean canHaveBlockLevelChildren = true;

    public Inline(FONode fONode) {
        super(fONode);
    }

    public void bind(PropertyList propertyList) throws FOPException {
        super.bind(propertyList);
        this.alignmentAdjust = propertyList.get(3).getLength();
        this.alignmentBaseline = propertyList.get(4).getEnum();
        this.baselineShift = propertyList.get(15).getLength();
        this.dominantBaseline = propertyList.get(88).getEnum();
    }

    protected void startOfNode() throws FOPException {
        super.startOfNode();
        int n = this.findAncestor(39);
        int n2 = this.findAncestor(24);
        int n3 = this.findAncestor(36);
        if (n > 0) {
            if (n3 < 0 || n3 > 0 && n3 > n) {
                this.canHaveBlockLevelChildren = false;
            }
        } else if (n2 > 0 && (n3 < 0 || n3 > n2)) {
            this.canHaveBlockLevelChildren = false;
        }
        this.getFOEventHandler().startInline(this);
    }

    protected void endOfNode() throws FOPException {
        super.endOfNode();
        this.getFOEventHandler().endInline(this);
    }

    protected void validateChildNode(Locator locator, String string, String string2) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(string)) {
            if (string2.equals("marker")) {
                if (this.blockOrInlineItemFound) {
                    this.nodesOutOfOrderError(locator, "fo:marker", "(#PCDATA|%inline;|%block;)");
                }
            } else if (!this.isBlockOrInlineItem(string, string2)) {
                this.invalidChildError(locator, string, string2);
            } else if (!this.canHaveBlockLevelChildren && this.isBlockItem(string, string2) && !this.isNeutralItem(string, string2)) {
                this.invalidChildError(locator, this.getName(), string, string2, "rule.inlineContent");
            } else {
                this.blockOrInlineItemFound = true;
            }
        }
    }

    public Length getAlignmentAdjust() {
        return this.alignmentAdjust;
    }

    public int getAlignmentBaseline() {
        return this.alignmentBaseline;
    }

    public Length getBaselineShift() {
        return this.baselineShift;
    }

    public int getDominantBaseline() {
        return this.dominantBaseline;
    }

    public String getLocalName() {
        return "inline";
    }

    public int getNameId() {
        return 35;
    }
}

