/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow.table;

import java.util.List;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.flow.table.ColumnNumberManager;
import org.apache.fop.fo.flow.table.ColumnNumberManagerHolder;
import org.apache.fop.fo.flow.table.PendingSpan;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableCell;
import org.apache.fop.fo.flow.table.TableColumn;
import org.apache.fop.fo.flow.table.TableEventProducer;
import org.apache.fop.fo.flow.table.TableFObj;
import org.apache.fop.fo.flow.table.TablePart;
import org.apache.fop.fo.properties.CommonAccessibility;
import org.apache.fop.fo.properties.CommonAccessibilityHolder;

public abstract class TableCellContainer
extends TableFObj
implements ColumnNumberManagerHolder,
CommonAccessibilityHolder {
    private CommonAccessibility commonAccessibility;
    protected List pendingSpans;
    protected ColumnNumberManager columnNumberManager;

    public TableCellContainer(FONode fONode) {
        super(fONode);
    }

    public void bind(PropertyList propertyList) throws FOPException {
        super.bind(propertyList);
        this.commonAccessibility = CommonAccessibility.getInstance(propertyList);
    }

    protected void addTableCellChild(TableCell tableCell, boolean bl) throws FOPException {
        int n = tableCell.getColumnNumber();
        int n2 = tableCell.getNumberColumnsSpanned();
        int n3 = tableCell.getNumberRowsSpanned();
        Table table = this.getTable();
        if (table.hasExplicitColumns()) {
            if (n + n2 - 1 > table.getNumberOfColumns()) {
                TableEventProducer tableEventProducer = TableEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
                tableEventProducer.tooManyCells(this, this.getLocator());
            }
        } else {
            table.ensureColumnNumber(n + n2 - 1);
            while (this.pendingSpans.size() < n + n2 - 1) {
                this.pendingSpans.add(null);
            }
        }
        if (bl) {
            this.handleCellWidth(tableCell, n, n2);
        }
        if (n3 > 1) {
            for (int i = 0; i < n2; ++i) {
                this.pendingSpans.set(n - 1 + i, new PendingSpan(n3));
            }
        }
        this.columnNumberManager.signalUsedColumnNumbers(n, n + n2 - 1);
        table.getRowGroupBuilder().addTableCell(tableCell);
    }

    private void handleCellWidth(TableCell tableCell, int n, int n2) throws FOPException {
        Table table = this.getTable();
        Length length = null;
        if (tableCell.getWidth().getEnum() != 9 && n2 == 1) {
            length = tableCell.getWidth();
        }
        for (int i = n; i < n + n2; ++i) {
            TableColumn tableColumn = table.getColumn(i - 1);
            if (length == null) continue;
            tableColumn.setColumnWidth(length);
        }
    }

    abstract TablePart getTablePart();

    public ColumnNumberManager getColumnNumberManager() {
        return this.columnNumberManager;
    }

    public CommonAccessibility getCommonAccessibility() {
        return this.commonAccessibility;
    }
}

