/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow.table;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.flow.table.TableEventProducer;
import org.apache.fop.fo.flow.table.TableFObj;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.TableColLength;
import org.apache.fop.layoutmgr.table.CollapsingBorderModel;
import org.xml.sax.Locator;

public class TableColumn
extends TableFObj {
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private int columnNumber;
    private Length columnWidth;
    private int numberColumnsRepeated;
    private int numberColumnsSpanned;
    private boolean implicitColumn;
    private PropertyList pList = null;

    public TableColumn(FONode fONode) {
        this(fONode, false);
    }

    public TableColumn(FONode fONode, boolean bl) {
        super(fONode);
        this.implicitColumn = bl;
    }

    public void bind(PropertyList propertyList) throws FOPException {
        TableEventProducer tableEventProducer;
        this.commonBorderPaddingBackground = propertyList.getBorderPaddingBackgroundProps();
        this.columnNumber = propertyList.get(76).getNumeric().getValue();
        this.columnWidth = propertyList.get(77).getLength();
        this.numberColumnsRepeated = propertyList.get(164).getNumeric().getValue();
        this.numberColumnsSpanned = propertyList.get(165).getNumeric().getValue();
        super.bind(propertyList);
        if (this.numberColumnsRepeated <= 0) {
            tableEventProducer = TableEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            tableEventProducer.valueMustBeBiggerGtEqOne(this, "number-columns-repeated", this.numberColumnsRepeated, this.getLocator());
        }
        if (this.numberColumnsSpanned <= 0) {
            tableEventProducer = TableEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            tableEventProducer.valueMustBeBiggerGtEqOne(this, "number-columns-spanned", this.numberColumnsSpanned, this.getLocator());
        }
        if (this.columnWidth.getEnum() == 9) {
            if (!this.implicitColumn && !this.getTable().isAutoLayout()) {
                tableEventProducer = TableEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
                tableEventProducer.warnImplicitColumns(this, this.getLocator());
            }
            this.columnWidth = new TableColLength(1.0, this);
        }
        if (!this.implicitColumn) {
            this.pList = propertyList;
        }
    }

    public void startOfNode() throws FOPException {
        super.startOfNode();
        this.getFOEventHandler().startColumn(this);
    }

    void setCollapsedBorders(CollapsingBorderModel collapsingBorderModel) {
        this.collapsingBorderModel = collapsingBorderModel;
        this.setCollapsedBorders();
    }

    public void endOfNode() throws FOPException {
        this.getFOEventHandler().endColumn(this);
    }

    protected void validateChildNode(Locator locator, String string, String string2) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(string)) {
            this.invalidChildError(locator, string, string2);
        }
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public Length getColumnWidth() {
        return this.columnWidth;
    }

    public void setColumnWidth(Length length) {
        this.columnWidth = length;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    protected void setColumnNumber(int n) {
        this.columnNumber = n;
    }

    public int getNumberColumnsRepeated() {
        return this.numberColumnsRepeated;
    }

    public int getNumberColumnsSpanned() {
        return this.numberColumnsSpanned;
    }

    public String getLocalName() {
        return "table-column";
    }

    public int getNameId() {
        return 76;
    }

    public boolean isImplicitColumn() {
        return this.implicitColumn;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("fo:table-column");
        stringBuffer.append(" column-number=").append(this.getColumnNumber());
        if (this.getNumberColumnsRepeated() > 1) {
            stringBuffer.append(" number-columns-repeated=").append(this.getNumberColumnsRepeated());
        }
        if (this.getNumberColumnsSpanned() > 1) {
            stringBuffer.append(" number-columns-spanned=").append(this.getNumberColumnsSpanned());
        }
        stringBuffer.append(" column-width=").append(((Property)((Object)this.getColumnWidth())).getString());
        return stringBuffer.toString();
    }

    public Property getProperty(int n) throws PropertyException {
        return this.pList.get(n);
    }

    protected void releasePropertyList() {
        this.pList = null;
    }
}

