/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.awt.Rectangle;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.FODimension;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.pagination.Region;
import org.apache.fop.fo.properties.CommonMarginBlock;

public class RegionBody
extends Region {
    private CommonMarginBlock commonMarginBlock;
    private Numeric columnCount;
    private Length columnGap;

    public RegionBody(FONode fONode) {
        super(fONode);
    }

    public void bind(PropertyList propertyList) throws FOPException {
        super.bind(propertyList);
        this.commonMarginBlock = propertyList.getMarginBlockProps();
        this.columnCount = propertyList.get(74).getNumeric();
        this.columnGap = propertyList.get(75).getLength();
        if (this.getColumnCount() > 1 && this.getOverflow() == 126) {
            this.getFOValidationEventProducer().columnCountErrorOnRegionBodyOverflowScroll(this, this.getName(), this.getLocator());
        }
    }

    public CommonMarginBlock getCommonMarginBlock() {
        return this.commonMarginBlock;
    }

    public int getColumnCount() {
        return this.columnCount.getValue();
    }

    public int getColumnGap() {
        return this.columnGap.getValue();
    }

    public Rectangle getViewportRectangle(FODimension fODimension) {
        int n;
        int n2;
        PercentBaseContext percentBaseContext = this.getPageWidthContext(5);
        PercentBaseContext percentBaseContext2 = this.getPageHeightContext(5);
        switch (this.getWritingMode().getEnumValue()) {
            case 121: {
                n2 = this.commonMarginBlock.marginRight.getValue(percentBaseContext);
                n = this.commonMarginBlock.marginLeft.getValue(percentBaseContext);
                break;
            }
            case 140: 
            case 205: {
                n2 = this.commonMarginBlock.marginTop.getValue(percentBaseContext);
                n = this.commonMarginBlock.marginBottom.getValue(percentBaseContext);
                break;
            }
            default: {
                n2 = this.commonMarginBlock.marginLeft.getValue(percentBaseContext);
                n = this.commonMarginBlock.marginRight.getValue(percentBaseContext);
            }
        }
        int n3 = this.commonMarginBlock.spaceBefore.getOptimum(percentBaseContext2).getLength().getValue(percentBaseContext2);
        int n4 = this.commonMarginBlock.spaceAfter.getOptimum(percentBaseContext2).getLength().getValue(percentBaseContext2);
        return new Rectangle(n2, n3, fODimension.ipd - n2 - n, fODimension.bpd - n3 - n4);
    }

    protected String getDefaultRegionName() {
        return "xsl-region-body";
    }

    public String getLocalName() {
        return "region-body";
    }

    public int getNameId() {
        return 58;
    }
}

