/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import java.awt.Color;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyCache;
import org.apache.fop.fo.properties.PropertyMaker;
import org.apache.xmlgraphics.java2d.color.ColorUtil;

public final class ColorProperty
extends Property {
    private static final PropertyCache<ColorProperty> CACHE = new PropertyCache();
    protected final Color color;

    public static ColorProperty getInstance(FOUserAgent fOUserAgent, String string) throws PropertyException {
        ColorProperty colorProperty = new ColorProperty(org.apache.fop.util.ColorUtil.parseColorString(fOUserAgent, string));
        return CACHE.fetch(colorProperty);
    }

    private ColorProperty(Color color) {
        this.color = color;
    }

    public Color getColor(FOUserAgent fOUserAgent) {
        return this.color;
    }

    public String toString() {
        return org.apache.fop.util.ColorUtil.colorToString(this.color);
    }

    public ColorProperty getColorProperty() {
        return this;
    }

    public Object getObject() {
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ColorProperty) {
            return ColorUtil.isSameColor((Color)((ColorProperty)object).color, (Color)this.color);
        }
        return false;
    }

    public int hashCode() {
        return this.color.hashCode();
    }

    public static class Maker
    extends PropertyMaker {
        public Maker(int n) {
            super(n);
        }

        public Property convertProperty(Property property, PropertyList propertyList, FObj fObj) throws PropertyException {
            if (property instanceof ColorProperty) {
                return property;
            }
            FObj fObj2 = fObj == null ? propertyList.getFObj() : fObj;
            FOUserAgent fOUserAgent = fObj2 == null ? null : fObj2.getUserAgent();
            Color color = property.getColor(fOUserAgent);
            if (color != null) {
                return new ColorProperty(color);
            }
            return this.convertPropertyDatatype(property, propertyList, fObj);
        }
    }
}

