/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

public final class FontUtil {
    private static final String[] ITALIC_WORDS = new String[]{"italic", "oblique", "inclined"};
    private static final String[] LIGHT_WORDS = new String[]{"light"};
    private static final String[] MEDIUM_WORDS = new String[]{"medium"};
    private static final String[] DEMI_WORDS = new String[]{"demi", "semi"};
    private static final String[] BOLD_WORDS = new String[]{"bold"};
    private static final String[] EXTRA_BOLD_WORDS = new String[]{"extrabold", "extra bold", "black", "heavy", "ultra", "super"};

    private FontUtil() {
    }

    public static int parseCSS2FontWeight(String string) {
        int n = 400;
        try {
            n = Integer.parseInt(string);
            n = n / 100 * 100;
            n = Math.max(n, 100);
            n = Math.min(n, 900);
        }
        catch (NumberFormatException numberFormatException) {
            if (string.equals("normal")) {
                n = 400;
            }
            if (string.equals("bold")) {
                n = 700;
            }
            throw new IllegalArgumentException("Illegal value for font weight: '" + string + "'. Use one of: 100, 200, 300, " + "400, 500, 600, 700, 800, 900, " + "normal (=400), bold (=700)");
        }
        return n;
    }

    public static String stripWhiteSpace(String string) {
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == ' ' || c == '\r' || c == '\n' || c == '\t') continue;
                stringBuffer.append(c);
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public static String guessStyle(String string) {
        if (string != null) {
            for (int i = 0; i < ITALIC_WORDS.length; ++i) {
                if (string.indexOf(ITALIC_WORDS[i]) == -1) continue;
                return "italic";
            }
        }
        return "normal";
    }

    public static int guessWeight(String string) {
        int n;
        int n2 = 400;
        for (n = 0; n < BOLD_WORDS.length; ++n) {
            if (string.indexOf(BOLD_WORDS[n]) == -1) continue;
            n2 = 700;
            break;
        }
        for (n = 0; n < MEDIUM_WORDS.length; ++n) {
            if (string.indexOf(MEDIUM_WORDS[n]) == -1) continue;
            n2 = 500;
            break;
        }
        for (n = 0; n < DEMI_WORDS.length; ++n) {
            if (string.indexOf(DEMI_WORDS[n]) == -1) continue;
            n2 = 600;
            break;
        }
        for (n = 0; n < EXTRA_BOLD_WORDS.length; ++n) {
            if (string.indexOf(EXTRA_BOLD_WORDS[n]) == -1) continue;
            n2 = 800;
            break;
        }
        for (n = 0; n < LIGHT_WORDS.length; ++n) {
            if (string.indexOf(LIGHT_WORDS[n]) == -1) continue;
            n2 = 200;
            break;
        }
        return n2;
    }
}

