/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.base14;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.fop.fonts.Base14Font;
import org.apache.fop.fonts.CodePointMapping;
import org.apache.fop.fonts.FontType;

public class TimesBoldItalic
extends Base14Font {
    private static final String fontName = "Times-BoldItalic";
    private static final String fullName = "Times Bold Italic";
    private static final Set familyNames;
    private static final String encoding = "WinAnsiEncoding";
    private static final int capHeight = 669;
    private static final int xHeight = 462;
    private static final int ascender = 699;
    private static final int descender = -205;
    private static final int firstChar = 32;
    private static final int lastChar = 255;
    private static final int[] width;
    private final CodePointMapping mapping = CodePointMapping.getMapping("WinAnsiEncoding");
    private static final Map kerning;
    private boolean enableKerning = false;

    public TimesBoldItalic() {
        this(false);
    }

    public TimesBoldItalic(boolean bl) {
        this.enableKerning = bl;
    }

    public String getEncodingName() {
        return encoding;
    }

    public String getFontName() {
        return fontName;
    }

    public String getEmbedFontName() {
        return this.getFontName();
    }

    public String getFullName() {
        return fullName;
    }

    public Set getFamilyNames() {
        return familyNames;
    }

    public FontType getFontType() {
        return FontType.TYPE1;
    }

    public int getAscender(int n) {
        return n * 699;
    }

    public int getCapHeight(int n) {
        return n * 669;
    }

    public int getDescender(int n) {
        return n * -205;
    }

    public int getXHeight(int n) {
        return n * 462;
    }

    public int getFirstChar() {
        return 32;
    }

    public int getLastChar() {
        return 255;
    }

    public int getWidth(int n, int n2) {
        return n2 * width[n];
    }

    public int[] getWidths() {
        int[] nArray = new int[this.getLastChar() - this.getFirstChar() + 1];
        System.arraycopy(width, this.getFirstChar(), nArray, 0, this.getLastChar() - this.getFirstChar() + 1);
        return nArray;
    }

    public boolean hasKerningInfo() {
        return this.enableKerning;
    }

    public Map getKerningInfo() {
        return kerning;
    }

    public char mapChar(char c) {
        this.notifyMapOperation();
        char c2 = this.mapping.mapChar(c);
        if (c2 != '\u0000') {
            return c2;
        }
        this.warnMissingGlyph(c);
        return '#';
    }

    public boolean hasChar(char c) {
        return this.mapping.mapChar(c) > '\u0000';
    }

    static {
        width = new int[256];
        TimesBoldItalic.width[65] = 667;
        TimesBoldItalic.width[198] = 944;
        TimesBoldItalic.width[193] = 667;
        TimesBoldItalic.width[194] = 667;
        TimesBoldItalic.width[196] = 667;
        TimesBoldItalic.width[192] = 667;
        TimesBoldItalic.width[197] = 667;
        TimesBoldItalic.width[195] = 667;
        TimesBoldItalic.width[66] = 667;
        TimesBoldItalic.width[67] = 667;
        TimesBoldItalic.width[199] = 667;
        TimesBoldItalic.width[68] = 722;
        TimesBoldItalic.width[69] = 667;
        TimesBoldItalic.width[201] = 667;
        TimesBoldItalic.width[202] = 667;
        TimesBoldItalic.width[203] = 667;
        TimesBoldItalic.width[200] = 667;
        TimesBoldItalic.width[208] = 722;
        TimesBoldItalic.width[128] = 500;
        TimesBoldItalic.width[70] = 667;
        TimesBoldItalic.width[71] = 722;
        TimesBoldItalic.width[72] = 778;
        TimesBoldItalic.width[73] = 389;
        TimesBoldItalic.width[205] = 389;
        TimesBoldItalic.width[206] = 389;
        TimesBoldItalic.width[207] = 389;
        TimesBoldItalic.width[204] = 389;
        TimesBoldItalic.width[74] = 500;
        TimesBoldItalic.width[75] = 667;
        TimesBoldItalic.width[76] = 611;
        TimesBoldItalic.width[77] = 889;
        TimesBoldItalic.width[78] = 722;
        TimesBoldItalic.width[209] = 722;
        TimesBoldItalic.width[79] = 722;
        TimesBoldItalic.width[140] = 944;
        TimesBoldItalic.width[211] = 722;
        TimesBoldItalic.width[212] = 722;
        TimesBoldItalic.width[214] = 722;
        TimesBoldItalic.width[210] = 722;
        TimesBoldItalic.width[216] = 722;
        TimesBoldItalic.width[213] = 722;
        TimesBoldItalic.width[80] = 611;
        TimesBoldItalic.width[81] = 722;
        TimesBoldItalic.width[82] = 667;
        TimesBoldItalic.width[83] = 556;
        TimesBoldItalic.width[138] = 556;
        TimesBoldItalic.width[84] = 611;
        TimesBoldItalic.width[222] = 611;
        TimesBoldItalic.width[85] = 722;
        TimesBoldItalic.width[218] = 722;
        TimesBoldItalic.width[219] = 722;
        TimesBoldItalic.width[220] = 722;
        TimesBoldItalic.width[217] = 722;
        TimesBoldItalic.width[86] = 667;
        TimesBoldItalic.width[87] = 889;
        TimesBoldItalic.width[88] = 667;
        TimesBoldItalic.width[89] = 611;
        TimesBoldItalic.width[221] = 611;
        TimesBoldItalic.width[159] = 611;
        TimesBoldItalic.width[90] = 611;
        TimesBoldItalic.width[142] = 611;
        TimesBoldItalic.width[97] = 500;
        TimesBoldItalic.width[225] = 500;
        TimesBoldItalic.width[226] = 500;
        TimesBoldItalic.width[180] = 333;
        TimesBoldItalic.width[228] = 500;
        TimesBoldItalic.width[230] = 722;
        TimesBoldItalic.width[224] = 500;
        TimesBoldItalic.width[38] = 778;
        TimesBoldItalic.width[229] = 500;
        TimesBoldItalic.width[94] = 570;
        TimesBoldItalic.width[126] = 570;
        TimesBoldItalic.width[42] = 500;
        TimesBoldItalic.width[64] = 832;
        TimesBoldItalic.width[227] = 500;
        TimesBoldItalic.width[98] = 500;
        TimesBoldItalic.width[92] = 278;
        TimesBoldItalic.width[124] = 220;
        TimesBoldItalic.width[123] = 348;
        TimesBoldItalic.width[125] = 348;
        TimesBoldItalic.width[91] = 333;
        TimesBoldItalic.width[93] = 333;
        TimesBoldItalic.width[166] = 220;
        TimesBoldItalic.width[149] = 350;
        TimesBoldItalic.width[99] = 444;
        TimesBoldItalic.width[231] = 444;
        TimesBoldItalic.width[184] = 333;
        TimesBoldItalic.width[162] = 500;
        TimesBoldItalic.width[136] = 333;
        TimesBoldItalic.width[58] = 333;
        TimesBoldItalic.width[44] = 250;
        TimesBoldItalic.width[169] = 747;
        TimesBoldItalic.width[164] = 500;
        TimesBoldItalic.width[100] = 500;
        TimesBoldItalic.width[134] = 500;
        TimesBoldItalic.width[135] = 500;
        TimesBoldItalic.width[176] = 400;
        TimesBoldItalic.width[168] = 333;
        TimesBoldItalic.width[247] = 570;
        TimesBoldItalic.width[36] = 500;
        TimesBoldItalic.width[101] = 444;
        TimesBoldItalic.width[233] = 444;
        TimesBoldItalic.width[234] = 444;
        TimesBoldItalic.width[235] = 444;
        TimesBoldItalic.width[232] = 444;
        TimesBoldItalic.width[56] = 500;
        TimesBoldItalic.width[133] = 1000;
        TimesBoldItalic.width[151] = 1000;
        TimesBoldItalic.width[150] = 500;
        TimesBoldItalic.width[61] = 570;
        TimesBoldItalic.width[240] = 500;
        TimesBoldItalic.width[33] = 389;
        TimesBoldItalic.width[161] = 389;
        TimesBoldItalic.width[102] = 333;
        TimesBoldItalic.width[53] = 500;
        TimesBoldItalic.width[131] = 500;
        TimesBoldItalic.width[52] = 500;
        TimesBoldItalic.width[103] = 500;
        TimesBoldItalic.width[223] = 500;
        TimesBoldItalic.width[96] = 333;
        TimesBoldItalic.width[62] = 570;
        TimesBoldItalic.width[171] = 500;
        TimesBoldItalic.width[187] = 500;
        TimesBoldItalic.width[139] = 333;
        TimesBoldItalic.width[155] = 333;
        TimesBoldItalic.width[104] = 556;
        TimesBoldItalic.width[45] = 333;
        TimesBoldItalic.width[105] = 278;
        TimesBoldItalic.width[237] = 278;
        TimesBoldItalic.width[238] = 278;
        TimesBoldItalic.width[239] = 278;
        TimesBoldItalic.width[236] = 278;
        TimesBoldItalic.width[106] = 278;
        TimesBoldItalic.width[107] = 500;
        TimesBoldItalic.width[108] = 278;
        TimesBoldItalic.width[60] = 570;
        TimesBoldItalic.width[172] = 606;
        TimesBoldItalic.width[109] = 778;
        TimesBoldItalic.width[175] = 333;
        TimesBoldItalic.width[181] = 576;
        TimesBoldItalic.width[215] = 570;
        TimesBoldItalic.width[110] = 556;
        TimesBoldItalic.width[57] = 500;
        TimesBoldItalic.width[241] = 556;
        TimesBoldItalic.width[35] = 500;
        TimesBoldItalic.width[111] = 500;
        TimesBoldItalic.width[243] = 500;
        TimesBoldItalic.width[244] = 500;
        TimesBoldItalic.width[246] = 500;
        TimesBoldItalic.width[156] = 722;
        TimesBoldItalic.width[242] = 500;
        TimesBoldItalic.width[49] = 500;
        TimesBoldItalic.width[189] = 750;
        TimesBoldItalic.width[188] = 750;
        TimesBoldItalic.width[185] = 300;
        TimesBoldItalic.width[170] = 266;
        TimesBoldItalic.width[186] = 300;
        TimesBoldItalic.width[248] = 500;
        TimesBoldItalic.width[245] = 500;
        TimesBoldItalic.width[112] = 500;
        TimesBoldItalic.width[182] = 500;
        TimesBoldItalic.width[40] = 333;
        TimesBoldItalic.width[41] = 333;
        TimesBoldItalic.width[37] = 833;
        TimesBoldItalic.width[46] = 250;
        TimesBoldItalic.width[183] = 250;
        TimesBoldItalic.width[137] = 1000;
        TimesBoldItalic.width[43] = 570;
        TimesBoldItalic.width[177] = 570;
        TimesBoldItalic.width[113] = 500;
        TimesBoldItalic.width[63] = 500;
        TimesBoldItalic.width[191] = 500;
        TimesBoldItalic.width[34] = 555;
        TimesBoldItalic.width[132] = 500;
        TimesBoldItalic.width[147] = 500;
        TimesBoldItalic.width[148] = 500;
        TimesBoldItalic.width[145] = 333;
        TimesBoldItalic.width[146] = 333;
        TimesBoldItalic.width[130] = 333;
        TimesBoldItalic.width[39] = 278;
        TimesBoldItalic.width[114] = 389;
        TimesBoldItalic.width[174] = 747;
        TimesBoldItalic.width[115] = 389;
        TimesBoldItalic.width[154] = 389;
        TimesBoldItalic.width[167] = 500;
        TimesBoldItalic.width[59] = 333;
        TimesBoldItalic.width[55] = 500;
        TimesBoldItalic.width[54] = 500;
        TimesBoldItalic.width[47] = 278;
        TimesBoldItalic.width[32] = 250;
        TimesBoldItalic.width[163] = 500;
        TimesBoldItalic.width[116] = 278;
        TimesBoldItalic.width[254] = 500;
        TimesBoldItalic.width[51] = 500;
        TimesBoldItalic.width[190] = 750;
        TimesBoldItalic.width[179] = 300;
        TimesBoldItalic.width[152] = 333;
        TimesBoldItalic.width[153] = 1000;
        TimesBoldItalic.width[50] = 500;
        TimesBoldItalic.width[178] = 300;
        TimesBoldItalic.width[117] = 556;
        TimesBoldItalic.width[250] = 556;
        TimesBoldItalic.width[251] = 556;
        TimesBoldItalic.width[252] = 556;
        TimesBoldItalic.width[249] = 556;
        TimesBoldItalic.width[95] = 500;
        TimesBoldItalic.width[118] = 444;
        TimesBoldItalic.width[119] = 667;
        TimesBoldItalic.width[120] = 500;
        TimesBoldItalic.width[121] = 444;
        TimesBoldItalic.width[253] = 444;
        TimesBoldItalic.width[255] = 444;
        TimesBoldItalic.width[165] = 500;
        TimesBoldItalic.width[122] = 389;
        TimesBoldItalic.width[158] = 389;
        TimesBoldItalic.width[48] = 500;
        kerning = new HashMap();
        Integer n = new Integer(79);
        Map<Integer, Integer> map = (HashMap<Integer, Integer>)kerning.get(n);
        if (map == null) {
            map = new HashMap<Integer, Integer>();
            kerning.put(n, map);
        }
        Integer n2 = new Integer(65);
        map.put(n2, new Integer(-40));
        n2 = new Integer(87);
        map.put(n2, new Integer(-50));
        n2 = new Integer(89);
        map.put(n2, new Integer(-50));
        n2 = new Integer(84);
        map.put(n2, new Integer(-40));
        n2 = new Integer(46);
        map.put(n2, new Integer(0));
        n2 = new Integer(86);
        map.put(n2, new Integer(-50));
        n2 = new Integer(88);
        map.put(n2, new Integer(-40));
        n2 = new Integer(44);
        map.put(n2, new Integer(0));
        n = new Integer(107);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-10));
        n2 = new Integer(121);
        map.put(n2, new Integer(0));
        n2 = new Integer(101);
        map.put(n2, new Integer(-30));
        n = new Integer(112);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(121);
        map.put(n2, new Integer(0));
        n = new Integer(80);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-55));
        n2 = new Integer(97);
        map.put(n2, new Integer(-40));
        n2 = new Integer(65);
        map.put(n2, new Integer(-85));
        n2 = new Integer(46);
        map.put(n2, new Integer(-129));
        n2 = new Integer(101);
        map.put(n2, new Integer(-50));
        n2 = new Integer(44);
        map.put(n2, new Integer(-129));
        n = new Integer(86);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-111));
        n2 = new Integer(79);
        map.put(n2, new Integer(-30));
        n2 = new Integer(58);
        map.put(n2, new Integer(-74));
        n2 = new Integer(71);
        map.put(n2, new Integer(-10));
        n2 = new Integer(44);
        map.put(n2, new Integer(-129));
        n2 = new Integer(59);
        map.put(n2, new Integer(-74));
        n2 = new Integer(45);
        map.put(n2, new Integer(-70));
        n2 = new Integer(105);
        map.put(n2, new Integer(-55));
        n2 = new Integer(65);
        map.put(n2, new Integer(-85));
        n2 = new Integer(97);
        map.put(n2, new Integer(-111));
        n2 = new Integer(117);
        map.put(n2, new Integer(-55));
        n2 = new Integer(46);
        map.put(n2, new Integer(-129));
        n2 = new Integer(101);
        map.put(n2, new Integer(-111));
        n = new Integer(118);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-15));
        n2 = new Integer(97);
        map.put(n2, new Integer(0));
        n2 = new Integer(46);
        map.put(n2, new Integer(-37));
        n2 = new Integer(101);
        map.put(n2, new Integer(-15));
        n2 = new Integer(44);
        map.put(n2, new Integer(-37));
        n = new Integer(32);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(65);
        map.put(n2, new Integer(-37));
        n2 = new Integer(87);
        map.put(n2, new Integer(-70));
        n2 = new Integer(147);
        map.put(n2, new Integer(0));
        n2 = new Integer(89);
        map.put(n2, new Integer(-70));
        n2 = new Integer(84);
        map.put(n2, new Integer(0));
        n2 = new Integer(145);
        map.put(n2, new Integer(0));
        n2 = new Integer(86);
        map.put(n2, new Integer(-70));
        n = new Integer(97);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(119);
        map.put(n2, new Integer(0));
        n2 = new Integer(116);
        map.put(n2, new Integer(0));
        n2 = new Integer(121);
        map.put(n2, new Integer(0));
        n2 = new Integer(112);
        map.put(n2, new Integer(0));
        n2 = new Integer(103);
        map.put(n2, new Integer(0));
        n2 = new Integer(98);
        map.put(n2, new Integer(0));
        n2 = new Integer(118);
        map.put(n2, new Integer(0));
        n = new Integer(70);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-70));
        n2 = new Integer(105);
        map.put(n2, new Integer(-40));
        n2 = new Integer(114);
        map.put(n2, new Integer(-50));
        n2 = new Integer(97);
        map.put(n2, new Integer(-95));
        n2 = new Integer(65);
        map.put(n2, new Integer(-100));
        n2 = new Integer(46);
        map.put(n2, new Integer(-129));
        n2 = new Integer(101);
        map.put(n2, new Integer(-100));
        n2 = new Integer(44);
        map.put(n2, new Integer(-129));
        n = new Integer(85);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(65);
        map.put(n2, new Integer(-45));
        n2 = new Integer(46);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(0));
        n = new Integer(100);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(100);
        map.put(n2, new Integer(0));
        n2 = new Integer(119);
        map.put(n2, new Integer(0));
        n2 = new Integer(121);
        map.put(n2, new Integer(0));
        n2 = new Integer(46);
        map.put(n2, new Integer(0));
        n2 = new Integer(118);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(0));
        n = new Integer(83);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(46);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(0));
        n = new Integer(122);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(0));
        n2 = new Integer(101);
        map.put(n2, new Integer(0));
        n = new Integer(68);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(65);
        map.put(n2, new Integer(-25));
        n2 = new Integer(87);
        map.put(n2, new Integer(-40));
        n2 = new Integer(89);
        map.put(n2, new Integer(-50));
        n2 = new Integer(46);
        map.put(n2, new Integer(0));
        n2 = new Integer(86);
        map.put(n2, new Integer(-50));
        n2 = new Integer(44);
        map.put(n2, new Integer(0));
        n = new Integer(146);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(148);
        map.put(n2, new Integer(0));
        n2 = new Integer(100);
        map.put(n2, new Integer(-15));
        n2 = new Integer(32);
        map.put(n2, new Integer(-74));
        n2 = new Integer(146);
        map.put(n2, new Integer(-74));
        n2 = new Integer(114);
        map.put(n2, new Integer(-15));
        n2 = new Integer(116);
        map.put(n2, new Integer(-37));
        n2 = new Integer(108);
        map.put(n2, new Integer(0));
        n2 = new Integer(115);
        map.put(n2, new Integer(-74));
        n2 = new Integer(118);
        map.put(n2, new Integer(-15));
        n = new Integer(58);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(32);
        map.put(n2, new Integer(0));
        n = new Integer(119);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-15));
        n2 = new Integer(97);
        map.put(n2, new Integer(-10));
        n2 = new Integer(104);
        map.put(n2, new Integer(0));
        n2 = new Integer(46);
        map.put(n2, new Integer(-37));
        n2 = new Integer(101);
        map.put(n2, new Integer(-10));
        n2 = new Integer(44);
        map.put(n2, new Integer(-37));
        n = new Integer(75);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-25));
        n2 = new Integer(79);
        map.put(n2, new Integer(-30));
        n2 = new Integer(117);
        map.put(n2, new Integer(-20));
        n2 = new Integer(121);
        map.put(n2, new Integer(-20));
        n2 = new Integer(101);
        map.put(n2, new Integer(-25));
        n = new Integer(82);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(79);
        map.put(n2, new Integer(-40));
        n2 = new Integer(87);
        map.put(n2, new Integer(-18));
        n2 = new Integer(85);
        map.put(n2, new Integer(-40));
        n2 = new Integer(89);
        map.put(n2, new Integer(-18));
        n2 = new Integer(84);
        map.put(n2, new Integer(-30));
        n2 = new Integer(86);
        map.put(n2, new Integer(-18));
        n = new Integer(145);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(65);
        map.put(n2, new Integer(0));
        n2 = new Integer(145);
        map.put(n2, new Integer(-74));
        n = new Integer(103);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(0));
        n2 = new Integer(105);
        map.put(n2, new Integer(0));
        n2 = new Integer(114);
        map.put(n2, new Integer(0));
        n2 = new Integer(97);
        map.put(n2, new Integer(0));
        n2 = new Integer(121);
        map.put(n2, new Integer(0));
        n2 = new Integer(46);
        map.put(n2, new Integer(0));
        n2 = new Integer(103);
        map.put(n2, new Integer(0));
        n2 = new Integer(101);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(0));
        n = new Integer(66);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(65);
        map.put(n2, new Integer(-25));
        n2 = new Integer(85);
        map.put(n2, new Integer(-10));
        n2 = new Integer(46);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(0));
        n = new Integer(98);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(117);
        map.put(n2, new Integer(-20));
        n2 = new Integer(121);
        map.put(n2, new Integer(0));
        n2 = new Integer(46);
        map.put(n2, new Integer(-40));
        n2 = new Integer(108);
        map.put(n2, new Integer(0));
        n2 = new Integer(98);
        map.put(n2, new Integer(-10));
        n2 = new Integer(118);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(0));
        n = new Integer(81);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(85);
        map.put(n2, new Integer(-10));
        n2 = new Integer(46);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(0));
        n = new Integer(44);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(148);
        map.put(n2, new Integer(-95));
        n2 = new Integer(32);
        map.put(n2, new Integer(0));
        n2 = new Integer(146);
        map.put(n2, new Integer(-95));
        n = new Integer(102);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(148);
        map.put(n2, new Integer(0));
        n2 = new Integer(111);
        map.put(n2, new Integer(-10));
        n2 = new Integer(105);
        map.put(n2, new Integer(0));
        n2 = new Integer(146);
        map.put(n2, new Integer(55));
        n2 = new Integer(97);
        map.put(n2, new Integer(0));
        n2 = new Integer(102);
        map.put(n2, new Integer(-18));
        n2 = new Integer(46);
        map.put(n2, new Integer(-10));
        n2 = new Integer(108);
        map.put(n2, new Integer(0));
        n2 = new Integer(101);
        map.put(n2, new Integer(-10));
        n2 = new Integer(44);
        map.put(n2, new Integer(-10));
        n = new Integer(84);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-95));
        n2 = new Integer(79);
        map.put(n2, new Integer(-18));
        n2 = new Integer(119);
        map.put(n2, new Integer(-37));
        n2 = new Integer(58);
        map.put(n2, new Integer(-74));
        n2 = new Integer(114);
        map.put(n2, new Integer(-37));
        n2 = new Integer(104);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(-92));
        n2 = new Integer(59);
        map.put(n2, new Integer(-74));
        n2 = new Integer(45);
        map.put(n2, new Integer(-92));
        n2 = new Integer(105);
        map.put(n2, new Integer(-37));
        n2 = new Integer(65);
        map.put(n2, new Integer(-55));
        n2 = new Integer(97);
        map.put(n2, new Integer(-92));
        n2 = new Integer(117);
        map.put(n2, new Integer(-37));
        n2 = new Integer(121);
        map.put(n2, new Integer(-37));
        n2 = new Integer(46);
        map.put(n2, new Integer(-92));
        n2 = new Integer(101);
        map.put(n2, new Integer(-92));
        n = new Integer(121);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(0));
        n2 = new Integer(97);
        map.put(n2, new Integer(0));
        n2 = new Integer(46);
        map.put(n2, new Integer(-37));
        n2 = new Integer(101);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(-37));
        n = new Integer(120);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(101);
        map.put(n2, new Integer(-10));
        n = new Integer(101);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(119);
        map.put(n2, new Integer(0));
        n2 = new Integer(121);
        map.put(n2, new Integer(0));
        n2 = new Integer(112);
        map.put(n2, new Integer(0));
        n2 = new Integer(46);
        map.put(n2, new Integer(0));
        n2 = new Integer(103);
        map.put(n2, new Integer(0));
        n2 = new Integer(98);
        map.put(n2, new Integer(-10));
        n2 = new Integer(120);
        map.put(n2, new Integer(0));
        n2 = new Integer(118);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(0));
        n = new Integer(99);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(107);
        map.put(n2, new Integer(-10));
        n2 = new Integer(104);
        map.put(n2, new Integer(-10));
        n2 = new Integer(121);
        map.put(n2, new Integer(0));
        n2 = new Integer(46);
        map.put(n2, new Integer(0));
        n2 = new Integer(108);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(0));
        n = new Integer(87);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-80));
        n2 = new Integer(79);
        map.put(n2, new Integer(-15));
        n2 = new Integer(58);
        map.put(n2, new Integer(-55));
        n2 = new Integer(104);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(-74));
        n2 = new Integer(59);
        map.put(n2, new Integer(-55));
        n2 = new Integer(45);
        map.put(n2, new Integer(-50));
        n2 = new Integer(105);
        map.put(n2, new Integer(-37));
        n2 = new Integer(65);
        map.put(n2, new Integer(-74));
        n2 = new Integer(97);
        map.put(n2, new Integer(-85));
        n2 = new Integer(117);
        map.put(n2, new Integer(-55));
        n2 = new Integer(121);
        map.put(n2, new Integer(-55));
        n2 = new Integer(46);
        map.put(n2, new Integer(-74));
        n2 = new Integer(101);
        map.put(n2, new Integer(-90));
        n = new Integer(104);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(121);
        map.put(n2, new Integer(0));
        n = new Integer(71);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(46);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(0));
        n = new Integer(105);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(118);
        map.put(n2, new Integer(0));
        n = new Integer(65);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(79);
        map.put(n2, new Integer(-50));
        n2 = new Integer(146);
        map.put(n2, new Integer(-74));
        n2 = new Integer(119);
        map.put(n2, new Integer(-74));
        n2 = new Integer(87);
        map.put(n2, new Integer(-100));
        n2 = new Integer(67);
        map.put(n2, new Integer(-65));
        n2 = new Integer(112);
        map.put(n2, new Integer(0));
        n2 = new Integer(81);
        map.put(n2, new Integer(-55));
        n2 = new Integer(71);
        map.put(n2, new Integer(-60));
        n2 = new Integer(86);
        map.put(n2, new Integer(-95));
        n2 = new Integer(118);
        map.put(n2, new Integer(-74));
        n2 = new Integer(148);
        map.put(n2, new Integer(0));
        n2 = new Integer(85);
        map.put(n2, new Integer(-50));
        n2 = new Integer(117);
        map.put(n2, new Integer(-30));
        n2 = new Integer(89);
        map.put(n2, new Integer(-70));
        n2 = new Integer(121);
        map.put(n2, new Integer(-74));
        n2 = new Integer(84);
        map.put(n2, new Integer(-55));
        n = new Integer(147);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(65);
        map.put(n2, new Integer(0));
        n2 = new Integer(145);
        map.put(n2, new Integer(0));
        n = new Integer(78);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(65);
        map.put(n2, new Integer(-30));
        n2 = new Integer(46);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(0));
        n = new Integer(115);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(119);
        map.put(n2, new Integer(0));
        n = new Integer(111);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(119);
        map.put(n2, new Integer(-25));
        n2 = new Integer(121);
        map.put(n2, new Integer(-10));
        n2 = new Integer(103);
        map.put(n2, new Integer(0));
        n2 = new Integer(120);
        map.put(n2, new Integer(-10));
        n2 = new Integer(118);
        map.put(n2, new Integer(-15));
        n = new Integer(114);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(0));
        n2 = new Integer(100);
        map.put(n2, new Integer(0));
        n2 = new Integer(107);
        map.put(n2, new Integer(0));
        n2 = new Integer(114);
        map.put(n2, new Integer(0));
        n2 = new Integer(99);
        map.put(n2, new Integer(0));
        n2 = new Integer(112);
        map.put(n2, new Integer(0));
        n2 = new Integer(103);
        map.put(n2, new Integer(0));
        n2 = new Integer(108);
        map.put(n2, new Integer(0));
        n2 = new Integer(113);
        map.put(n2, new Integer(0));
        n2 = new Integer(118);
        map.put(n2, new Integer(0));
        n2 = new Integer(44);
        map.put(n2, new Integer(-65));
        n2 = new Integer(45);
        map.put(n2, new Integer(0));
        n2 = new Integer(105);
        map.put(n2, new Integer(0));
        n2 = new Integer(109);
        map.put(n2, new Integer(0));
        n2 = new Integer(97);
        map.put(n2, new Integer(0));
        n2 = new Integer(117);
        map.put(n2, new Integer(0));
        n2 = new Integer(116);
        map.put(n2, new Integer(0));
        n2 = new Integer(121);
        map.put(n2, new Integer(0));
        n2 = new Integer(46);
        map.put(n2, new Integer(-65));
        n2 = new Integer(110);
        map.put(n2, new Integer(0));
        n2 = new Integer(115);
        map.put(n2, new Integer(0));
        n2 = new Integer(101);
        map.put(n2, new Integer(0));
        n = new Integer(108);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(119);
        map.put(n2, new Integer(0));
        n2 = new Integer(121);
        map.put(n2, new Integer(0));
        n = new Integer(76);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(148);
        map.put(n2, new Integer(0));
        n2 = new Integer(146);
        map.put(n2, new Integer(-55));
        n2 = new Integer(87);
        map.put(n2, new Integer(-37));
        n2 = new Integer(89);
        map.put(n2, new Integer(-37));
        n2 = new Integer(121);
        map.put(n2, new Integer(-37));
        n2 = new Integer(84);
        map.put(n2, new Integer(-18));
        n2 = new Integer(86);
        map.put(n2, new Integer(-37));
        n = new Integer(148);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(32);
        map.put(n2, new Integer(0));
        n = new Integer(109);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(117);
        map.put(n2, new Integer(0));
        n2 = new Integer(121);
        map.put(n2, new Integer(0));
        n = new Integer(89);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-111));
        n2 = new Integer(45);
        map.put(n2, new Integer(-92));
        n2 = new Integer(105);
        map.put(n2, new Integer(-55));
        n2 = new Integer(79);
        map.put(n2, new Integer(-25));
        n2 = new Integer(58);
        map.put(n2, new Integer(-92));
        n2 = new Integer(97);
        map.put(n2, new Integer(-92));
        n2 = new Integer(65);
        map.put(n2, new Integer(-74));
        n2 = new Integer(117);
        map.put(n2, new Integer(-92));
        n2 = new Integer(46);
        map.put(n2, new Integer(-74));
        n2 = new Integer(101);
        map.put(n2, new Integer(-111));
        n2 = new Integer(59);
        map.put(n2, new Integer(-92));
        n2 = new Integer(44);
        map.put(n2, new Integer(-92));
        n = new Integer(74);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(111);
        map.put(n2, new Integer(-40));
        n2 = new Integer(97);
        map.put(n2, new Integer(-40));
        n2 = new Integer(65);
        map.put(n2, new Integer(-25));
        n2 = new Integer(117);
        map.put(n2, new Integer(-40));
        n2 = new Integer(46);
        map.put(n2, new Integer(-10));
        n2 = new Integer(101);
        map.put(n2, new Integer(-40));
        n2 = new Integer(44);
        map.put(n2, new Integer(-10));
        n = new Integer(46);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(148);
        map.put(n2, new Integer(-95));
        n2 = new Integer(146);
        map.put(n2, new Integer(-95));
        n = new Integer(110);
        map = (Map)kerning.get(n);
        if (map == null) {
            map = new HashMap();
            kerning.put(n, map);
        }
        n2 = new Integer(117);
        map.put(n2, new Integer(0));
        n2 = new Integer(121);
        map.put(n2, new Integer(0));
        n2 = new Integer(118);
        map.put(n2, new Integer(-40));
        familyNames = new HashSet();
        familyNames.add("Times");
    }
}

